/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;

public class CommandLineWrapperUtil {
    @NotNull
    public static File createClasspathJarFile(Manifest manifest, List<String> pathList) throws IOException {
        File file = CommandLineWrapperUtil.createClasspathJarFile(manifest, pathList, false);
        if (file == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(0);
        }
        return file;
    }

    @NotNull
    public static File createClasspathJarFile(Manifest manifest, List<String> pathList, boolean notEscape) throws IOException {
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        StringBuilder classPath = new StringBuilder();
        for (String path : pathList) {
            if (classPath.length() > 0) {
                classPath.append(' ');
            }
            File classpathElement = new File(path);
            String url = (notEscape ? classpathElement.toURL() : classpathElement.toURI().toURL()).toString();
            classPath.append(url);
        }
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPath.toString());
        File jarFile = FileUtil.createTempFile("classpath" + Math.abs(new Random().nextInt()), ".jar", true);
        new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(jarFile)), manifest).close();
        File file = jarFile;
        if (file == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(1);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineWrapperUtil", "createClasspathJarFile"));
    }
}

