/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ObjectNode<T> {
    private static final ObjectNode[] EMPTY_ARRAY = new ObjectNode[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectNode");
    private final ObjectTree<T> myTree;
    private ObjectNode<T> myParent;
    private final T myObject;
    private List<ObjectNode<T>> myChildren;
    private final Throwable myTrace;
    private final long myOwnModification;

    ObjectNode(@NotNull ObjectTree<T> tree, @Nullable ObjectNode<T> parentNode, @NotNull T object, long modification) {
        if (tree == null) {
            ObjectNode.$$$reportNull$$$0(0);
        }
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(1);
        }
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object;
        this.myTrace = Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
        this.myOwnModification = modification;
    }

    @NotNull
    private ObjectNode<T>[] getChildrenArray() {
        List<ObjectNode<ObjectNode>> children = this.myChildren;
        if (children == null || children.isEmpty()) {
            if (EMPTY_ARRAY == null) {
                ObjectNode.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        ObjectNode[] objectNodeArray = children.toArray(new ObjectNode[0]);
        if (objectNodeArray == null) {
            ObjectNode.$$$reportNull$$$0(3);
        }
        return objectNodeArray;
    }

    void addChild(@NotNull ObjectNode<T> child) {
        List<ObjectNode<T>> children;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(4);
        }
        if ((children = this.myChildren) == null) {
            this.myChildren = new SmartList<ObjectNode<T>>(child);
        } else {
            children.add(child);
        }
        child.myParent = this;
    }

    void removeChild(@NotNull ObjectNode<T> child) {
        List<ObjectNode<T>> children;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(5);
        }
        if ((children = this.myChildren) != null) {
            for (int i = children.size() - 1; i >= 0; --i) {
                ObjectNode<T> node = children.get(i);
                if (!node.equals(child)) continue;
                children.remove(i);
                break;
            }
        }
        child.myParent = null;
    }

    ObjectNode<T> getParent() {
        return this.myParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Collection<ObjectNode<T>> getChildren() {
        Object object = this.myTree.treeLock;
        // MONITORENTER : object
        if (this.myChildren == null) {
            List<ObjectNode<T>> list = Collections.emptyList();
            // MONITOREXIT : object
            if (list != null) return list;
            ObjectNode.$$$reportNull$$$0(6);
            return list;
        }
        Collection<ObjectNode<T>> collection = Collections.unmodifiableCollection(this.myChildren);
        // MONITOREXIT : object
        if (collection != null) return collection;
        ObjectNode.$$$reportNull$$$0(7);
        return collection;
    }

    void execute(final @NotNull ObjectTreeAction<T> action) {
        if (action == null) {
            ObjectNode.$$$reportNull$$$0(8);
        }
        ObjectTree.executeActionWithRecursiveGuard(this, this.myTree.getNodesInExecution(), new ObjectTreeAction<ObjectNode<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(@NotNull ObjectNode<T> each) {
                ObjectNode[] childrenArray;
                if (each == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    action.beforeTreeExecution(ObjectNode.this.myObject);
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                Object object = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                synchronized (object) {
                    childrenArray = ObjectNode.this.getChildrenArray();
                }
                SmartList<Throwable> exceptions = new SmartList<Throwable>();
                for (int i = childrenArray.length - 1; i >= 0; --i) {
                    try {
                        childrenArray[i].execute(action);
                        continue;
                    }
                    catch (Throwable e) {
                        exceptions.add(e);
                    }
                }
                Object i = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                synchronized (i) {
                    ObjectNode.this.myChildren = null;
                }
                try {
                    action.execute(ObjectNode.this.myObject);
                    ObjectNode.this.myTree.fireExecuted(ObjectNode.this.myObject);
                }
                catch (Throwable e) {
                    exceptions.add(e);
                }
                ObjectNode.this.remove();
                ObjectNode.handleExceptions(exceptions);
            }

            @Override
            public void beforeTreeExecution(@NotNull ObjectNode<T> parent) {
                if (parent == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "each";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/util/objectTree/ObjectNode$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeTreeExecution";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void handleExceptions(List<Throwable> exceptions) {
        if (!exceptions.isEmpty()) {
            for (Throwable exception : exceptions) {
                if (exception instanceof ProcessCanceledException) continue;
                LOG.error(exception);
            }
            ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
            if (pce != null) {
                throw pce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            this.myTree.putNode(this.myObject, null);
            if (this.myParent == null) {
                this.myTree.removeRootObject(this.myObject);
            } else {
                this.myParent.removeChild(this);
            }
        }
    }

    @NotNull
    T getObject() {
        T t = this.myObject;
        if (t == null) {
            ObjectNode.$$$reportNull$$$0(9);
        }
        return t;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject;
    }

    Throwable getTrace() {
        return this.myTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertNoReferencesKept(@NotNull T aDisposable) {
        if (aDisposable == null) {
            ObjectNode.$$$reportNull$$$0(10);
        }
        assert (this.getObject() != aDisposable);
        Object object = this.myTree.treeLock;
        synchronized (object) {
            if (this.myChildren != null) {
                for (ObjectNode<T> node : this.myChildren) {
                    node.assertNoReferencesKept(aDisposable);
                }
            }
        }
    }

    Throwable getAllocation() {
        return this.myTrace;
    }

    long getOwnModification() {
        return this.myOwnModification;
    }

    long getModification() {
        return this.getOwnModification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <D extends Disposable> D findChildEqualTo(@NotNull D object) {
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(11);
        }
        Object object2 = this.myTree.treeLock;
        synchronized (object2) {
            List<ObjectNode<T>> children = this.myChildren;
            if (children != null) {
                for (ObjectNode<T> node : children) {
                    T nodeObject = node.getObject();
                    if (!nodeObject.equals(object)) continue;
                    return (D)((Disposable)nodeObject);
                }
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/objectTree/ObjectNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/objectTree/ObjectNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenArray";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferencesKept";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findChildEqualTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

