/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMAnimatedLength;
import org.apache.batik.anim.dom.SVGOMRectElement;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SVGLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.SVGLoader");
    public static final LazyInitializer.NotNullValue<Double> MAX_SIZE = new LazyInitializer.NotNullValue<Double>(){

        @Override
        @NotNull
        public Double initialize() {
            double maxSize = 2.147483647E9;
            if (!GraphicsEnvironment.isHeadless()) {
                GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                AffineTransform tx = device.getDefaultConfiguration().getDefaultTransform();
                maxSize = (int)Math.max((double)bounds.width * tx.getScaleX(), (double)bounds.height * tx.getScaleY());
            }
            Double d = maxSize;
            if (d == null) {
                1.$$$reportNull$$$0(0);
            }
            return d;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/SVGLoader$1", "initialize"));
        }
    };
    private final TranscoderInput myInput;
    private final Size mySize;
    private BufferedImage myImage;

    public static Image load(@NotNull URL url, float scale) throws IOException {
        if (url == null) {
            SVGLoader.$$$reportNull$$$0(0);
        }
        return SVGLoader.load(url, url.openStream(), scale);
    }

    public static Image load(@NotNull InputStream stream, float scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(1);
        }
        return SVGLoader.load(null, stream, scale);
    }

    public static Image load(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(2);
        }
        try {
            return new SVGLoader(url, stream, scale).createImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, JBUI.ScaleContext ctx) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(3);
        }
        BufferedImage image = (BufferedImage)SVGLoader.load(url, stream, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
        return (T)((BufferedImage)ImageUtil.ensureHiDPI(image, ctx));
    }

    public static Couple<Integer> loadInfo(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(4);
        }
        SVGLoader loader = new SVGLoader(url, stream, scale);
        return Couple.of((int)loader.mySize.width, (int)loader.mySize.height);
    }

    public static double getMaxZoomFactor(@Nullable URL url, @NotNull InputStream stream, @NotNull JBUI.ScaleContext ctx) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(5);
        }
        if (ctx == null) {
            SVGLoader.$$$reportNull$$$0(6);
        }
        SVGLoader loader = new SVGLoader(url, stream, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
        return Math.min(MAX_SIZE.get() / loader.mySize.width, MAX_SIZE.get() / loader.mySize.height);
    }

    private SVGLoader(@Nullable URL url, InputStream stream, double scale) throws IOException {
        String uri = null;
        try {
            if (url != null && "jar".equals(url.getProtocol()) && stream != null) {
                url = new URL(url.getPath());
            }
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Document document = new MySAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument(uri, stream);
        if (document == null) {
            throw new IOException("document not created");
        }
        this.myInput = new TranscoderInput(document);
        this.mySize = Size.parse(document).scale(scale);
    }

    private BufferedImage createImage() throws TranscoderException {
        Size size = this.mySize.scaleToMaxSize();
        MyTranscoder r = new MyTranscoder();
        r.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, new Float(size.width));
        r.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, new Float(size.height));
        r.transcode(this.myInput, null);
        return this.myImage;
    }

    @NotNull
    private static SVGDocument createFallbackPlaceholder() {
        SVGDocument sVGDocument;
        try {
            String fallbackIcon = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 16 16\">\n  <rect x=\"1\" y=\"1\" width=\"14\" height=\"14\" fill=\"none\" stroke=\"red\" stroke-width=\"2\"/>\n  <line x1=\"1\" y1=\"1\" x2=\"15\" y2=\"15\" stroke=\"red\" stroke-width=\"2\"/>\n  <line x1=\"1\" y1=\"15\" x2=\"15\" y2=\"1\" stroke=\"red\" stroke-width=\"2\"/>\n</svg>\n";
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            sVGDocument = (SVGDocument)factory.createDocument(null, (Reader)new StringReader(fallbackIcon));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (sVGDocument == null) {
            SVGLoader.$$$reportNull$$$0(7);
        }
        return sVGDocument;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SVGLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SVGLoader";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFallbackPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadHiDPI";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMaxZoomFactor";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySVGDOMImplementation
    extends SVGDOMImplementation {
        private MySVGDOMImplementation() {
        }

        static {
            svg11Factories.put("rect", new SVGDOMImplementation.RectElementFactory(){

                public Element create(String prefix, Document doc) {
                    return new SVGOMRectElement(prefix, (AbstractDocument)doc){

                        protected SVGOMAnimatedLength createLiveAnimatedLength(String ns, String ln, String def, short dir, boolean nonneg) {
                            if (def == null && ("width".equals(ln) || "height".equals(ln))) {
                                def = "0";
                            }
                            return super.createLiveAnimatedLength(ns, ln, def, dir, nonneg);
                        }
                    };
                }
            });
        }
    }

    private static class MySAXSVGDocumentFactory
    extends SAXSVGDocumentFactory {
        public MySAXSVGDocumentFactory(String parser) {
            super(parser);
            this.implementation = new MySVGDOMImplementation();
        }
    }

    private class MyTranscoder
    extends ImageTranscoder {
        private MyTranscoder() {
        }

        public BufferedImage createImage(int w, int h) {
            return new BufferedImage(w, h, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) {
            SVGLoader.this.myImage = img;
        }

        protected UserAgent createUserAgent() {
            return new SVGAbstractTranscoder.SVGAbstractTranscoderUserAgent(){

                public SVGDocument getBrokenLinkDocument(Element e, String url, String message) {
                    LOG.warn(url + " " + message);
                    return SVGLoader.createFallbackPlaceholder();
                }
            };
        }
    }

    private static class Size {
        final double width;
        final double height;
        static final int FALLBACK_SIZE = 16;

        Size(double width, double height) {
            this.width = width;
            this.height = height;
        }

        Size scale(double scale) {
            return new Size(this.width * scale, this.height * scale);
        }

        Size scaleToMaxSize() {
            double w = this.width;
            double h = this.height;
            if (w > MAX_SIZE.get() || h > MAX_SIZE.get()) {
                double k = w >= h ? w / MAX_SIZE.get() : h / MAX_SIZE.get();
                w /= k;
                h /= k;
            }
            return new Size(w, h);
        }

        @NotNull
        public static Size parse(@NotNull Document document) {
            if (document == null) {
                Size.$$$reportNull$$$0(0);
            }
            Float width = Size.parseSize(document, "width");
            Float height = Size.parseSize(document, "height");
            if (width != null && height != null) {
                Size size = new Size(width.floatValue(), height.floatValue());
                if (size == null) {
                    Size.$$$reportNull$$$0(1);
                }
                return size;
            }
            Size viewBox = Size.parseViewBox(document);
            if (viewBox != null) {
                Size size = viewBox;
                if (size == null) {
                    Size.$$$reportNull$$$0(2);
                }
                return size;
            }
            Size size = new Size(16.0, 16.0);
            if (size == null) {
                Size.$$$reportNull$$$0(3);
            }
            return size;
        }

        @Nullable
        private static Float parseSize(@NotNull Document document, @NotNull String sizeName) {
            String value;
            if (document == null) {
                Size.$$$reportNull$$$0(4);
            }
            if (sizeName == null) {
                Size.$$$reportNull$$$0(5);
            }
            if ((value = document.getDocumentElement().getAttribute(sizeName)).endsWith("px")) {
                try {
                    return Float.valueOf(Float.parseFloat(value.substring(0, value.length() - 2)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Nullable
        private static Size parseViewBox(@NotNull Document document) {
            String value;
            if (document == null) {
                Size.$$$reportNull$$$0(6);
            }
            if ((value = document.getDocumentElement().getAttribute("viewBox")) == null || value.isEmpty()) {
                return null;
            }
            ArrayList<String> values = new ArrayList<String>(4);
            for (String token : StringUtil.tokenize(value, ", ")) {
                values.add(token);
            }
            if (values.size() == 4) {
                try {
                    return new Size(Float.parseFloat((String)values.get(2)), Float.parseFloat((String)values.get(3)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            LOG.warn("SVG file " + ObjectUtils.notNull(document.getBaseURI(), "") + " 'viewBox' expected in format: 'x y width height' or 'x, y, width, height'");
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/SVGLoader$Size";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sizeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/SVGLoader$Size";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parseSize";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "parseViewBox";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

