/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Verifier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStringUtil {
    private XmlStringUtil() {
    }

    @NotNull
    public static String wrapInCDATA(@NotNull String str) {
        if (str == null) {
            XmlStringUtil.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        int cur = 0;
        int len = str.length();
        while (cur < len) {
            int next = StringUtil.indexOf((CharSequence)str, "]]>", cur);
            next = next < 0 ? len : next + 1;
            sb.append("<![CDATA[").append(str.subSequence(cur, next)).append("]]>");
            cur = next;
        }
        String string = sb.toString();
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(value="null->null; !null->!null")
    public static String escapeString(@Nullable String str) {
        return XmlStringUtil.escapeString(str, false);
    }

    @Contract(value="null,_->null; !null,_->!null")
    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace) {
        return XmlStringUtil.escapeString(str, escapeWhiteSpace, true);
    }

    @Contract(value="null,_,_->null; !null,_,_->!null")
    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace, boolean convertNoBreakSpace) {
        if (str == null) {
            return null;
        }
        StringBuilder buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    entity = escapeWhiteSpace ? "&#10;" : null;
                    break;
                }
                case '\r': {
                    entity = escapeWhiteSpace ? "&#13;" : null;
                    break;
                }
                case '\t': {
                    entity = escapeWhiteSpace ? "&#9;" : null;
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\u00a0': {
                    entity = convertNoBreakSpace ? "&nbsp;" : null;
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str, 0, i);
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    @NotNull
    public static String wrapInHtml(@NotNull CharSequence result) {
        if (result == null) {
            XmlStringUtil.$$$reportNull$$$0(2);
        }
        String string = "<html>" + result + "</html>";
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String wrapInHtmlLines(CharSequence ... lines) {
        if (lines == null) {
            XmlStringUtil.$$$reportNull$$$0(4);
        }
        StringBuilder sb = new StringBuilder("<html>");
        for (int i = 0; i < lines.length; ++i) {
            CharSequence sequence = lines[i];
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append("<nobr>").append(sequence).append("</nobr>");
        }
        String string = sb.append("</html>").toString();
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isWrappedInHtml(@NotNull String tooltip) {
        if (tooltip == null) {
            XmlStringUtil.$$$reportNull$$$0(6);
        }
        return StringUtil.startsWithIgnoreCase(tooltip, "<html>") && StringUtil.endsWithIgnoreCase(tooltip, "</html>");
    }

    @NotNull
    public static String stripHtml(@NotNull String toolTip) {
        if (toolTip == null) {
            XmlStringUtil.$$$reportNull$$$0(7);
        }
        toolTip = StringUtil.trimStart(toolTip, "<html>");
        toolTip = StringUtil.trimStart(toolTip, "<body>");
        toolTip = StringUtil.trimEnd(toolTip, "</html>");
        String string = toolTip = StringUtil.trimEnd(toolTip, "</body>");
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String convertToHtmlContent(@NotNull String text) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(9);
        }
        String string = XmlStringUtil.isWrappedInHtml(text) ? XmlStringUtil.stripHtml(text) : XmlStringUtil.escapeString(text);
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String escapeIllegalXmlChars(@NotNull String text) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(11);
        }
        StringBuilder b = null;
        int lastPos = 0;
        for (int i = 0; i < text.length(); ++i) {
            int c = text.codePointAt(i);
            if (Character.isSupplementaryCodePoint(c)) {
                ++i;
            }
            if (c != 35 && Verifier.isXMLCharacter((int)c)) continue;
            if (b == null) {
                b = new StringBuilder(text.length() + 5);
            }
            b.append(text, lastPos, i).append('#');
            if (c != 35) {
                b.append(Integer.toHexString(c));
            }
            b.append('#');
            lastPos = i + 1;
        }
        String string = b == null ? text : b.append(text, lastPos, text.length()).toString();
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String unescapeIllegalXmlChars(@NotNull String text) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(13);
        }
        StringBuilder b = null;
        int lastPos = 0;
        for (int i = 0; i < text.length(); ++i) {
            int charCode;
            int numberEnd;
            char c = text.charAt(i);
            if (c != '#' || (numberEnd = text.indexOf(35, i + 1)) <= 0) continue;
            try {
                charCode = numberEnd == i + 1 ? 35 : Integer.parseInt(text.substring(i + 1, numberEnd), 16);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (b == null) {
                b = new StringBuilder(text.length());
            }
            b.append(text, lastPos, i);
            b.append((char)charCode);
            i = numberEnd;
            lastPos = i + 1;
        }
        String string = b == null ? text : b.append(text, lastPos, text.length()).toString();
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/XmlStringUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolTip";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/XmlStringUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInCDATA";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtml";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtmlLines";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToHtmlContent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeIllegalXmlChars";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeIllegalXmlChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCDATA";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtml";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtmlLines";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isWrappedInHtml";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertToHtmlContent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escapeIllegalXmlChars";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "unescapeIllegalXmlChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

