/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

class BufferingTextSplitter {
    @NotNull
    private final StringBuilder myLineBuffer;
    @NotNull
    private final Consumer<String> myLineConsumer;
    private boolean myCrLast;

    public BufferingTextSplitter(@NotNull Consumer<String> lineConsumer) {
        if (lineConsumer == null) {
            BufferingTextSplitter.$$$reportNull$$$0(0);
        }
        this.myLineBuffer = new StringBuilder();
        this.myCrLast = false;
        this.myLineConsumer = lineConsumer;
    }

    public void process(char[] input, int contentLength) {
        block4: for (int i = 0; i < contentLength; ++i) {
            char character = input[i];
            switch (character) {
                case '\n': {
                    this.myLineBuffer.append(character);
                    this.sendLine();
                    continue block4;
                }
                case '\r': {
                    if (this.myCrLast) {
                        this.sendLine();
                    }
                    this.myLineBuffer.append(character);
                    this.myCrLast = true;
                    continue block4;
                }
                default: {
                    if (this.myCrLast) {
                        this.sendLine();
                    }
                    this.myLineBuffer.append(character);
                }
            }
        }
    }

    public void flush() {
        if (this.myLineBuffer.length() > 0) {
            this.sendLine();
        }
    }

    private void sendLine() {
        String text = this.myLineBuffer.toString();
        this.myLineBuffer.setLength(0);
        this.myCrLast = false;
        this.myLineConsumer.accept(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineConsumer", "git4idea/commands/BufferingTextSplitter", "<init>"));
    }
}

