/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommandResult {
    private final boolean myStartFailed;
    private final int myExitCode;
    private final boolean myAuthenticationFailed;
    private final List<String> myErrorOutput;
    private final List<String> myOutput;

    public GitCommandResult(boolean startFailed, int exitCode, @NotNull List<String> errorOutput, @NotNull List<String> output) {
        if (errorOutput == null) {
            GitCommandResult.$$$reportNull$$$0(0);
        }
        if (output == null) {
            GitCommandResult.$$$reportNull$$$0(1);
        }
        this(startFailed, exitCode, false, errorOutput, output);
    }

    private GitCommandResult(boolean startFailed, int exitCode, boolean authenticationFailed, @NotNull List<String> errorOutput, @NotNull List<String> output) {
        if (errorOutput == null) {
            GitCommandResult.$$$reportNull$$$0(2);
        }
        if (output == null) {
            GitCommandResult.$$$reportNull$$$0(3);
        }
        this.myExitCode = exitCode;
        this.myStartFailed = startFailed;
        this.myAuthenticationFailed = authenticationFailed;
        this.myErrorOutput = errorOutput;
        this.myOutput = output;
    }

    @NotNull
    static GitCommandResult withAuthentication(@NotNull GitCommandResult result2, boolean authenticationFailed) {
        if (result2 == null) {
            GitCommandResult.$$$reportNull$$$0(4);
        }
        GitCommandResult gitCommandResult = new GitCommandResult(result2.myStartFailed, result2.myExitCode, authenticationFailed, result2.myErrorOutput, result2.myOutput);
        if (gitCommandResult == null) {
            GitCommandResult.$$$reportNull$$$0(5);
        }
        return gitCommandResult;
    }

    public boolean success() {
        return this.success(new int[0]);
    }

    public boolean success(int ... ignoredErrorCodes) {
        return !this.myStartFailed && (Arrays.stream(ignoredErrorCodes).anyMatch(i -> i == this.myExitCode) || this.myExitCode == 0);
    }

    @NotNull
    public List<String> getOutput() {
        List<String> list = Collections.unmodifiableList(this.myOutput);
        if (list == null) {
            GitCommandResult.$$$reportNull$$$0(6);
        }
        return list;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public boolean isAuthenticationFailed() {
        return this.myAuthenticationFailed;
    }

    @NotNull
    public List<String> getErrorOutput() {
        List<String> list = Collections.unmodifiableList(this.myErrorOutput);
        if (list == null) {
            GitCommandResult.$$$reportNull$$$0(7);
        }
        return list;
    }

    public String toString() {
        return String.format("{%d} %nOutput: %n%s %nError output: %n%s", this.myExitCode, this.myOutput, this.myErrorOutput);
    }

    @NotNull
    public String getErrorOutputAsHtmlString() {
        String string = StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), (String)"<br/>");
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getErrorOutputAsJoinedString() {
        String string = StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), (String)"\n");
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private List<String> getErrorOrStdOutput() {
        List<String> list = this.myErrorOutput.isEmpty() && !this.success() ? this.myOutput : this.myErrorOutput;
        if (list == null) {
            GitCommandResult.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public String getOutputAsJoinedString() {
        String string = StringUtil.join(this.myOutput, (String)"\n");
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getOutputOrThrow(int ... ignoredErrorCodes) throws VcsException {
        if (!this.success(ignoredErrorCodes)) {
            throw new VcsException(this.getErrorOutputAsJoinedString());
        }
        String string = this.getOutputAsJoinedString();
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Deprecated
    @Nullable
    public Throwable getException() {
        return null;
    }

    @NotNull
    static GitCommandResult startError(@NotNull String error) {
        if (error == null) {
            GitCommandResult.$$$reportNull$$$0(13);
        }
        GitCommandResult gitCommandResult = new GitCommandResult(true, -1, Collections.singletonList(error), Collections.emptyList());
        if (gitCommandResult == null) {
            GitCommandResult.$$$reportNull$$$0(14);
        }
        return gitCommandResult;
    }

    @NotNull
    public static GitCommandResult error(@NotNull String error) {
        if (error == null) {
            GitCommandResult.$$$reportNull$$$0(15);
        }
        GitCommandResult gitCommandResult = new GitCommandResult(false, 1, Collections.singletonList(error), Collections.emptyList());
        if (gitCommandResult == null) {
            GitCommandResult.$$$reportNull$$$0(16);
        }
        return gitCommandResult;
    }

    public boolean cancelled() {
        return false;
    }

    @NotNull
    private static Collection<String> cleanup(@NotNull Collection<String> errorOutput) {
        if (errorOutput == null) {
            GitCommandResult.$$$reportNull$$$0(17);
        }
        List list = ContainerUtil.map(errorOutput, errorMessage -> GitUtil.cleanupErrorPrefixes(errorMessage));
        if (list == null) {
            GitCommandResult.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorOutput";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitCommandResult";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitCommandResult";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withAuthentication";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutput";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOutput";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOutputAsHtmlString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOutputAsJoinedString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOrStdOutput";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputAsJoinedString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputOrThrow";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "startError";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withAuthentication";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startError";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

