/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitLogRecordCollector
implements Consumer<GitLogRecord> {
    private static final Logger LOG = Logger.getInstance(GitLogRecordCollector.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VirtualFile myRoot;
    @NotNull
    protected final Consumer<List<GitLogRecord>> myConsumer;
    @NotNull
    private final MultiMap<String, GitLogRecord> myHashToRecord;
    @Nullable
    private String myLastHash;

    protected GitLogRecordCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<List<GitLogRecord>> consumer) {
        if (project == null) {
            GitLogRecordCollector.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitLogRecordCollector.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            GitLogRecordCollector.$$$reportNull$$$0(2);
        }
        this.myHashToRecord = MultiMap.createLinked();
        this.myLastHash = null;
        this.myProject = project;
        this.myRoot = root;
        this.myConsumer = consumer;
    }

    public void consume(@NotNull GitLogRecord record) {
        if (record == null) {
            GitLogRecordCollector.$$$reportNull$$$0(3);
        }
        if (!record.getHash().equals(this.myLastHash)) {
            this.processCollectedRecords();
        }
        this.myLastHash = record.getHash();
        this.myHashToRecord.putValue((Object)record.getHash(), (Object)record);
        String[] parents = record.getParentsHashes();
        if (parents.length == 0 || parents.length == this.myHashToRecord.get((Object)record.getHash()).size()) {
            this.processCollectedRecords();
        }
    }

    public void finish() {
        this.processCollectedRecords();
    }

    protected void processCollectedRecords() {
        for (String hash : this.myHashToRecord.keySet()) {
            ArrayList records = ContainerUtil.newArrayList((Iterable)((Iterable)ObjectUtils.notNull((Object)this.myHashToRecord.get((Object)hash))));
            GitLogRecord firstRecord = (GitLogRecord)records.get(0);
            if (firstRecord.getParentsHashes().length != 0 && records.size() != firstRecord.getParentsHashes().length) {
                this.processIncompleteRecord(hash, records);
                continue;
            }
            this.myConsumer.consume((Object)records);
        }
        this.myHashToRecord.clear();
    }

    protected void processIncompleteRecord(@NotNull String hash, @NotNull List<GitLogRecord> records) {
        if (hash == null) {
            GitLogRecordCollector.$$$reportNull$$$0(4);
        }
        if (records == null) {
            GitLogRecordCollector.$$$reportNull$$$0(5);
        }
        MultiMap incompleteRecords = MultiMap.create();
        incompleteRecords.put((Object)hash, records);
        try {
            GitLogRecordCollector.processIncompleteRecords((MultiMap<String, GitLogRecord>)incompleteRecords, this.myProject, this.myRoot, this.myConsumer);
        }
        catch (VcsException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void processIncompleteRecords(@NotNull MultiMap<String, GitLogRecord> incompleteRecords, @NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<List<GitLogRecord>> consumer) throws VcsException {
        if (incompleteRecords == null) {
            GitLogRecordCollector.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GitLogRecordCollector.$$$reportNull$$$0(7);
        }
        if (root == null) {
            GitLogRecordCollector.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            GitLogRecordCollector.$$$reportNull$$$0(9);
        }
        List firstRecords = ContainerUtil.map((Collection)incompleteRecords.entrySet(), e -> (GitLogRecord)ContainerUtil.getFirstItem((Collection)((Collection)e.getValue())));
        Map<String, String> hashToTreeMap = GitLogRecordCollector.getHashToTreeMap(project, root, firstRecords);
        for (String hash : incompleteRecords.keySet()) {
            ArrayList records = ContainerUtil.newArrayList((Iterable)((Iterable)ObjectUtils.notNull((Object)incompleteRecords.get((Object)hash))));
            GitLogRecordCollector.fillWithEmptyRecords(records, hashToTreeMap);
            consumer.consume((Object)records);
        }
    }

    @NotNull
    private static Map<String, String> getHashToTreeMap(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<GitLogRecord> records) throws VcsException {
        if (project == null) {
            GitLogRecordCollector.$$$reportNull$$$0(10);
        }
        if (root == null) {
            GitLogRecordCollector.$$$reportNull$$$0(11);
        }
        if (records == null) {
            GitLogRecordCollector.$$$reportNull$$$0(12);
        }
        HashSet hashes2 = ContainerUtil.newHashSet();
        for (GitLogRecord r : records) {
            hashes2.add(r.getHash());
            ContainerUtil.addAll((Collection)hashes2, (Object[])r.getParentsHashes());
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.TREE);
        GitVcs vcs = GitVcs.getInstance(project);
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty());
        handler.addParameters(GitLogUtil.getNoWalkParameter(vcs));
        handler.addParameters("--stdin");
        handler.endOptions();
        GitLogUtil.sendHashesToStdin(vcs, hashes2, handler);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        List<GitLogRecord> hashAndTreeRecords = parser.parse(output);
        Map map2 = ContainerUtil.map2Map(hashAndTreeRecords, record -> Pair.create((Object)record.getHash(), (Object)record.getTreeHash()));
        if (map2 == null) {
            GitLogRecordCollector.$$$reportNull$$$0(13);
        }
        return map2;
    }

    private static void fillWithEmptyRecords(@NotNull List<GitLogRecord> records, @NotNull Map<String, String> hashToTreeMap) {
        if (records == null) {
            GitLogRecordCollector.$$$reportNull$$$0(14);
        }
        if (hashToTreeMap == null) {
            GitLogRecordCollector.$$$reportNull$$$0(15);
        }
        GitLogRecord firstRecord = records.get(0);
        String commit2 = firstRecord.getHash();
        String[] parents = firstRecord.getParentsHashes();
        String commitTreeHash = hashToTreeMap.get(commit2);
        LOG.assertTrue(commitTreeHash != null, (Object)("Could not get tree hash for commit " + commit2));
        for (int parentIndex = 0; parentIndex < parents.length; ++parentIndex) {
            String parent = parents[parentIndex];
            String parentTreeHash = hashToTreeMap.get(parent);
            LOG.assertTrue(parentTreeHash != null, (Object)("Could not get tree hash for commit " + parent));
            if (!parentTreeHash.equals(commitTreeHash) || records.size() >= parents.length) continue;
            records.add(parentIndex, new GitLogRecord(firstRecord.getOptions(), ContainerUtil.emptyList(), firstRecord.isSupportsRawBody()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 5: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompleteRecords";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogRecordCollector";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashToTreeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogRecordCollector";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashToTreeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processIncompleteRecord";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processIncompleteRecords";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHashToTreeMap";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fillWithEmptyRecords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

