/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.i18n.GitBundle;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.stash.GitChangesSaver;
import git4idea.stash.GitShelveUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitShelveChangesSaver
extends GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitShelveChangesSaver.class);
    private final ShelveChangesManager myShelveManager;
    private final ShelvedChangesViewManager myShelveViewManager;
    private final ProjectLevelVcsManager myVcsManager;
    private Map<String, ShelvedChangeList> myShelvedLists;

    public GitShelveChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator, String stashMessage) {
        if (project == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(2);
        }
        super(project, git, indicator, stashMessage);
        this.myShelveManager = ShelveChangesManager.getInstance((Project)this.myProject);
        this.myShelveViewManager = ShelvedChangesViewManager.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Override
    protected void save(@NotNull Collection<VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(3);
        }
        LOG.info("save " + rootsToSave);
        Map lists = new LocalChangesUnderRoots((ChangeListManager)this.myChangeManager, this.myVcsManager).getChangesByLists(rootsToSave);
        String oldProgressTitle = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText(GitBundle.getString("update.shelving.changes"));
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>(1);
        this.myShelvedLists = new HashMap<String, ShelvedChangeList>();
        for (Map.Entry entry : lists.entrySet()) {
            Map map2 = (Map)entry.getValue();
            HashSet<Change> changes = new HashSet<Change>();
            for (Collection changeCollection : map2.values()) {
                changes.addAll(changeCollection);
            }
            if (changes.isEmpty()) continue;
            ShelvedChangeList list = GitShelveUtils.shelveChanges(this.myProject, this.myShelveManager, changes, ChangeListUtil.createSystemShelvedChangeListName((String)this.myStashMessage, (String)((String)entry.getKey())), exceptions, false, true);
            this.myShelvedLists.put((String)entry.getKey(), list);
        }
        if (!exceptions.isEmpty()) {
            LOG.info("save " + exceptions, (Throwable)exceptions.get(0));
            this.myShelvedLists = null;
            throw (VcsException)((Object)exceptions.get(0));
        }
        for (VirtualFile root : rootsToSave) {
            GitRollbackEnvironment.resetHardLocal(this.myProject, root);
        }
        this.myProgressIndicator.setText(oldProgressTitle);
    }

    @Override
    public void load() {
        if (this.myShelvedLists != null) {
            LOG.info("load ");
            String oldProgressTitle = this.myProgressIndicator.getText();
            this.myProgressIndicator.setText(GitBundle.getString("update.unshelving.changes"));
            for (ShelvedChangeList list : this.myShelvedLists.values()) {
                GitShelveUtils.doSystemUnshelve(this.myProject, list, this.myShelveManager, GitShelveChangesSaver.getConflictLeftPanelTitle(), GitShelveChangesSaver.getConflictRightPanelTitle());
            }
            this.myProgressIndicator.setText(oldProgressTitle);
        }
    }

    @Override
    public boolean wereChangesSaved() {
        return this.myShelvedLists != null && !this.myShelvedLists.isEmpty();
    }

    @Override
    public String getSaverName() {
        return "shelf";
    }

    @Override
    @NotNull
    public String getOperationName() {
        if ("shelve" == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(4);
        }
        return "shelve";
    }

    @Override
    public void showSavedChanges() {
        this.myShelveViewManager.activateView(this.myShelvedLists.get(this.myShelvedLists.keySet().iterator().next()));
    }

    public String toString() {
        return "ShelveChangesSaver. Lists: " + this.myShelvedLists;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/stash/GitShelveChangesSaver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/stash/GitShelveChangesSaver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

