/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.stash.GitStashUtils;
import git4idea.ui.GitUnstashDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitStashChangesSaver
extends GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitStashChangesSaver.class);
    private static final String NO_LOCAL_CHANGES_TO_SAVE = "No local changes to save";
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final Set<VirtualFile> myStashedRoots;

    public GitStashChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull String stashMessage) {
        if (project == null) {
            GitStashChangesSaver.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitStashChangesSaver.$$$reportNull$$$0(1);
        }
        if (progressIndicator == null) {
            GitStashChangesSaver.$$$reportNull$$$0(2);
        }
        if (stashMessage == null) {
            GitStashChangesSaver.$$$reportNull$$$0(3);
        }
        super(project, git, progressIndicator, stashMessage);
        this.myStashedRoots = ContainerUtil.newHashSet();
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
    }

    @Override
    protected void save(@NotNull Collection<VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null) {
            GitStashChangesSaver.$$$reportNull$$$0(4);
        }
        LOG.info("saving " + rootsToSave);
        for (VirtualFile root : rootsToSave) {
            String message = "Stashing changes from '" + root.getName() + "'...";
            LOG.info(message);
            String oldProgressTitle = this.myProgressIndicator.getText();
            this.myProgressIndicator.setText(message);
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.error("Repository is null for root " + root);
            } else {
                GitCommandResult result2 = this.myGit.stashSave(repository, this.myStashMessage);
                if (result2.success() && GitStashChangesSaver.somethingWasStashed(result2)) {
                    this.myStashedRoots.add(root);
                } else {
                    if (!result2.success()) {
                        throw new VcsException("Couldn't stash " + repository.getRoot() + ": " + result2.getErrorOutputAsJoinedString());
                    }
                    LOG.warn("There was nothing to stash in " + repository.getRoot());
                }
            }
            this.myProgressIndicator.setText(oldProgressTitle);
        }
    }

    private static boolean somethingWasStashed(@NotNull GitCommandResult result2) {
        if (result2 == null) {
            GitStashChangesSaver.$$$reportNull$$$0(5);
        }
        return !StringUtil.containsIgnoreCase((String)result2.getErrorOutputAsJoinedString(), (String)NO_LOCAL_CHANGES_TO_SAVE) && !StringUtil.containsIgnoreCase((String)result2.getOutputAsJoinedString(), (String)NO_LOCAL_CHANGES_TO_SAVE);
    }

    @Override
    public void load() {
        GitStashUtils.unstash(this.myProject, this.myStashedRoots, (Function1<? super VirtualFile, ? extends GitLineHandler>)((Function1)root -> {
            GitLineHandler handler = new GitLineHandler(this.myProject, (VirtualFile)root, GitCommand.STASH);
            handler.addParameters("pop");
            return handler;
        }), (GitConflictResolver)new UnstashConflictResolver(this.myProject, this.myGit, this.myStashedRoots, this.myParams));
    }

    @Override
    public boolean wereChangesSaved() {
        return !this.myStashedRoots.isEmpty();
    }

    @Override
    public String getSaverName() {
        return "stash";
    }

    @Override
    @NotNull
    public String getOperationName() {
        if ("stash" == null) {
            GitStashChangesSaver.$$$reportNull$$$0(6);
        }
        return "stash";
    }

    @Override
    public void showSavedChanges() {
        GitUnstashDialog.showUnstashDialog(this.myProject, new ArrayList<VirtualFile>(this.myStashedRoots), this.myStashedRoots.iterator().next());
    }

    public String toString() {
        return "StashChangesSaver. Roots: " + this.myStashedRoots;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stashMessage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/stash/GitStashChangesSaver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/stash/GitStashChangesSaver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "somethingWasStashed";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnstashMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private UnstashMergeDialogCustomizer() {
        }

        @NotNull
        public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
            if (files == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(0);
            }
            if ("Uncommitted changes that were stashed before update have conflicts with updated files." == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(1);
            }
            return "Uncommitted changes that were stashed before update have conflicts with updated files.";
        }

        @NotNull
        public String getLeftPanelTitle(@NotNull VirtualFile file) {
            if (file == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(2);
            }
            String string = GitChangesSaver.getConflictLeftPanelTitle();
            if (string == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getRightPanelTitle(@NotNull VirtualFile file, VcsRevisionNumber revisionNumber) {
            if (file == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(4);
            }
            String string = GitChangesSaver.getConflictRightPanelTitle();
            if (string == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/stash/GitStashChangesSaver$UnstashMergeDialogCustomizer";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/stash/GitStashChangesSaver$UnstashMergeDialogCustomizer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMultipleFileMergeDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeftPanelTitle";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRightPanelTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMultipleFileMergeDescription";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLeftPanelTitle";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getRightPanelTitle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnstashConflictResolver
    extends GitConflictResolver {
        private final Set<VirtualFile> myStashedRoots;

        public UnstashConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull Set<VirtualFile> stashedRoots, @Nullable GitConflictResolver.Params params) {
            if (project == null) {
                UnstashConflictResolver.$$$reportNull$$$0(0);
            }
            if (git == null) {
                UnstashConflictResolver.$$$reportNull$$$0(1);
            }
            if (stashedRoots == null) {
                UnstashConflictResolver.$$$reportNull$$$0(2);
            }
            super(project, git, stashedRoots, UnstashConflictResolver.makeParamsOrUse(params, project));
            this.myStashedRoots = stashedRoots;
        }

        private static GitConflictResolver.Params makeParamsOrUse(@Nullable GitConflictResolver.Params givenParams, Project project) {
            if (givenParams != null) {
                return givenParams;
            }
            GitConflictResolver.Params params = new GitConflictResolver.Params(project);
            params.setErrorNotificationTitle("Local changes were not restored");
            params.setMergeDialogCustomizer(new UnstashMergeDialogCustomizer());
            params.setReverse(true);
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Local changes were restored with conflicts", "Your uncommitted changes were saved to <a href='saver'>stash</a>.<br/>Unstash is not complete, you have unresolved merges in your working tree<br/><a href='resolve'>Resolve</a> conflicts and drop the stash.", new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (event.getDescription().equals("saver")) {
                            GitUnstashDialog.showUnstashDialog(myProject, new ArrayList<VirtualFile>(myStashedRoots), (VirtualFile)myStashedRoots.iterator().next());
                        } else if (event.getDescription().equals("resolve")) {
                            this.mergeNoProceed();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "git4idea/stash/GitStashChangesSaver$UnstashConflictResolver$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "git";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stashedRoots";
                    break;
                }
            }
            objectArray[1] = "git4idea/stash/GitStashChangesSaver$UnstashConflictResolver";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

