/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H$J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0014Jk\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00150\u001d26\u0010 \u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150!H\u0016J1\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010&\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u0002H%0\u001dH\u0016\u00a2\u0006\u0002\u0010'J \u0010(\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "Lorg/jetbrains/settingsRepository/RepositoryManager;", "dir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getDir", "()Ljava/nio/file/Path;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "addToIndex", "", "file", "path", "", "content", "", "size", "", "delete", "", "deleteFromIndex", "isFile", "deleteRepository", "has", "isPathIgnored", "processChildren", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "inputStream", "read", "R", "consumer", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "write", "intellij.settingsRepository"})
public abstract class BaseRepositoryManager
implements RepositoryManager {
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Path dir;

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void processChildren(@NotNull String path, @NotNull Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Path path2 = this.dir.resolve(path);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"dir.resolve(path)");
        Path path3 = path2;
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(filter){
            final /* synthetic */ Function1 $filter;

            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Boolean)this.$filter.invoke((Object)((Object)it.getFileName()).toString());
            }
            {
                this.$filter = function1;
                super(1);
            }
        };
        try {
            void $receiver$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$receiver$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                final /* synthetic */ Function1 $filter;
                {
                    this.$filter = function1;
                }

                public final boolean accept(Path it) {
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path);
                }
            });
            Throwable throwable = null;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                for (Path file : it) {
                    boolean bl;
                    BasicFileAttributes attributes;
                    try {
                        Path path4 = file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"file");
                        attributes = PathKt.basicAttributesIfExists((Path)path4);
                    }
                    catch (IOException e) {
                        IcsManagerKt.getLOG().warn((Throwable)e);
                        continue;
                    }
                    if (attributes == null || attributes.isDirectory() || PathKt.isHidden((Path)file)) continue;
                    if (attributes.size() == 0L) {
                        Logger $receiver$iv2 = IcsManagerKt.getLOG();
                        try {
                            IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                            this.delete(file, path);
                        }
                        catch (ProcessCanceledException e$iv) {
                        }
                        catch (Throwable e$iv) {
                            $receiver$iv2.error(e$iv);
                        }
                        continue;
                    }
                    Closeable closeable2 = PathKt.inputStream((Path)file);
                    Throwable throwable2 = null;
                    try {
                        InputStream it2 = (InputStream)closeable2;
                        bl = (Boolean)processor.invoke((Object)((Object)file.getFileName()).toString(), (Object)it2);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    if (bl) continue;
                    break;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
    }

    @Override
    public void deleteRepository() {
        PathKt.delete((Path)this.dir);
    }

    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R read(@NotNull String path, @NotNull Function1<? super InputStream, ? extends R> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        Path fileToDelete = null;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Path file;
            Path path2 = file = this.dir.resolve(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
            long l = PathKt.sizeOrNull((Path)path2);
            if (l == -1L) {
                Object object = consumer.invoke(null);
                return (R)object;
            }
            if (l != 0L) {
                Object object;
                Closeable closeable = PathKt.inputStream((Path)file);
                Function1<? super InputStream, ? extends R> function1 = consumer;
                Throwable throwable = null;
                try {
                    object = function1.invoke((Object)closeable);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Object object2 = object;
                return (R)object2;
            }
            fileToDelete = file;
            file = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        Logger $receiver$iv = IcsManagerKt.getLOG();
        try {
            if (PathKt.sizeOrNull((Path)fileToDelete) == 0L) {
                IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                this.delete(fileToDelete, path);
            }
        }
        catch (ProcessCanceledException e$iv) {
        }
        catch (Throwable e$iv) {
            $receiver$iv.error(e$iv);
        }
        return (R)consumer.invoke(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(@NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Object $receiver$iv = IcsManagerKt.getLOG();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Write " + path;
            logger.debug(string, (Throwable)e$iv);
        }
        try {
            int n;
            $receiver$iv = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)$receiver$iv).readLock();
            int n2 = ((ReentrantReadWriteLock)$receiver$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$receiver$iv).getReadHoldCount() : 0;
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                n = n3++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)$receiver$iv).writeLock();
            writeLock.lock();
            try {
                Path file;
                Path path2 = file = this.dir.resolve(path);
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                PathKt.write((Path)path2, (byte[])content, (int)0, (int)size);
                if (this.isPathIgnored(path)) {
                    Logger $receiver$iv2 = IcsManagerKt.getLOG();
                    Exception e$iv2 = null;
                    if ($receiver$iv2.isDebugEnabled()) {
                        Logger logger = $receiver$iv2;
                        String string = path + " is ignored and will be not added to index";
                        logger.debug(string, (Throwable)e$iv2);
                    }
                } else {
                    this.addToIndex(file, path, content, size);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                int n5 = n2;
                while (n < n5) {
                    int n6 = n++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
            return false;
        }
        return true;
    }

    protected abstract void addToIndex(@NotNull Path var1, @NotNull String var2, @NotNull byte[] var3, int var4);

    @Override
    public boolean delete(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Logger $receiver$iv = IcsManagerKt.getLOG();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Remove " + path;
            logger.debug(string, (Throwable)e$iv);
        }
        Path path2 = this.dir.resolve(path);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"dir.resolve(path)");
        return this.delete(path2, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean delete(Path file, String path) {
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)file);
        if (basicFileAttributes == null) {
            return false;
        }
        BasicFileAttributes fileAttributes = basicFileAttributes;
        boolean isFile = fileAttributes.isRegularFile();
        if (!PathKt.deleteWithParentsIfEmpty((Path)file, (Path)this.dir, (boolean)isFile)) {
            return false;
        }
        if (!this.isPathIgnored(path)) {
            int n;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                n = n3++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                this.deleteFromIndex(path, isFile);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                int n5 = n2;
                while (n < n5) {
                    int n6 = n++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        return true;
    }

    protected abstract void deleteFromIndex(@NotNull String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(@NotNull String path) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Path path2 = this.dir.resolve(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"dir.resolve(path)");
            bl = PathKt.exists((Path)path2);
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    @NotNull
    protected final Path getDir() {
        return this.dir;
    }

    public BaseRepositoryManager(@NotNull Path dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.dir = dir;
        this.lock = new ReentrantReadWriteLock();
    }
}

