/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.mahout.math.matrix.impl;

import org.carrot2.mahout.math.function.DoubleDoubleFunction;
import org.carrot2.mahout.math.function.DoubleFunction;
import org.carrot2.mahout.math.function.Functions;
import org.carrot2.mahout.math.function.Mult;
import org.carrot2.mahout.math.function.PlusMult;
import org.carrot2.mahout.math.matrix.DoubleMatrix1D;
import org.carrot2.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.mahout.math.matrix.impl.DenseDoubleMatrix1D;
import org.carrot2.mahout.math.matrix.impl.SelectedDenseDoubleMatrix2D;
import org.carrot2.mahout.math.matrix.impl.SparseDoubleMatrix2D;

public final class DenseDoubleMatrix2D
extends DoubleMatrix2D {
    final double[] elements;

    public DenseDoubleMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseDoubleMatrix2D(int rows, int columns) {
        this.setUp(rows, columns);
        this.elements = new double[rows * columns];
    }

    public static DoubleMatrix2D identity(int rowsAndColumns) {
        DenseDoubleMatrix2D matrix = new DenseDoubleMatrix2D(rowsAndColumns, rowsAndColumns);
        int i = rowsAndColumns;
        while (--i >= 0) {
            ((DoubleMatrix2D)matrix).setQuick(i, i, 1.0);
        }
        return matrix;
    }

    @Override
    public void assign(double[][] values) {
        if (this.isNoView) {
            if (values.length != this.rows) {
                throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
            }
            int i = this.columns * (this.rows - 1);
            int row = this.rows;
            while (--row >= 0) {
                double[] currentRow = values[row];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                i -= this.columns;
            }
        } else {
            super.assign(values);
        }
    }

    @Override
    public DoubleMatrix2D assign(double value) {
        double[] elems = this.elements;
        int index = this.index(0, 0);
        int cs = this.columnStride;
        int rs = this.rowStride;
        int row = this.rows;
        while (--row >= 0) {
            int i = index;
            int column = this.columns;
            while (--column >= 0) {
                elems[i] = value;
                i += cs;
            }
            index += rs;
        }
        return this;
    }

    @Override
    public void assign(DoubleFunction function) {
        double[] elems = this.elements;
        if (elems == null) {
            throw new IllegalStateException();
        }
        int index = this.index(0, 0);
        int cs = this.columnStride;
        int rs = this.rowStride;
        if (function instanceof Mult) {
            double multiplicator = ((Mult)function).getMultiplicator();
            if (multiplicator == 1.0) {
                return;
            }
            if (multiplicator == 0.0) {
                this.assign(0.0);
                return;
            }
            int row = this.rows;
            while (--row >= 0) {
                int i = index;
                int column = this.columns;
                while (--column >= 0) {
                    int n = i;
                    elems[n] = elems[n] * multiplicator;
                    i += cs;
                }
                index += rs;
            }
        } else {
            int row = this.rows;
            while (--row >= 0) {
                int i = index;
                int column = this.columns;
                while (--column >= 0) {
                    elems[i] = function.apply(elems[i]);
                    i += cs;
                }
                index += rs;
            }
        }
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        if (!(source instanceof DenseDoubleMatrix2D)) {
            return super.assign(source);
        }
        DenseDoubleMatrix2D other = (DenseDoubleMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            DoubleMatrix2D c = other.copy();
            if (!(c instanceof DenseDoubleMatrix2D)) {
                return super.assign(other);
            }
            other = (DenseDoubleMatrix2D)c;
        }
        double[] elems = this.elements;
        double[] otherElems = other.elements;
        if (elems == null || otherElems == null) {
            throw new IllegalStateException();
        }
        int cs = this.columnStride;
        int ocs = other.columnStride;
        int rs = this.rowStride;
        int ors = other.rowStride;
        int otherIndex = other.index(0, 0);
        int index = this.index(0, 0);
        int row = this.rows;
        while (--row >= 0) {
            int i = index;
            int j = otherIndex;
            int column = this.columns;
            while (--column >= 0) {
                elems[i] = otherElems[j];
                i += cs;
                j += ocs;
            }
            index += rs;
            otherIndex += ors;
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D y, DoubleDoubleFunction function) {
        if (!(y instanceof DenseDoubleMatrix2D)) {
            return super.assign(y, function);
        }
        DenseDoubleMatrix2D other = (DenseDoubleMatrix2D)y;
        this.checkShape(y);
        double[] elems = this.elements;
        double[] otherElems = other.elements;
        if (elems == null || otherElems == null) {
            throw new IllegalStateException();
        }
        int cs = this.columnStride;
        int ocs = other.columnStride;
        int rs = this.rowStride;
        int ors = other.rowStride;
        int otherIndex = other.index(0, 0);
        int index = this.index(0, 0);
        if (function == Functions.MULT) {
            int row = this.rows;
            while (--row >= 0) {
                int i = index;
                int j = otherIndex;
                int column = this.columns;
                while (--column >= 0) {
                    int n = i;
                    elems[n] = elems[n] * otherElems[j];
                    i += cs;
                    j += ocs;
                }
                index += rs;
                otherIndex += ors;
            }
        } else if (function == Functions.DIV) {
            int row = this.rows;
            while (--row >= 0) {
                int i = index;
                int j = otherIndex;
                int column = this.columns;
                while (--column >= 0) {
                    int n = i;
                    elems[n] = elems[n] / otherElems[j];
                    i += cs;
                    j += ocs;
                }
                index += rs;
                otherIndex += ors;
            }
        } else if (function instanceof PlusMult) {
            double multiplicator = ((PlusMult)function).getMultiplicator();
            if (multiplicator == 0.0) {
                return this;
            }
            if (multiplicator == 1.0) {
                int row = this.rows;
                while (--row >= 0) {
                    int i = index;
                    int j = otherIndex;
                    int column = this.columns;
                    while (--column >= 0) {
                        int n = i;
                        elems[n] = elems[n] + otherElems[j];
                        i += cs;
                        j += ocs;
                    }
                    index += rs;
                    otherIndex += ors;
                }
            } else if (multiplicator == -1.0) {
                int row = this.rows;
                while (--row >= 0) {
                    int i = index;
                    int j = otherIndex;
                    int column = this.columns;
                    while (--column >= 0) {
                        int n = i;
                        elems[n] = elems[n] - otherElems[j];
                        i += cs;
                        j += ocs;
                    }
                    index += rs;
                    otherIndex += ors;
                }
            } else {
                int row = this.rows;
                while (--row >= 0) {
                    int i = index;
                    int j = otherIndex;
                    int column = this.columns;
                    while (--column >= 0) {
                        int n = i;
                        elems[n] = elems[n] + multiplicator * otherElems[j];
                        i += cs;
                        j += ocs;
                    }
                    index += rs;
                    otherIndex += ors;
                }
            }
        } else {
            int row = this.rows;
            while (--row >= 0) {
                int i = index;
                int j = otherIndex;
                int column = this.columns;
                while (--column >= 0) {
                    elems[i] = function.apply(elems[i], otherElems[j]);
                    i += cs;
                    j += ocs;
                }
                index += rs;
                otherIndex += ors;
            }
        }
        return this;
    }

    @Override
    public double getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix2D other) {
        if (other instanceof SelectedDenseDoubleMatrix2D) {
            SelectedDenseDoubleMatrix2D otherMatrix = (SelectedDenseDoubleMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D otherMatrix = (DenseDoubleMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public DoubleMatrix2D like(int rows, int columns) {
        return new DenseDoubleMatrix2D(rows, columns);
    }

    @Override
    public DoubleMatrix1D like1D(int size) {
        return new DenseDoubleMatrix1D(size);
    }

    @Override
    protected DoubleMatrix1D like1D(int size, int zero, int stride) {
        return new DenseDoubleMatrix1D(size, this.elements, zero, stride);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    protected DoubleMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseDoubleMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }

    @Override
    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        if (z == null) {
            z = new DenseDoubleMatrix1D(this.rows);
        }
        if (!(y instanceof DenseDoubleMatrix1D) || !(z instanceof DenseDoubleMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if (this.columns != y.size || this.rows > z.size) {
            throw new IllegalArgumentException("Incompatible sizes");
        }
        DenseDoubleMatrix1D yy = (DenseDoubleMatrix1D)y;
        DenseDoubleMatrix1D zz = (DenseDoubleMatrix1D)z;
        double[] AElems = this.elements;
        double[] yElems = yy.elements;
        double[] zElems = zz.elements;
        if (AElems == null || yElems == null || zElems == null) {
            throw new IllegalStateException();
        }
        int As = this.columnStride;
        int ys = yy.stride;
        int zs = zz.stride;
        int indexA = this.index(0, 0);
        int indexY = yy.index(0);
        int indexZ = zz.index(0);
        int cols = this.columns;
        int row = this.rows;
        while (--row >= 0) {
            double sum = 0.0;
            int i = indexA - As;
            int j = indexY - ys;
            int k = cols % 4;
            while (--k >= 0) {
                sum += AElems[i += As] * yElems[j += ys];
            }
            k = cols / 4;
            while (--k >= 0) {
                int n = i + As;
                i = n;
                int n2 = j + ys;
                j = n2;
                int n3 = i + As;
                i = n3;
                int n4 = j + ys;
                j = n4;
                i = i + As;
                j = j + ys;
                sum += AElems[n] * yElems[n2] + AElems[n3] * yElems[n4] + AElems[i] * yElems[j] + AElems[i += As] * yElems[j += ys];
            }
            zElems[indexZ] = alpha * sum + beta * zElems[indexZ];
            indexA += this.rowStride;
            indexZ += zs;
        }
        return z;
    }

    @Override
    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (B instanceof SparseDoubleMatrix2D) {
            if (C == null) {
                return B.zMult(this, null, alpha, beta, !transposeB, true).viewDice();
            }
            B.zMult(this, C.viewDice(), alpha, beta, !transposeB, true);
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        int m = this.rows;
        int n = this.columns;
        int p = B.columns;
        if (C == null) {
            C = new DenseDoubleMatrix2D(m, p);
        }
        if (!(C instanceof DenseDoubleMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree");
        }
        if (C.rows != m || C.columns != p) {
            throw new IllegalArgumentException("Incompatible result matrix");
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseDoubleMatrix2D BB = (DenseDoubleMatrix2D)B;
        DenseDoubleMatrix2D CC = (DenseDoubleMatrix2D)C;
        double[] AElems = this.elements;
        double[] BElems = BB.elements;
        double[] CElems = CC.elements;
        if (AElems == null || BElems == null || CElems == null) {
            throw new IllegalStateException();
        }
        int cA = this.columnStride;
        int cB = BB.columnStride;
        int cC = CC.columnStride;
        int rA = this.rowStride;
        int rB = BB.rowStride;
        int rC = CC.rowStride;
        int blockSize = 30000;
        int mOptimal = (blockSize - n) / (n + 1);
        if (mOptimal <= 0) {
            mOptimal = 1;
        }
        int blocks = m / mOptimal;
        if (m % mOptimal != 0) {
            ++blocks;
        }
        int rr = 0;
        while (--blocks >= 0) {
            int jB = BB.index(0, 0);
            int indexA = this.index(rr, 0);
            int jC = CC.index(rr, 0);
            rr += mOptimal;
            if (blocks == 0) {
                mOptimal += m - rr;
            }
            int j = p;
            while (--j >= 0) {
                int iA = indexA;
                int iC = jC;
                int i = mOptimal;
                while (--i >= 0) {
                    int kA = iA;
                    int kB = jB;
                    kA -= cA;
                    kB -= rB;
                    double s = 0.0;
                    int k = n % 4;
                    while (--k >= 0) {
                        s += AElems[kA += cA] * BElems[kB += rB];
                    }
                    k = n / 4;
                    while (--k >= 0) {
                        int n2 = kA + cA;
                        kA = n2;
                        int n3 = kB + rB;
                        kB = n3;
                        int n4 = kA + cA;
                        kA = n4;
                        int n5 = kB + rB;
                        kB = n5;
                        kA = kA + cA;
                        kB = kB + rB;
                        s += AElems[n2] * BElems[n3] + AElems[n4] * BElems[n5] + AElems[kA] * BElems[kB] + AElems[kA += cA] * BElems[kB += rB];
                    }
                    CElems[iC] = alpha * s + beta * CElems[iC];
                    iA += rA;
                    iC += rC;
                }
                jB += cB;
                jC += cC;
            }
        }
        return C;
    }

    @Override
    public double zSum() {
        double[] elems = this.elements;
        if (elems == null) {
            throw new IllegalStateException();
        }
        int index = this.index(0, 0);
        int cs = this.columnStride;
        int rs = this.rowStride;
        double sum = 0.0;
        int row = this.rows;
        while (--row >= 0) {
            int i = index;
            int column = this.columns;
            while (--column >= 0) {
                sum += elems[i];
                i += cs;
            }
            index += rs;
        }
        return sum;
    }
}

