/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.pipeline;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.text.linguistic.ILexicalDataFactory;
import org.carrot2.text.linguistic.IStemmerFactory;
import org.carrot2.text.linguistic.ITokenizerFactory;
import org.carrot2.text.preprocessing.CaseNormalizerDescriptor;
import org.carrot2.text.preprocessing.LanguageModelStemmerDescriptor;
import org.carrot2.text.preprocessing.StopListMarkerDescriptor;
import org.carrot2.text.preprocessing.TokenizerDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class BasicPreprocessingPipelineDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipeline";
    public final String prefix = "PreprocessingPipeline";
    public final String title = "Performs basic preprocessing steps on the provided documents";
    public final String label = "";
    public final String description = "The preprocessing consists of the following steps: <ol> <li><code>Tokenizer.tokenize(PreprocessingContext)</code></li> <li><code>CaseNormalizer.normalize(PreprocessingContext)</code></li> <li><code>LanguageModelStemmer.stem(PreprocessingContext)</code></li> <li><code>StopListMarker.mark(PreprocessingContext)</code></li> </ol>";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "PreprocessingPipeline";
    }

    public String getTitle() {
        return "Performs basic preprocessing steps on the provided documents";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "The preprocessing consists of the following steps: <ol> <li><code>Tokenizer.tokenize(PreprocessingContext)</code></li> <li><code>CaseNormalizer.normalize(PreprocessingContext)</code></li> <li><code>LanguageModelStemmer.stem(PreprocessingContext)</code></li> <li><code>StopListMarker.mark(PreprocessingContext)</code></li> </ol>";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(BasicPreprocessingPipelineDescriptor.attributes.tokenizerFactory);
        ownAttrs.add(BasicPreprocessingPipelineDescriptor.attributes.stemmerFactory);
        ownAttrs.add(BasicPreprocessingPipelineDescriptor.attributes.lexicalDataFactory);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(BasicPreprocessingPipelineDescriptor.attributes.tokenizerFactory);
        allAttrs.add(BasicPreprocessingPipelineDescriptor.attributes.stemmerFactory);
        allAttrs.add(BasicPreprocessingPipelineDescriptor.attributes.lexicalDataFactory);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder tokenizerFactory(ITokenizerFactory value) {
            this.map.put("PreprocessingPipeline.tokenizerFactory", value);
            return this;
        }

        public AttributeBuilder tokenizerFactory(Class<?> clazz) {
            this.map.put("PreprocessingPipeline.tokenizerFactory", clazz);
            return this;
        }

        public AttributeBuilder tokenizerFactory(IObjectFactory<? extends ITokenizerFactory> value) {
            this.map.put("PreprocessingPipeline.tokenizerFactory", value);
            return this;
        }

        public AttributeBuilder stemmerFactory(IStemmerFactory value) {
            this.map.put("PreprocessingPipeline.stemmerFactory", value);
            return this;
        }

        public AttributeBuilder stemmerFactory(Class<?> clazz) {
            this.map.put("PreprocessingPipeline.stemmerFactory", clazz);
            return this;
        }

        public AttributeBuilder stemmerFactory(IObjectFactory<? extends IStemmerFactory> value) {
            this.map.put("PreprocessingPipeline.stemmerFactory", value);
            return this;
        }

        public AttributeBuilder lexicalDataFactory(ILexicalDataFactory value) {
            this.map.put("PreprocessingPipeline.lexicalDataFactory", value);
            return this;
        }

        public AttributeBuilder lexicalDataFactory(Class<?> clazz) {
            this.map.put("PreprocessingPipeline.lexicalDataFactory", clazz);
            return this;
        }

        public AttributeBuilder lexicalDataFactory(IObjectFactory<? extends ILexicalDataFactory> value) {
            this.map.put("PreprocessingPipeline.lexicalDataFactory", value);
            return this;
        }

        public TokenizerDescriptor.AttributeBuilder tokenizer() {
            return TokenizerDescriptor.attributeBuilder(this.map);
        }

        public CaseNormalizerDescriptor.AttributeBuilder caseNormalizer() {
            return CaseNormalizerDescriptor.attributeBuilder(this.map);
        }

        public LanguageModelStemmerDescriptor.AttributeBuilder languageModelStemmer() {
            return LanguageModelStemmerDescriptor.attributeBuilder(this.map);
        }

        public StopListMarkerDescriptor.AttributeBuilder stopListMarker() {
            return StopListMarkerDescriptor.attributeBuilder(this.map);
        }
    }

    public static final class Attributes {
        public final AttributeInfo tokenizerFactory = new AttributeInfo("PreprocessingPipeline.tokenizerFactory", "org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipeline", "tokenizerFactory", "Tokenizer factory. Creates the tokenizers to be used by the clustering algorithm.", null, "Tokenizer factory", "Creates the tokenizers to be used by the clustering algorithm.", "Preprocessing", AttributeLevel.ADVANCED, null);
        public final AttributeInfo stemmerFactory = new AttributeInfo("PreprocessingPipeline.stemmerFactory", "org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipeline", "stemmerFactory", "Stemmer factory. Creates the stemmers to be used by the clustering algorithm.", null, "Stemmer factory", "Creates the stemmers to be used by the clustering algorithm.", "Preprocessing", AttributeLevel.ADVANCED, null);
        public final AttributeInfo lexicalDataFactory = new AttributeInfo("PreprocessingPipeline.lexicalDataFactory", "org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipeline", "lexicalDataFactory", "Lexical data factory. Creates the lexical data to be used by the clustering\nalgorithm, including stop word and stop label dictionaries.", null, "Lexical data factory", "Creates the lexical data to be used by the clustering algorithm, including stop word and stop label dictionaries.", "Preprocessing", AttributeLevel.ADVANCED, null);
        public final TokenizerDescriptor.Attributes tokenizer = TokenizerDescriptor.attributes;
        public final CaseNormalizerDescriptor.Attributes caseNormalizer = CaseNormalizerDescriptor.attributes;
        public final LanguageModelStemmerDescriptor.Attributes languageModelStemmer = LanguageModelStemmerDescriptor.attributes;
        public final StopListMarkerDescriptor.Attributes stopListMarker = StopListMarkerDescriptor.attributes;

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String TOKENIZER_FACTORY = "PreprocessingPipeline.tokenizerFactory";
        public static final String STEMMER_FACTORY = "PreprocessingPipeline.stemmerFactory";
        public static final String LEXICAL_DATA_FACTORY = "PreprocessingPipeline.lexicalDataFactory";

        protected Keys() {
        }
    }
}

