/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DetectedLanguage;
import org.apache.solr.update.processor.LanguageIdentifierUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.tika.language.LanguageIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaLanguageIdentifierUpdateProcessor
extends LanguageIdentifierUpdateProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TikaLanguageIdentifierUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(req, rsp, next);
    }

    @Override
    protected List<DetectedLanguage> detectLanguage(SolrInputDocument doc) {
        ArrayList<DetectedLanguage> languages = new ArrayList<DetectedLanguage>();
        String content = this.concatFields(doc);
        if (content.length() != 0) {
            LanguageIdentifier identifier = new LanguageIdentifier(content);
            Double distance = Double.parseDouble(this.tikaSimilarityPattern.matcher(identifier.toString()).replaceFirst("$1"));
            Double certainty = 1.0 - 5.0 * distance;
            if (certainty < 0.0) {
                certainty = 0.0;
            }
            DetectedLanguage language = new DetectedLanguage(identifier.getLanguage(), certainty);
            languages.add(language);
            log.debug("Language detected as " + language + " with a certainty of " + language.getCertainty() + " (Tika distance=" + identifier.toString() + ")");
        } else {
            log.debug("No input text to detect language from, returning empty list");
        }
        return languages;
    }
}

