<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_dbd - Serveur HTTP Apache Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_dbd</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_dbd.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_dbd.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Gestion des connexions  une base de donnes SQL</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>dbd_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_dbd.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Versions 2.1 and suprieures</td></tr></table>
<h3>Sommaire</h3>

    <p>Le module <code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code> gre les connexions
     une base de donnes SQL via <a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a>. Il permet
    aux modules qui requirent des fonctions lies aux bases de donnes
    SQL de se connecter  une base de donnes  la demande, et s'efforce
    de confrer aux bases de donnes une efficacit et une
    volutivit optimales pour les MPMs threads ou non threads. Pour
    plus de dtails, voir le site web <a href="http://apr.apache.org/">APR</a>,
    ainsi que cette vue d'ensemble de l'<a href="http://people.apache.org/~niq/dbd.html">environnement de
    dveloppement d'Apache DBD</a> par son dveloppeur initial.
</p>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#pooling">Regroupement des connexions</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#connecting">Connexion</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#API">API DBD d'Apache</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#prepared">Requtes SQL prpares</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#security">AVERTISSEMENT DE SECURITE</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#dbdexptime">DBDExptime</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbdinitsql">DBDInitSQL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbdkeep">DBDKeep</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbdmax">DBDMax</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbdmin">DBDMin</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbdparams">DBDParams</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbdpersist">DBDPersist</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbdpreparesql">DBDPrepareSQL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbdriver">DBDriver</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_dbd">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_dbd">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../misc/password_encryptions.html">Formats des mots de
passe</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="pooling" id="pooling">Regroupement des connexions</a></h2>
    <p>Ce module gre de manire optimise en fonction de la plate-forme
    les connexions aux bases de donnes. Sur les plates-formes non
    threades, il maintient une connexion persistente  la manire d'un
    LAMP classique (Linux, Apache, Mysql, Perl/PHP/Python). Sur les
    plates-formes threades, il maintient un <em>groupe de
    connexions</em>  la fois plus volutif et plus efficace, comme
    dcrit dans <a href="http://www.apachetutor.org/dev/reslist">cet
    article d'ApacheTutor</a>. Notez que <code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code>
    remplace les modules prsents dans cet article.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="connecting" id="connecting">Connexion</a></h2>

    <p>Pour vous connecter  votre base de donnes, vous devez spcifier un
    pilote et des paramtres de connexion qui diffrent selon le moteur de base
    de donnes. Par exemple, pour vous connecter  mysql, spcifiez ce qui suit
    :</p>

<pre class="prettyprint lang-config">DBDriver mysql
DBDParams host=localhost,dbname=pony,user=shetland,pass=appaloosa</pre>


    <p>Vous pourrez alors utiliser cette connexion dans de nombreux autres
    modules comme <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>, <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code>
    et <code class="module"><a href="../mod/mod_lua.html">mod_lua</a></code>. Vous trouverez des exemples d'utilisation dans
    la documentation de ces modules.</p>

    <p>Voir la syntaxe de la directive <code class="directive">DBDParams</code> pour les
    informations  fournir dans la chane de connexion en fonction des
    diffrents pilotes de base de donnes supports.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="API" id="API">API DBD d'Apache</a></h2>
    <p><code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code> exporte cinq fonctions que d'autres
    modules pourront utiliser. L'API se prsente comme suit :</p>

    <pre class="prettyprint lang-c">typedef struct {
    apr_dbd_t *handle;
    apr_dbd_driver_t *driver;
    apr_hash_t *prepared;
} ap_dbd_t;

/* Fonctions exportes pour accder  la base de donnes */

/* ouvre une connexion qui DOIT avoir t explicitement ferme.
 * Renvoie NULL en cas d'erreur
 */
AP_DECLARE(ap_dbd_t*) ap_dbd_open(apr_pool_t*, server_rec*);

/* ferme une connexion ouverte avec ap_dbd_open */
AP_DECLARE(void) ap_dbd_close(server_rec*, ap_dbd_t*);

/* acquiert une connexion qui aura la dure de vie de la requte et qui
 * NE DOIT PAS avoir t explicitement ferme. Renvoie NULL en cas
 * d'erreur. C'est la fonction recommande pour la plupart des
 * applications.
 */
AP_DECLARE(ap_dbd_t*) ap_dbd_acquire(request_rec*);

/* acquiert une connexion qui aura la dure de vie d'une connexion et
 * qui NE DOIT PAS avoir t explicitement ferme. Renvoie NULL en cas
 * d'erreur.
 */
AP_DECLARE(ap_dbd_t*) ap_dbd_cacquire(conn_rec*);

/* Prpare une requte qu'un module client pourra utiliser */
AP_DECLARE(void) ap_dbd_prepare(server_rec*, const char*, const char*);

/* Exporte aussi ces fonctions  titre optionnel mour les modules qui
 * pfreraient les utiliser */
APR_DECLARE_OPTIONAL_FN(ap_dbd_t*, ap_dbd_open, (apr_pool_t*, server_rec*));
APR_DECLARE_OPTIONAL_FN(void, ap_dbd_close, (server_rec*, ap_dbd_t*));
APR_DECLARE_OPTIONAL_FN(ap_dbd_t*, ap_dbd_acquire, (request_rec*));
APR_DECLARE_OPTIONAL_FN(ap_dbd_t*, ap_dbd_cacquire, (conn_rec*));
APR_DECLARE_OPTIONAL_FN(void, ap_dbd_prepare, (server_rec*, const char*, const char*));</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="prepared" id="prepared">Requtes SQL prpares</a></h2>
    <p><code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code> supporte les requtes SQL prpares 
    destination des modules qui pourraient les utiliser. Chaque requte
    prpare doit possder un nom (tiquette), et est stocke dans un
    condens (hash) : les condenss sont du type
    <code>apr_dbd_prepared_t</code> et s'utilisent dans toute requte
    SQL ou commande select prpare par apr_dbd.</p>

    <p>Il est du ressort des modules utilisateurs de dbd d'utiliser les
    requtes prpares et de prciser quelles requtes doivent tre
    spcifies dans httpd.conf, ou de fournir leurs propres directives
    et d'utiliser <code>ap_dbd_prepare</code>.</p>

    <div class="warning"><h3>Avertissement</h3>
	Lorsqu'on utilise des requtes prpares avec des bases de
	donnes MySQL, il est prfrable de dfinir
	<code>reconnect</code>  0 dans la chane de connexion, afin
	d'viter des erreurs provoques par un client MySQL qui se
	reconnecterait sans rinitialiser correctement les requtes
	prpares. Si <code>reconnect</code> est dfini  1, toute
	connexion dfectueuse sera sense tre rpare, mais comme
	mod_dbd n'en est pas inform, les requtes prpares seront
	invalides.
	</div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="security" id="security">AVERTISSEMENT DE SECURITE</a></h2>

    <p>Toute application web impliquant une base de donnes doit se
    protger elle-mme contre les attaques de type injection SQL. Dans
    la plupart des cas Apache DBD est sr, car les applications
    utilisent des requtes prpares, et les entres non sures ne seront
    utilises qu' titre de donnes. Bien entendu, si vous l'utilisez
    via un module tiers, vous devez tre au fait des prcautions 
    prendre.</p>
    <p>Cependant, le pilote <var>FreeTDS</var> est <strong>non
    sr</strong> de par sa nature-mme. Comme la bibliothque
    sous-jacente ne supporte pas les requtes prpares, le pilote en
    effectue une mulation, et les entres non sres sont fusionnes
    avec la requte SQL.</p>
    <p>Il peut tre scuris en <em>dcontaminant</em> toutes les
    entres : un processus inspir de la recherche de contaminations
    (<strong>taint mode</strong>) de
    Perl. Chaque entre est compare  une expression rationnelle, et
    seules les entres qui correspondent sont utilises, en accord avec
    le langage Perl :</p>
    <div class="example"><pre><code>  $untrusted =~ /([a-z]+)/;
  $trusted = $1;</code></pre></div>
    <p>Pour utiliser ceci, les expressions rationnelles de
    dcontamination doivent tre incluses dans les requtes prpares.
    L'expression rationnelle doit se situer immdiatement aprs le
    caractre % dans la requte prpare, et doit tre entoure
    d'accolades {}. Par exemple, si votre application attend une entre
    alphanumrique, vous pouvez utiliser :</p>
    <div class="example"><p><code>
       <code>"SELECT foo FROM bar WHERE input = %s"</code>
    </code></p></div>
    <p>avec d'autres pilotes, et ne risquer au pire qu'une requte
    choue. Mais avec FreeTDS, vous devez utiliser :</p>
    <div class="example"><p><code>
       <code>"SELECT foo FROM bar WHERE input = %{([A-Za-z0-9]+)}s"</code>
    </code></p></div>
    <p>tout ce qui ne correspond pas  l'expression rationnelle est
    alors rejet, et la requte est maintenant sre.</p>
    <p>Alternativement, vous pouvez utiliser le pilote ODBC tiers, qui
    offre la scurit des requtes prpares authentiques.</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="dbdexptime" id="dbdexptime">Directive</a> <a name="DBDExptime" id="DBDExptime">DBDExptime</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dure de vie des connexions inactives</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DBDExptime <var>dure en secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DBDExptime 300</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dbd</td></tr>
</table>
    <p>Cette directive permet de dfinir la dure de vie des connexions
    inactives lorsque le nombre de connexions spcifi par la directive
    DBDKeep a t dpass (plates-formes threades uniquement).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="dbdinitsql" id="dbdinitsql">Directive</a> <a name="DBDInitSQL" id="DBDInitSQL">DBDInitSQL</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Excute une instruction SQL aprs connexion  une base de
donnes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DBDInitSQL <var>"instruction SQL"</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dbd</td></tr>
</table>
    <p>Les modules qui le souhaitent peuvent excuter une ou plusieurs
    instructions SQL aprs connexion  une base de donnes. Par exemple
    initialiser certaines valeurs, ou ajouter une entre dans le journal
    lors d'une nouvelle connexion  la base de donnes.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="dbdkeep" id="dbdkeep">Directive</a> <a name="DBDKeep" id="DBDKeep">DBDKeep</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximum de connexions maintenues</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DBDKeep <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DBDKeep 2</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dbd</td></tr>
</table>
    <p>Cette directive permet de dfinir le nombre maximum de connexions
     maintenir par processus, en dehors de celles servant  grer les
    pics de demandes (plates-formes threades uniquement).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="dbdmax" id="dbdmax">Directive</a> <a name="DBDMax" id="DBDMax">DBDMax</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximum de connexions</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DBDMax <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DBDMax 10</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dbd</td></tr>
</table>
    <p>Cette directive permet de dfinir le nombre maximum effectif de
    connexions par processus (plates-formes threades uniquement).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="dbdmin" id="dbdmin">Directive</a> <a name="DBDMin" id="DBDMin">DBDMin</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre minimum de connexions</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DBDMin <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DBDMin 1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dbd</td></tr>
</table>
    <p>Cette directive permet de dfinir le nombre minimum de connexions
    par processus (plates-formes threades uniquement).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="dbdparams" id="dbdparams">Directive</a> <a name="DBDParams" id="DBDParams">DBDParams</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Paramtres de la connexion  la base de
donnes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DBDParams
<var>param1</var>=<var>valeur1</var>[,<var>param2</var>=<var>valeur2</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dbd</td></tr>
</table>
    <p>Cette directive permet de spcifier des paramtres selon les
    besoins du pilote concern. En gnral, les paramtres  passer
    concernent tout ce qui n'a pas de valeur par dfaut comme le nom
    d'utilisateur, le mot de passe, le nom de la base de donnes, le nom
    d'hte et le numro de port de la connexion.</p>
    <p>Les paramtres de la chane de connexion en fonction des
    diffrents pilotes comprennent :</p>
    <dl>
    <dt>FreeTDS (pour MSSQL et SyBase)</dt>
    <dd>username, password, appname, dbname, host, charset, lang, server</dd>
    <dt>MySQL</dt>
    <dd>host, port, user, pass, dbname, sock, flags, fldsz, group, reconnect</dd>
    <dt>Oracle</dt>
    <dd>user, pass, dbname, server</dd>
    <dt>PostgreSQL</dt>
    <dd>La chane de connexion est passe directement  <code>PQconnectdb</code></dd>
    <dt>SQLite2</dt>
    <dd>La chane de connexion est scinde avec comme sparateur le
    caractre ':', et <code>partie1:partie2</code> est utilis dans
    <code>sqlite_open(partie1, atoi(partie2), NULL)</code></dd>
    <dt>SQLite3</dt>
    <dd>La chane de connexion est passe directement  <code>sqlite3_open</code></dd>
    <dt>ODBC</dt>
    <dd>datasource, user, password, connect, ctimeout, stimeout, access, txmode, bufsize</dd>
    </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="dbdpersist" id="dbdpersist">Directive</a> <a name="DBDPersist" id="DBDPersist">DBDPersist</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utiliser ou non des connexions persistentes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DBDPersist On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dbd</td></tr>
</table>
    <p>Si cette directive est dfinie  Off, les connexions persistentes
    et les connexions groupes sont dsactives.  la demande d'un
    client, une nouvelle connexion  la base de donnes est ouverte, et
    ferme immdiatement  l'issue du traitement. Cette configuration ne
    doit tre utilise qu' des fins de dbogage, ou sur des serveurs 
    charge faible.</p>

    <p>Par dfaut, les groupes de connexions persistentes sont activs
    (ou une seule connexion persistente du style LAMP pour les serveurs
    non threads), et c'est la configuration qui devrait tre utilise
    dans la plupart des cas sur un serveur en production.</p>

    <p>Avant la version 2.2.2, cette directive n'acceptait que les
    valeurs <code>0</code> et <code>1</code> au lieu de <code>Off</code>
    et <code>On</code>, respectivement.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="dbdpreparesql" id="dbdpreparesql">Directive</a> <a name="DBDPrepareSQL" id="DBDPrepareSQL">DBDPrepareSQL</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit une requte SQL prpare</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DBDPrepareSQL <var>"requte SQL"</var> <var>tiquette</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dbd</td></tr>
</table>
    <p>Pour les modules tels que les modules d'authentification, qui
    utilisent de manire rpte la mme requte SQL, on peut optimiser
    les performances en prparant la requte une fois pour toutes au
    dmarrage, plutt qu' chaque utilisation. Cette directive permet de
    prparer une requte SQL et de lui assigner une tiquette.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="dbdriver" id="dbdriver">Directive</a> <a name="DBDriver" id="DBDriver">DBDriver</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie un pilote SQL</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DBDriver <var>nom</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_dbd</td></tr>
</table>
    <p>Cette directive permet de spcifier un pilote apr_dbd par son
    nom. Le pilote doit tre install sur votre systme (sur la plupart
    des systmes, il s'agit d'un objet partag ou d'une dll). Par
    exemple, <code>DBDriver mysql</code> va slectionner le pilote MySQL
    dans la bibliothque apr_dbd_mysql.so.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_dbd.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_dbd.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_dbd.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>