/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.BreakIterator;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rtextarea.BackgroundPainterStrategy;
import org.fife.ui.rtextarea.BufferedImageBackgroundPainterStrategy;
import org.fife.ui.rtextarea.ColorBackgroundPainterStrategy;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.ImageBackgroundPainterStrategy;
import org.fife.ui.rtextarea.RTextAreaUI;

abstract class RTextAreaBase
extends JTextArea {
    public static final String CURRENT_LINE_HIGHLIGHT_PROPERTY = "RTA.currentLineHighlight";
    public static final String CURRENT_LINE_HIGHLIGHT_COLOR_PROPERTY = "RTA.currentLineHighlightColor";
    public static final String CURRENT_LINE_HIGHLIGHT_FADE_PROPERTY = "RTA.currentLineHighlightFade";
    public static final String ROUNDED_SELECTION_PROPERTY = "RTA.roundedSelection";
    private boolean tabsEmulatedWithSpaces;
    private boolean highlightCurrentLine;
    private Color currentLineColor;
    private boolean marginLineEnabled;
    private Color marginLineColor;
    protected int marginLineX;
    protected int marginSizeInChars;
    private boolean fadeCurrentLineHighlight;
    private boolean roundedSelectionEdges;
    private int previousCaretY;
    int currentCaretY;
    private BackgroundPainterStrategy backgroundPainter;
    private RTAMouseListener mouseListener;
    private static final Color DEFAULT_CARET_COLOR = new Color(255, 51, 51);
    private static final Color DEFAULT_SELECTION_COLOR = new Color(200, 200, 255);
    private static final Color DEFAULT_CURRENT_LINE_HIGHLIGHT_COLOR = new Color(255, 255, 170);
    private static final Color DEFAULT_MARGIN_LINE_COLOR = new Color(255, 224, 224);
    private static final int DEFAULT_TAB_SIZE = 5;
    private static final int DEFAULT_MARGIN_LINE_POSITION = 80;

    public RTextAreaBase(Font font, boolean bl) {
        this.setRTextAreaUI(this.createRTextAreaUI());
        this.enableEvents(9L);
        this.setCurrentLineHighlightEnabled(true);
        this.setCurrentLineHighlightColor(RTextAreaBase.getDefaultCurrentLineHighlightColor());
        this.setMarginLineEnabled(false);
        this.setMarginLineColor(RTextAreaBase.getDefaultMarginLineColor());
        this.setMarginLinePosition(RTextAreaBase.getDefaultMarginLinePosition());
        this.setBackgroundObject(Color.WHITE);
        this.setWrapStyleWord(true);
        this.setSelectionColor(RTextAreaBase.getDefaultSelectionColor());
        this.setTabSize(5);
        this.setForeground(Color.BLACK);
        this.setTabsEmulated(false);
        this.setFont(font != null ? font : RTextAreaBase.getDefaultFont());
        this.setLineWrap(bl);
        this.currentCaretY = 0;
        this.previousCaretY = 0;
        this.setSize(new Dimension(300, 300));
        this.mouseListener = this.createMouseListener();
        this.addFocusListener(this.mouseListener);
        this.addCurrentLineHighlightListeners();
    }

    protected void addCurrentLineHighlightListeners() {
        boolean bl = true;
        MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            if (mouseMotionListenerArray[i] != this.mouseListener) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.addMouseMotionListener(this.mouseListener);
        }
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (mouseListenerArray[i] != this.mouseListener) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.addMouseListener(this.mouseListener);
        }
    }

    public void convertSpacesToTabs() {
        int n = this.getCaretPosition();
        int n2 = this.getTabSize();
        String string = "";
        for (int i = 0; i < n2; ++i) {
            string = string + " ";
        }
        String string2 = this.getText();
        this.setText(string2.replaceAll(string, "\t"));
        int n3 = this.getDocument().getLength();
        if (n < n3) {
            this.setCaretPosition(n);
        } else {
            this.setCaretPosition(n3 - 1);
        }
    }

    public void convertTabsToSpaces() {
        int n = this.getCaretPosition();
        int n2 = this.getTabSize();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(' ');
        }
        String string = this.getText();
        this.setText(string.replaceAll("\t", stringBuffer.toString()));
        this.setCaretPosition(n);
    }

    protected abstract RTAMouseListener createMouseListener();

    protected abstract RTextAreaUI createRTextAreaUI();

    protected void forceCurrentLineHighlightRepaint() {
        if (this.isShowing()) {
            this.previousCaretY = -1;
            this.fireCaretUpdate(this.mouseListener);
        }
    }

    public final Color getBackground() {
        Object object = this.getBackgroundObject();
        return object instanceof Color ? (Color)object : null;
    }

    public final Image getBackgroundImage() {
        Object object = this.getBackgroundObject();
        return object instanceof Image ? (Image)object : null;
    }

    public final Object getBackgroundObject() {
        if (this.backgroundPainter == null) {
            return null;
        }
        return this.backgroundPainter instanceof ImageBackgroundPainterStrategy ? ((ImageBackgroundPainterStrategy)this.backgroundPainter).getMasterImage() : ((ColorBackgroundPainterStrategy)this.backgroundPainter).getColor();
    }

    public final int getCaretLineNumber() {
        try {
            return this.getLineOfOffset(this.getCaretPosition());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public final int getCaretOffsetFromLineStart() {
        try {
            int n = this.getCaretPosition();
            return n - this.getLineStartOffset(this.getLineOfOffset(n));
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public Color getCurrentLineHighlightColor() {
        return this.currentLineColor;
    }

    public static final Color getDefaultCaretColor() {
        return DEFAULT_CARET_COLOR;
    }

    public static final Color getDefaultCurrentLineHighlightColor() {
        return DEFAULT_CURRENT_LINE_HIGHLIGHT_COLOR;
    }

    public static final Font getDefaultFont() {
        return new Font("Monospaced", 0, 13);
    }

    public static final Color getDefaultForeground() {
        return Color.BLACK;
    }

    public static final Color getDefaultMarginLineColor() {
        return DEFAULT_MARGIN_LINE_COLOR;
    }

    public static final int getDefaultMarginLinePosition() {
        return 80;
    }

    public static Color getDefaultSelectionColor() {
        return DEFAULT_SELECTION_COLOR;
    }

    public static final int getDefaultTabSize() {
        return 5;
    }

    public boolean getFadeCurrentLineHighlight() {
        return this.fadeCurrentLineHighlight;
    }

    public final int getLineEndOffsetOfCurrentLine() {
        try {
            return this.getLineEndOffset(this.getCaretLineNumber());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public int getLineHeight() {
        return this.getRowHeight();
    }

    public final int getLineStartOffsetOfCurrentLine() {
        try {
            return this.getLineStartOffset(this.getCaretLineNumber());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public Color getMarginLineColor() {
        return this.marginLineColor;
    }

    public int getMarginLinePixelLocation() {
        return this.marginLineX;
    }

    public int getMarginLinePosition() {
        return this.marginSizeInChars;
    }

    public boolean getRoundedSelectionEdges() {
        return this.roundedSelectionEdges;
    }

    public boolean getTabsEmulated() {
        return this.tabsEmulatedWithSpaces;
    }

    public final String getWordAtOffset(int n) throws BadLocationException {
        int n2;
        int n3;
        Element element;
        Element element2;
        int n4;
        Document document = this.getDocument();
        String string = document.getText(n4 = (element2 = (element = document.getDefaultRootElement()).getElement(n3 = element.getElementIndex(n))).getStartOffset(), (n2 = Math.min(element2.getEndOffset(), document.getLength())) - n4);
        if (string != null && string.length() > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText(string);
            int n5 = n - n4;
            if (n5 >= breakIterator.last()) {
                n5 = breakIterator.last() - 1;
            }
            int n6 = n4 + breakIterator.following(n5);
            int n7 = n4 + breakIterator.previous();
            return document.getText(n7, n6 - n7);
        }
        return null;
    }

    public final boolean isCurrentLineHighlightEnabled() {
        return this.highlightCurrentLine;
    }

    public boolean isMarginLineEnabled() {
        return this.marginLineEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        this.backgroundPainter.paint(graphics, this.getVisibleRect());
        TextUI textUI = this.getUI();
        if (textUI != null) {
            Graphics graphics2 = graphics.create();
            try {
                textUI.update(graphics2, this);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    protected void possiblyUpdateCurrentLineHighlightLocation() {
        int n = this.getWidth();
        int n2 = this.getLineHeight();
        int n3 = this.getCaretPosition();
        if (this.getLineWrap()) {
            try {
                Rectangle rectangle = this.modelToView(n3);
                if (rectangle != null) {
                    this.currentCaretY = rectangle.y;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            Document document = this.getDocument();
            if (document != null) {
                Element element = document.getDefaultRootElement();
                int n4 = element.getElementIndex(n3);
                Rectangle rectangle = ((RTextAreaUI)this.getUI()).getVisibleEditorRect();
                if (rectangle != null) {
                    this.currentCaretY = rectangle.y + n4 * n2;
                }
            }
        }
        this.repaint(0, this.currentCaretY, n, n2);
        if (this.currentCaretY != this.previousCaretY) {
            this.repaint(0, this.previousCaretY, n, n2);
        }
        this.previousCaretY = this.currentCaretY;
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (componentEvent.getID() == 101 && this.getLineWrap() && this.isCurrentLineHighlightEnabled()) {
            this.previousCaretY = -1;
            this.fireCaretUpdate(this.mouseListener);
        }
        super.processComponentEvent(componentEvent);
    }

    public void setBackground(Color color) {
        Object object = this.getBackgroundObject();
        if (object instanceof Color) {
            ((ColorBackgroundPainterStrategy)this.backgroundPainter).setColor(color);
        } else {
            this.backgroundPainter = new ColorBackgroundPainterStrategy(color);
        }
        this.setOpaque(true);
        this.firePropertyChange("background", object, color);
        this.repaint();
    }

    public void setBackgroundImage(Image image) {
        Object object = this.getBackgroundObject();
        if (object instanceof Image) {
            ((BufferedImageBackgroundPainterStrategy)this.backgroundPainter).setImage(image);
        } else {
            BufferedImageBackgroundPainterStrategy bufferedImageBackgroundPainterStrategy = new BufferedImageBackgroundPainterStrategy(this);
            bufferedImageBackgroundPainterStrategy.setImage(image);
            this.backgroundPainter = bufferedImageBackgroundPainterStrategy;
        }
        this.setOpaque(false);
        this.firePropertyChange("background.image", object, image);
        this.repaint();
    }

    public void setBackgroundObject(Object object) {
        if (object instanceof Color) {
            this.setBackground((Color)object);
        } else if (object instanceof Image) {
            this.setBackgroundImage((Image)object);
        } else {
            this.setBackground(Color.WHITE);
        }
    }

    public void setCurrentLineHighlightColor(Color color) throws NullPointerException {
        if (color == null) {
            throw new NullPointerException();
        }
        if (!color.equals(this.currentLineColor)) {
            Color color2 = this.currentLineColor;
            this.currentLineColor = color;
            this.firePropertyChange(CURRENT_LINE_HIGHLIGHT_COLOR_PROPERTY, color2, color);
        }
    }

    public void setCurrentLineHighlightEnabled(boolean bl) {
        if (bl != this.highlightCurrentLine) {
            this.highlightCurrentLine = bl;
            this.firePropertyChange(CURRENT_LINE_HIGHLIGHT_PROPERTY, !bl, bl);
        }
    }

    public void setFadeCurrentLineHighlight(boolean bl) {
        if (bl != this.fadeCurrentLineHighlight) {
            this.fadeCurrentLineHighlight = bl;
            if (this.isCurrentLineHighlightEnabled()) {
                this.forceCurrentLineHighlightRepaint();
            }
            this.firePropertyChange(CURRENT_LINE_HIGHLIGHT_FADE_PROPERTY, !bl, bl);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateMarginLineX();
        if (this.highlightCurrentLine) {
            this.possiblyUpdateCurrentLineHighlightLocation();
        }
    }

    public void setLineWrap(boolean bl) {
        super.setLineWrap(bl);
        this.forceCurrentLineHighlightRepaint();
    }

    public void setMarginLineColor(Color color) {
        this.marginLineColor = color;
        if (this.marginLineEnabled) {
            Rectangle rectangle = this.getVisibleRect();
            this.repaint(this.marginLineX, rectangle.y, 1, rectangle.height);
        }
    }

    public void setMarginLineEnabled(boolean bl) {
        if (bl != this.marginLineEnabled) {
            this.marginLineEnabled = bl;
            if (this.marginLineEnabled) {
                Rectangle rectangle = this.getVisibleRect();
                this.repaint(this.marginLineX, rectangle.y, 1, rectangle.height);
            }
        }
    }

    public void setMarginLinePosition(int n) {
        this.marginSizeInChars = n;
        if (this.marginLineEnabled) {
            Rectangle rectangle = this.getVisibleRect();
            this.repaint(this.marginLineX, rectangle.y, 1, rectangle.height);
            this.updateMarginLineX();
            this.repaint(this.marginLineX, rectangle.y, 1, rectangle.height);
        }
    }

    public void setRoundedSelectionEdges(boolean bl) {
        if (this.roundedSelectionEdges != bl) {
            this.roundedSelectionEdges = bl;
            ConfigurableCaret configurableCaret = (ConfigurableCaret)this.getCaret();
            configurableCaret.setRoundedSelectionEdges(bl);
            if (configurableCaret.getDot() != configurableCaret.getMark()) {
                this.repaint();
            }
            this.firePropertyChange(ROUNDED_SELECTION_PROPERTY, !bl, bl);
        }
    }

    protected void setRTextAreaUI(RTextAreaUI rTextAreaUI) {
        super.setUI(rTextAreaUI);
        this.setOpaque(this.getBackgroundObject() instanceof Color);
    }

    public void setTabsEmulated(boolean bl) {
        this.tabsEmulatedWithSpaces = bl;
    }

    public void setTabSize(int n) {
        super.setTabSize(n);
        boolean bl = this.getLineWrap();
        this.setLineWrap(!bl);
        this.setLineWrap(bl);
    }

    protected void updateMarginLineX() {
        this.marginLineX = this.getFontMetrics(this.getFont()).charWidth('m') * this.marginSizeInChars;
    }

    protected class RTAMouseListener
    extends CaretEvent
    implements MouseListener,
    MouseMotionListener,
    FocusListener {
        protected int dot;
        protected int mark;

        RTAMouseListener(RTextAreaBase rTextAreaBase2) {
            super(rTextAreaBase2);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public int getDot() {
            return this.dot;
        }

        public int getMark() {
            return this.mark;
        }
    }
}

