/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.diff;

import ca.sqlpower.diff.DiffType;
import ca.sqlpower.diff.PropertyChange;
import ca.sqlpower.sqlobject.SQLColumn;
import java.util.ArrayList;
import java.util.List;

public class DiffChunk<T> {
    private DiffType type;
    private T data;
    private T originalData;
    final List<PropertyChange> changes;

    public DiffChunk(T data, DiffType type) {
        this.data = data;
        this.type = type;
        this.changes = new ArrayList<PropertyChange>();
    }

    public void setOriginalData(T old) {
        this.originalData = old;
    }

    public T getOriginalData() {
        return this.originalData;
    }

    public T getData() {
        return this.data;
    }

    public DiffType getType() {
        return this.type;
    }

    public String toString() {
        if (this.data instanceof SQLColumn) {
            SQLColumn c = (SQLColumn)this.data;
            String colname = c.getParent().getName() + "." + c.toString();
            return super.toString() + "(" + (Object)((Object)this.type) + ")[" + colname + "]";
        }
        return super.toString() + "(" + (Object)((Object)this.type) + ")[" + this.data + "]";
    }

    public List<PropertyChange> getPropertyChanges() {
        return this.changes;
    }

    public void addPropertyChange(PropertyChange change) {
        this.changes.add(change);
    }
}

