/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLSequence;
import ca.sqlpower.sqlobject.SQLTable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PostgresDDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 3995 $";
    private static final Logger logger = Logger.getLogger(PostgresDDLGenerator.class);
    public static final HashSet<String> RESERVED_WORDS = new HashSet();

    @Override
    public String getName() {
        return "PostgreSQL";
    }

    @Override
    public boolean isReservedWord(String word) {
        return RESERVED_WORDS.contains(word.toUpperCase());
    }

    @Override
    public void writeHeader() {
        this.println("-- Created by SQLPower PostgreSQL DDL Generator $Revision: 3995 $ --");
    }

    @Override
    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(-5, new GenericTypeDescriptor("BIGINT", -5, 1000L, null, null, 1, false, false));
        this.typeMap.put(-2, new GenericTypeDescriptor("BYTEA", -2, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(-7, new GenericTypeDescriptor("BIT", -7, 1L, null, null, 1, true, false));
        this.typeMap.put(2004, new GenericTypeDescriptor("BYTEA", 2004, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(16, new GenericTypeDescriptor("BOOLEAN", 16, 1L, null, null, 1, false, false));
        this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 4000000000L, "'", "'", 1, true, false));
        this.typeMap.put(2005, new GenericTypeDescriptor("TEXT", 2005, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(91, new GenericTypeDescriptor("DATE", 91, 0L, "'", "'", 1, false, false));
        this.typeMap.put(3, new GenericTypeDescriptor("NUMERIC", 3, 1000L, null, null, 1, true, true));
        this.typeMap.put(8, new GenericTypeDescriptor("DOUBLE PRECISION", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(6, new GenericTypeDescriptor("REAL", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(4, new GenericTypeDescriptor("INTEGER", 4, 38L, null, null, 1, false, false));
        this.typeMap.put(-4, new GenericTypeDescriptor("BYTEA", -4, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(-1, new GenericTypeDescriptor("TEXT", -1, 4000000000L, "'", "'", 1, false, false));
        this.typeMap.put(2, new GenericTypeDescriptor("NUMERIC", 2, 1000L, null, null, 1, true, true));
        this.typeMap.put(7, new GenericTypeDescriptor("REAL", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(5, new GenericTypeDescriptor("SMALLINT", 5, 16L, null, null, 1, false, false));
        this.typeMap.put(92, new GenericTypeDescriptor("TIME", 92, 0L, "'", "'", 1, false, false));
        this.typeMap.put(93, new GenericTypeDescriptor("TIMESTAMP", 93, 0L, "'", "'", 1, false, false));
        this.typeMap.put(-6, new GenericTypeDescriptor("SMALLINT", -6, 16L, null, null, 1, false, false));
        this.typeMap.put(-3, new GenericTypeDescriptor("BYTEA", -3, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR", 12, 4000000000L, "'", "'", 1, true, false));
    }

    private String toIdentifier(String logicalName, String physicalName) {
        if (logicalName == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getting physical name for: " + logicalName));
        }
        String ident = logicalName.replace(' ', '_').toLowerCase();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after replace of spaces: " + ident));
        }
        ident = ident.replaceAll("[^a-zA-Z0-9_$]", "_");
        if (physicalName == null) {
            if (ident.length() <= 63) {
                return ident;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("truncating identifier: " + ident));
            }
            String base = ident.substring(0, 60);
            int tiebreaker = (ident.hashCode() % 1000 + 1000) % 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("new identifier: " + base + tiebreaker));
            }
            return base + tiebreaker;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("physical identifier is not unique, regenerating: " + physicalName));
        }
        String base = ident;
        if (ident.length() > 63) {
            base = ident.substring(0, 60);
        }
        int tiebreaker = ((ident + physicalName).hashCode() % 1000 + 1000) % 1000;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("regenerated identifier is: " + base + tiebreaker));
        }
        return base + tiebreaker;
    }

    @Override
    public String toIdentifier(String name) {
        return this.toIdentifier(name, null);
    }

    @Override
    public String makeDropForeignKeySQL(String fkTable, String fkName) {
        return "\nALTER TABLE ONLY " + this.toQualifiedName(fkTable) + " DROP CONSTRAINT " + fkName;
    }

    @Override
    public void modifyColumn(SQLColumn c, DiffChunk<SQLObject> diffChunk) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        SQLTable t = c.getParent();
        this.print("\nALTER TABLE ONLY ");
        this.print(this.toQualifiedName(t));
        this.print(" ALTER COLUMN ");
        String columnPhysName = this.createPhysicalName(colNameMap, (SQLObject)c);
        this.print(columnPhysName);
        this.print(" TYPE ");
        this.print(this.columnType(c));
        this.print(", ALTER COLUMN ");
        this.print(columnPhysName);
        this.print(" ");
        this.print(c.isDefinitelyNullable() ? "DROP" : "SET");
        this.print(" NOT NULL");
        this.endStatement(DDLStatement.StatementType.MODIFY, (SQLObject)c);
    }

    @Override
    public String getCatalogTerm() {
        return null;
    }

    @Override
    public String getSchemaTerm() {
        return "Schema";
    }

    @Override
    public String getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return "public";
    }

    @Override
    public void addIndex(SQLIndex index) throws SQLObjectException {
        this.createPhysicalName(this.topLevelNames, (SQLObject)index);
        this.println("");
        this.print("CREATE ");
        if (index.isUnique()) {
            this.print("UNIQUE ");
        }
        this.print("INDEX ");
        this.print(this.toIdentifier(index.getName()));
        this.print("\n ON ");
        this.print(this.toQualifiedName(index.getParent()));
        if (index.getType() != null) {
            this.print(" USING " + index.getType());
        }
        this.print("\n ( ");
        boolean first = true;
        for (SQLIndex.Column c : index.getChildren(SQLIndex.Column.class)) {
            if (!first) {
                this.print(", ");
            }
            if (c.getColumn() != null) {
                this.print(c.getColumn().getPhysicalName());
            } else {
                this.print(c.getName());
            }
            this.print(c.getAscendingOrDescending() == SQLIndex.AscendDescend.ASCENDING ? " ASC" : "");
            this.print(c.getAscendingOrDescending() == SQLIndex.AscendDescend.DESCENDING ? " DESC" : "");
            first = false;
        }
        this.print(" )");
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)index);
        if (index.isClustered()) {
            this.addCluster(index, this.toIdentifier(index.getName()), index.getParent().getName());
        }
    }

    private void addCluster(SQLIndex index, String indexName, String table) {
        this.println("");
        this.print("CLUSTER " + indexName + " ON " + table);
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)index);
    }

    @Override
    public void addTable(SQLTable t) throws SQLException, SQLObjectException {
        SQLSequence seq;
        for (SQLColumn c : t.getColumns()) {
            if (!c.isAutoIncrement()) continue;
            seq = new SQLSequence(this.toIdentifier(c.getAutoIncrementSequenceName()));
            this.print("\nCREATE SEQUENCE ");
            this.print(this.toQualifiedName(seq.getName()));
            this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)seq);
        }
        super.addTable(t);
        for (SQLColumn c : t.getColumns()) {
            if (!c.isAutoIncrement()) continue;
            seq = new SQLSequence(this.toIdentifier(c.getAutoIncrementSequenceName()));
            this.print("\nALTER SEQUENCE " + this.toQualifiedName(seq.getName()) + " OWNED BY " + this.toQualifiedName(t) + "." + c.getPhysicalName());
            this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)seq);
        }
    }

    @Override
    protected String columnDefinition(SQLColumn c, Map<String, SQLObject> colNameMap) {
        String nameAndType = super.columnDefinition(c, colNameMap);
        if (c.isAutoIncrement()) {
            SQLSequence seq = new SQLSequence(this.toIdentifier(c.getAutoIncrementSequenceName()));
            return nameAndType + " DEFAULT nextval(" + SQL.quote((String)this.toQualifiedName(seq.getName())) + ")";
        }
        return nameAndType;
    }

    @Override
    protected String getPlatformName() {
        return "PostgreSQL";
    }

    @Override
    public void renameIndex(SQLIndex oldIndex, SQLIndex newIndex) throws SQLObjectException {
        this.print("ALTER INDEX ");
        this.print(this.toQualifiedName(oldIndex));
        this.print(" RENAME TO ");
        this.println(this.toQualifiedName(newIndex.getName()));
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)oldIndex);
    }

    @Override
    public void dropIndex(SQLIndex index) throws SQLObjectException {
        this.print("DROP INDEX ");
        this.print(this.toQualifiedName(index));
        this.println(" CASCADE");
        this.endStatement(DDLStatement.StatementType.DROP, (SQLObject)index);
    }

    @Override
    public boolean supportsEnumeration() {
        return false;
    }

    static {
        RESERVED_WORDS.add("AND");
        RESERVED_WORDS.add("ANY");
        RESERVED_WORDS.add("ARRAY");
        RESERVED_WORDS.add("AS");
        RESERVED_WORDS.add("ASC");
        RESERVED_WORDS.add("ASYMMETRIC");
        RESERVED_WORDS.add("BOTH");
        RESERVED_WORDS.add("CASE");
        RESERVED_WORDS.add("CAST");
        RESERVED_WORDS.add("CHECK");
        RESERVED_WORDS.add("COLLATE");
        RESERVED_WORDS.add("COLUMN");
        RESERVED_WORDS.add("CONSTRAINT");
        RESERVED_WORDS.add("CREATE");
        RESERVED_WORDS.add("CURRENT_DATE");
        RESERVED_WORDS.add("CURRENT_ROLE");
        RESERVED_WORDS.add("CURRENT_TIME");
        RESERVED_WORDS.add("CURRENT_TIMESTAMP");
        RESERVED_WORDS.add("CURRENT_USER");
        RESERVED_WORDS.add("DEFAULT");
        RESERVED_WORDS.add("DEFERRABLE");
        RESERVED_WORDS.add("DESC");
        RESERVED_WORDS.add("DISTINCT");
        RESERVED_WORDS.add("DO");
        RESERVED_WORDS.add("ELSE");
        RESERVED_WORDS.add("END");
        RESERVED_WORDS.add("EXCEPT");
        RESERVED_WORDS.add("FOR");
        RESERVED_WORDS.add("FOREIGN");
        RESERVED_WORDS.add("FROM");
        RESERVED_WORDS.add("GRANT");
        RESERVED_WORDS.add("GROUP");
        RESERVED_WORDS.add("HAVING");
        RESERVED_WORDS.add("IN");
        RESERVED_WORDS.add("INITIALLY");
        RESERVED_WORDS.add("INTERSECT");
        RESERVED_WORDS.add("INTO");
        RESERVED_WORDS.add("LEADING");
        RESERVED_WORDS.add("LIMIT");
        RESERVED_WORDS.add("LOCALTIME");
        RESERVED_WORDS.add("LOCALTIMESTAMP");
        RESERVED_WORDS.add("NEW");
        RESERVED_WORDS.add("NOT");
        RESERVED_WORDS.add("NULL");
        RESERVED_WORDS.add("OFF");
        RESERVED_WORDS.add("OFFSET");
        RESERVED_WORDS.add("OLD");
        RESERVED_WORDS.add("ON");
        RESERVED_WORDS.add("ONLY");
        RESERVED_WORDS.add("OR");
        RESERVED_WORDS.add("ORDER");
        RESERVED_WORDS.add("PLACING");
        RESERVED_WORDS.add("PRIMARY");
        RESERVED_WORDS.add("REFERENCES");
        RESERVED_WORDS.add("RETURNING");
        RESERVED_WORDS.add("SELECT");
        RESERVED_WORDS.add("SESSION_USER");
        RESERVED_WORDS.add("SOME");
        RESERVED_WORDS.add("SYMMETRIC");
        RESERVED_WORDS.add("TABLE");
        RESERVED_WORDS.add("THEN");
        RESERVED_WORDS.add("TO");
        RESERVED_WORDS.add("TRAILING");
        RESERVED_WORDS.add("UNION");
        RESERVED_WORDS.add("UNIQUE");
        RESERVED_WORDS.add("USER");
        RESERVED_WORDS.add("USING");
        RESERVED_WORDS.add("WHEN");
        RESERVED_WORDS.add("WHERE");
        RESERVED_WORDS.add("AUTHORIZATION");
        RESERVED_WORDS.add("BETWEEN");
        RESERVED_WORDS.add("BINARY");
        RESERVED_WORDS.add("CROSS");
        RESERVED_WORDS.add("FREEZE");
        RESERVED_WORDS.add("FULL");
        RESERVED_WORDS.add("ILIKE");
        RESERVED_WORDS.add("INNER");
        RESERVED_WORDS.add("IS");
        RESERVED_WORDS.add("ISNULL");
        RESERVED_WORDS.add("JOIN");
        RESERVED_WORDS.add("LEFT");
        RESERVED_WORDS.add("LIKE");
        RESERVED_WORDS.add("NATURAL");
        RESERVED_WORDS.add("NOTNULL");
        RESERVED_WORDS.add("OUTER");
        RESERVED_WORDS.add("OVERLAPS");
        RESERVED_WORDS.add("RIGHT");
        RESERVED_WORDS.add("SIMILAR");
        RESERVED_WORDS.add("VERBOSE");
    }
}

