/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.checksum;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.checksum.CheckSum;
import org.pentaho.di.trans.steps.checksum.CheckSumData;
import org.pentaho.di.trans.steps.checksum.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSumMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] fieldName;
    private String resultfieldName;
    public static final String TYPE_CRC32 = "CRC32";
    public static final String TYPE_ADLER32 = "ADLER32";
    public static final String TYPE_MD5 = "MD5";
    public static final String TYPE_SHA1 = "SHA-1";
    public static String[] checksumtypeCodes = new String[]{"CRC32", "ADLER32", "MD5", "SHA-1"};
    private String checksumtype;

    public void setCheckSumType(int i) {
        this.checksumtype = checksumtypeCodes[i];
    }

    public int getTypeByDesc() {
        if (this.checksumtype == null) {
            return 0;
        }
        int retval = this.checksumtype.equals(checksumtypeCodes[1]) ? 1 : (this.checksumtype.equals(checksumtypeCodes[2]) ? 2 : (this.checksumtype.equals(checksumtypeCodes[3]) ? 3 : 0));
        return retval;
    }

    public String getCheckSumType() {
        return this.checksumtype;
    }

    public String getResultFieldName() {
        return this.resultfieldName;
    }

    public void setResultFieldName(String resultfieldName) {
        this.resultfieldName = resultfieldName;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        CheckSumMeta retval = (CheckSumMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
        }
        return retval;
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.checksumtype = XMLHandler.getTagValue((Node)stepnode, (String)"checksumtype");
            this.resultfieldName = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldName");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append("      ").append(XMLHandler.addTagValue((String)"checksumtype", (String)this.checksumtype));
        retval.append("      ").append(XMLHandler.addTagValue((String)"resultfieldName", (String)this.resultfieldName));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void setDefault() {
        this.resultfieldName = null;
        this.checksumtype = checksumtypeCodes[0];
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.checksumtype = rep.getStepAttributeString(id_step, "checksumtype");
            this.resultfieldName = rep.getStepAttributeString(id_step, "resultfieldName");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "checksumtype", this.checksumtype);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldName", this.resultfieldName);
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (!Const.isEmpty((String)this.resultfieldName)) {
            ValueMeta v = null;
            v = this.checksumtype.equals(TYPE_CRC32) || this.checksumtype.equals(TYPE_ADLER32) ? new ValueMeta(space.environmentSubstitute(this.resultfieldName), 5) : new ValueMeta(space.environmentSubstitute(this.resultfieldName), 2);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.resultfieldName)) {
            error_message = Messages.getString("CheckSumMeta.CheckResult.ResultFieldMissing");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
        } else {
            error_message = Messages.getString("CheckSumMeta.CheckResult.ResultFieldOK");
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
        }
        remarks.add((CheckResultInterface)cr);
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, Messages.getString("CheckSumMeta.CheckResult.NotReceivingFields"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("CheckSumMeta.CheckResult.StepRecevingData", prev.size() + ""), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            boolean error_found = false;
            error_message = "";
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.indexOfValue(this.fieldName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.fieldName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = Messages.getString("CheckSumMeta.CheckResult.FieldsFound", error_message);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else if (this.fieldName.length > 0) {
                cr = new CheckResult(1, Messages.getString("CheckSumMeta.CheckResult.AllFieldsFound"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(3, Messages.getString("CheckSumMeta.CheckResult.NoFieldsEntered"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("CheckSumMeta.CheckResult.StepRecevingData2"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("CheckSumMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new CheckSum(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new CheckSumData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

