/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldifinput;

import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFContent;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputData;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputField;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputMeta;
import org.pentaho.di.trans.steps.ldifinput.Messages;

public class LDIFInput
extends BaseStep
implements StepInterface {
    private LDIFInputMeta meta;
    private LDIFInputData data;

    public LDIFInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] getOneRow() throws KettleException {
        try {
            if (this.meta.isFileField()) {
                while (this.data.readrow == null || (this.data.recordLDIF = this.data.InputLDIF.nextRecord()) == null) {
                    if (this.openNextFile()) continue;
                    return null;
                }
            } else {
                while (this.data.file == null || (this.data.recordLDIF = this.data.InputLDIF.nextRecord()) == null) {
                    if (this.openNextFile()) continue;
                    return null;
                }
            }
        }
        catch (Exception IO) {
            return null;
        }
        LDIFContent contentLDIF = this.data.recordLDIF.getContent();
        String contentTYPE = "ATTRIBUTE_CONTENT";
        if (contentLDIF.getType() == 2) {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), Messages.getString("LDIFInput.Log.ContentType", "DELETE_CONTENT"), new Object[0]);
            }
            contentTYPE = "DELETE_CONTENT";
        } else if (contentLDIF.getType() == 1) {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), Messages.getString("LDIFInput.Log.ContentType", "ADD_CONTENT"), new Object[0]);
            }
            contentTYPE = "ADD_CONTENT";
        } else if (contentLDIF.getType() == 4) {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), Messages.getString("LDIFInput.Log.ContentType", "MODDN_CONTENT"), new Object[0]);
            }
            contentTYPE = "MODDN_CONTENT";
        } else if (contentLDIF.getType() == 3) {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), Messages.getString("LDIFInput.Log.ContentType", "MODIFICATION_CONTENT"), new Object[0]);
            }
            contentTYPE = "MODIFICATION_CONTENT";
        } else if (this.log.isDetailed()) {
            this.log.logDetailed(this.toString(), Messages.getString("LDIFInput.Log.ContentType", "ATTRIBUTE_CONTENT"), new Object[0]);
        }
        LDIFAttributeContent attrContentLDIF = (LDIFAttributeContent)contentLDIF;
        this.data.attributes_LDIF = attrContentLDIF.getAttributes();
        Object[] outputRowData = this.buildEmptyRow();
        if (this.meta.isFileField()) {
            System.arraycopy(this.data.readrow, 0, outputRowData, 0, this.data.readrow.length);
        }
        try {
            RowMetaInterface irow;
            for (int i = 0; i < this.meta.getInputFields().length; ++i) {
                LDIFInputField ldifInputField = this.meta.getInputFields()[i];
                String AttributValue = this.environmentSubstitute(ldifInputField.getAttribut());
                String Value = this.GetValue(this.data.attributes_LDIF, AttributValue);
                switch (ldifInputField.getTrimType()) {
                    case 1: {
                        Value = Const.ltrim((String)Value);
                        break;
                    }
                    case 2: {
                        Value = Const.rtrim((String)Value);
                        break;
                    }
                    case 3: {
                        Value = Const.trim((String)Value);
                        break;
                    }
                }
                ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                outputRowData[this.data.totalpreviousfields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)Value);
                if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)Value)) continue;
                outputRowData[this.data.totalpreviousfields + i] = this.data.previousRow[this.data.totalpreviousfields + i];
            }
            int rowIndex = this.meta.getInputFields().length;
            if (this.meta.includeFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
                outputRowData[this.data.totalpreviousfields + rowIndex++] = KettleVFS.getFilename((FileObject)this.data.file);
            }
            if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
                outputRowData[this.data.totalpreviousfields + rowIndex++] = new Long(this.data.rownr);
            }
            if (this.meta.includeContentType() && !Const.isEmpty((String)this.meta.getContentTypeField())) {
                outputRowData[this.data.totalpreviousfields + rowIndex++] = contentTYPE;
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
            this.incrementLinesInput();
            ++this.data.rownr;
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("LDIFInput.Exception.UnableToReadFile", this.data.file.toString()), (Throwable)e);
        }
        return outputRowData;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block5: {
            Object[] r = null;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                Object[] outputRowData = this.getOneRow();
                if (outputRowData == null) {
                    this.setOutputDone();
                    return false;
                }
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("LDIFInput.ErrorInStepRunning", e.getMessage()));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block5;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "LDIFInput001");
            }
        }
        return true;
    }

    private boolean openNextFile() {
        try {
            if (!this.meta.isFileField()) {
                if (this.data.filenr >= this.data.files.nrOfFiles()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("LDIFInput.Log.FinishedProcessing"));
                    }
                    return false;
                }
                this.data.last_file = this.data.filenr == this.data.files.nrOfFiles() - 1;
                this.data.file = this.data.files.getFile(this.data.filenr);
                ++this.data.filenr;
            } else {
                this.data.readrow = this.getRow();
                if (this.data.readrow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("LDIFInput.Log.FinishedProcessing"));
                    }
                    return false;
                }
                if (this.first) {
                    int i;
                    this.first = false;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    if (Const.isEmpty((String)this.meta.getDynamicFilenameField())) {
                        this.logError(Messages.getString("LDIFInput.Log.NoField"));
                        throw new KettleException(Messages.getString("LDIFInput.Log.NoField"));
                    }
                    if (this.data.indexOfFilenameField < 0) {
                        this.data.indexOfFilenameField = this.getInputRowMeta().indexOfValue(this.meta.getDynamicFilenameField());
                        if (this.data.indexOfFilenameField < 0) {
                            this.logError(Messages.getString("LDIFInput.Log.ErrorFindingField") + "[" + this.meta.getDynamicFilenameField() + "]");
                            throw new KettleException(Messages.getString("LDIFInput.Exception.CouldnotFindField", this.meta.getDynamicFilenameField()));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfFilenameField);
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("LDIFInput.Log.FilenameInStream", this.meta.getDynamicFilenameField(), filename), new Object[0]);
                }
                this.data.file = KettleVFS.getFileObject((String)filename);
            }
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("LDIFInput.Log.OpeningFile", this.data.file.toString()));
            }
            if (this.meta.AddToResultFilename()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(Messages.getString("LDIFInput.Log.FileAddedResult"));
                this.addResultFile(resultFile);
            }
            this.data.InputLDIF = new LDIF(KettleVFS.getFilename((FileObject)this.data.file));
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("LDIFInput.Log.FileOpened", this.data.file.toString()));
            }
        }
        catch (Exception e) {
            this.logError(Messages.getString("LDIFInput.Log.UnableToOpenFile", "" + this.data.filenr, this.data.file.toString(), e.toString()));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private String GetValue(LDAPAttribute[] attributes_LDIF, String AttributValue) {
        String Stringvalue = null;
        int i = 0;
        for (int j = 0; j < attributes_LDIF.length; ++j) {
            LDAPAttribute attribute_DIF = attributes_LDIF[j];
            if (!attribute_DIF.getName().equalsIgnoreCase(AttributValue)) continue;
            Enumeration valuesLDIF = attribute_DIF.getStringValues();
            while (valuesLDIF.hasMoreElements()) {
                String valueLDIF = (String)valuesLDIF.nextElement();
                Stringvalue = i == 0 ? valueLDIF : Stringvalue + this.data.multiValueSeparator + valueLDIF;
                ++i;
            }
        }
        return Stringvalue;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LDIFInputMeta)smi;
        this.data = (LDIFInputData)sdi;
        if (super.init(smi, sdi)) {
            if (!this.meta.isFileField()) {
                this.data.files = this.meta.getFiles(this);
                if (this.data.files.nrOfFiles() == 0 && this.data.files.nrOfMissingFiles() == 0) {
                    this.logError(Messages.getString("LDIFInput.Log.NoFiles"));
                    return false;
                }
                try {
                    int i;
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    this.data.nrInputFields = this.meta.getInputFields().length;
                    this.data.multiValueSeparator = this.environmentSubstitute(this.meta.getMultiValuedSeparator());
                }
                catch (Exception e) {
                    this.logError("Error initializing step: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            this.data.rownr = 1L;
            this.data.totalpreviousfields = 0;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LDIFInputMeta)smi;
        this.data = (LDIFInputData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.data.InputLDIF != null) {
            this.data.InputLDIF = null;
        }
        if (this.data.attributes_LDIF != null) {
            this.data.attributes_LDIF = null;
        }
        if (this.data.recordLDIF != null) {
            this.data.recordLDIF = null;
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

