/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.nullif;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.nullif.Messages;
import org.pentaho.di.trans.steps.nullif.NullIf;
import org.pentaho.di.trans.steps.nullif.NullIfData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullIfMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] fieldName;
    private String[] fieldValue;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String[] fieldValue) {
        this.fieldValue = fieldValue;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.fieldValue = new String[count];
    }

    @Override
    public Object clone() {
        NullIfMeta retval = (NullIfMeta)super.clone();
        int count = this.fieldName.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldValue[i] = this.fieldValue[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"value");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("NullIfMeta.Exception.UnableToReadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldValue[i] = "";
        }
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) {
        if (r == null) {
            r = new RowMeta();
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"value", (String)this.fieldValue[i]));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldValue[i] = rep.getStepAttributeString(id_step, i, "field_value");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("NullIfMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_value", this.fieldValue[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("NullIfMeta.Exception.UnableToSaveStepInfoToRepository") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, Messages.getString("NullIfMeta.CheckResult.NoReceivingFieldsError"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("NullIfMeta.CheckResult.StepReceivingFieldsOK", prev.size() + ""), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("NullIfMeta.CheckResult.StepRecevingInfoFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("NullIfMeta.CheckResult.NoInputReceivedError"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new NullIf(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new NullIfData();
    }
}

