/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.Md5SumMismatchException;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import com.amazon.aes.webservices.client.vmconversionschema.ByteRange;
import com.amazon.aes.webservices.client.vmconversionschema.Import;
import com.amazon.aes.webservices.client.vmconversionschema.Importer;
import com.amazon.aes.webservices.client.vmconversionschema.Manifest;
import com.amazon.aes.webservices.client.vmconversionschema.Part;
import com.amazon.aes.webservices.client.vmconversionschema.Parts;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.HttpMethod;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.util.BinaryUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class ManifestFactory {
    protected AmazonS3 s3Client;
    public static final String MANIFEST_SUFFIX = "manifest.xml";
    public static final String PART_SUFFIX = "part";

    public ManifestFactory(AmazonS3 s3Client) {
        this.s3Client = s3Client;
    }

    private String getKeyPrefix(String userPrefix, File file) {
        StringBuilder keyPrefix = new StringBuilder();
        if (userPrefix != null) {
            keyPrefix.append(userPrefix);
            if (!userPrefix.endsWith("/")) {
                keyPrefix.append('/');
            }
        }
        keyPrefix.append(UUID.randomUUID().toString() + "/");
        keyPrefix.append(file.getName());
        return keyPrefix.toString();
    }

    public void verifyRegionAffinity(String desiredLocation, String bucketName, boolean verifyLocation) throws VerificationException, AmazonServiceException, AmazonClientException {
        if (verifyLocation) {
            String bucketLocation = this.s3Client.getBucketLocation(bucketName);
            if ("US".equals(bucketLocation)) {
                bucketLocation = "us-east-1";
            }
            if (null == desiredLocation || "US".equalsIgnoreCase(desiredLocation)) {
                desiredLocation = "us-east-1";
            }
            if (desiredLocation != bucketLocation && !bucketLocation.equals(desiredLocation)) {
                if (desiredLocation.equals("eu-west-1") && (bucketLocation.equals("eu-west-1") || bucketLocation.equals("EU"))) {
                    return;
                }
                throw new VerificationException("Bucket " + bucketName + " is not in " + desiredLocation + " region, it's in " + bucketLocation);
            }
        }
    }

    private void createBucketIfNotFound(String bucketName, String location) throws VerificationException {
        try {
            if (this.s3Client.doesBucketExist(bucketName)) {
                return;
            }
            this.s3Client.createBucket(bucketName, location);
        }
        catch (AmazonClientException e) {
            throw new VerificationException("Cannot access/create bucket: " + bucketName + " : " + e.toString());
        }
    }

    public String createSignedManifestUrl(File file, String bucketName, String location, String userPrefix, int expirationDays, boolean verifyLocation) throws AmazonClientException, VerificationException {
        String keyPrefix = this.getKeyPrefix(userPrefix, file);
        this.createBucketIfNotFound(bucketName, location);
        try {
            this.verifyRegionAffinity(location, bucketName, verifyLocation);
        }
        catch (AmazonClientException e) {
            throw new VerificationException("Could not verify the region for bucket " + bucketName + " ; received error: " + e.toString());
        }
        String signedUrl = this.getManifestS3Object(bucketName, keyPrefix + MANIFEST_SUFFIX, expirationDays);
        return signedUrl;
    }

    public String createSignedManifestUrl(File file, URL manifestUrl, String location, int expirationDays, boolean verifyLocation) throws AmazonClientException, VerificationException, URISyntaxException {
        S3Object manifestS3Object = ManifestFactory.getManifestS3Object(manifestUrl);
        String bucketName = manifestS3Object.getBucketName();
        String keyPrefix = ManifestFactory.getKeyPrefixFromManifest(manifestS3Object.getKey());
        if (keyPrefix.length() < 1) {
            throw new VerificationException("Cannot determine manifest object from URL " + manifestUrl.toExternalForm());
        }
        this.createBucketIfNotFound(bucketName, location);
        try {
            this.verifyRegionAffinity(location, bucketName, verifyLocation);
        }
        catch (AmazonClientException e) {
            throw new VerificationException("Could not verify the region for bucket " + bucketName + " ; received error: " + e.toString());
        }
        String signedUrl = this.getManifestS3Object(bucketName, keyPrefix + MANIFEST_SUFFIX, expirationDays);
        return signedUrl;
    }

    private String getManifestS3Object(String bucketName, String manifestPrefix, int expirationDays) throws AmazonClientException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.add(5, expirationDays);
        Date signedUrlExpiration = cal.getTime();
        String signedUrl = this.s3Client.generatePresignedUrl(bucketName, manifestPrefix, signedUrlExpiration).toString();
        return signedUrl;
    }

    public static S3Object getManifestS3Object(URL manifestUrl) throws URISyntaxException {
        AmazonS3URI uri = new AmazonS3URI(manifestUrl.toURI());
        S3Object s3Object = new S3Object();
        s3Object.setBucketName(uri.getBucket());
        s3Object.setKey(uri.getKey());
        return s3Object;
    }

    public static String getBucketName(S3Object manifestS3Object) {
        if (manifestS3Object == null) {
            System.err.println("Bug Bug null manifest object");
            System.exit(-1);
        }
        return manifestS3Object.getBucketName();
    }

    public Manifest createManifestUnlessExists(URL manifestUrl, File file, String fileFormat, long volumeSize, long partSize, int expirationDays, boolean dryRun) throws VerificationException, InternalException, URISyntaxException {
        S3Object manifestS3Object = ManifestFactory.getManifestS3Object(manifestUrl);
        String bucketName = manifestS3Object.getBucketName();
        Manifest manifest = null;
        boolean manifestExists = false;
        try {
            this.s3Client.getObjectMetadata(bucketName, manifestS3Object.getKey());
            manifestExists = true;
        }
        catch (AmazonServiceException e) {
            switch (e.getStatusCode()) {
                case 403: {
                    manifestExists = true;
                    break;
                }
                case 404: {
                    manifestExists = false;
                    break;
                }
                default: {
                    String msg = e.getMessage();
                    throw new InternalException("Cannot determine if manifest file exists. " + msg);
                }
            }
        }
        if (dryRun && !manifestExists) {
            return null;
        }
        if (!manifestExists) {
            System.out.println("Creating new manifest at " + bucketName + "/" + manifestS3Object.getKey());
            String keyPrefix = ManifestFactory.getKeyPrefixFromManifest(manifestS3Object.getKey());
            try {
                manifest = this.createAndUploadManifest(file, fileFormat, manifestS3Object, keyPrefix, volumeSize, partSize, expirationDays);
            }
            catch (Exception e) {
                String msg = e.getMessage() == null ? "" : e.getMessage();
                throw new InternalException("Error uploading manifest file. " + msg);
            }
        }
        try {
            S3Object oldManifest = this.s3Client.getObject(manifestS3Object.getBucketName(), manifestS3Object.getKey());
            manifest = this.loadExistingManifest(oldManifest);
            this.verifyManifest(manifest, file, fileFormat, volumeSize);
        }
        catch (Exception e) {
            if (e instanceof VerificationException) {
                throw (VerificationException)e;
            }
            String msg = e.getMessage() == null ? "" : e.getMessage();
            throw new InternalException("Error downloading manifest file. " + msg);
        }
        return manifest;
    }

    private void verifyManifest(Manifest manifest, File file, String fileFormat, long volumeSize) throws VerificationException {
        if (!manifest.getFileFormat().equalsIgnoreCase(fileFormat)) {
            throw new VerificationException("The file format in the manifest is " + manifest.getFileFormat() + ". The expected format is " + fileFormat);
        }
        if (manifest.getImport().getSize() != file.length()) {
            throw new VerificationException("The file size in the manifest is " + manifest.getImport().getSize() + ". The expected file size is " + file.length());
        }
        if (manifest.getImport().getVolumeSize() != volumeSize) {
            throw new VerificationException("The volume size in the manifest is " + manifest.getImport().getVolumeSize() + ". The expected volume size is " + volumeSize);
        }
    }

    public static String getKeyPrefixFromManifest(String key) {
        String keyPrefix = key;
        if (key.endsWith(MANIFEST_SUFFIX)) {
            keyPrefix = key.substring(0, key.length() - MANIFEST_SUFFIX.length());
        }
        return keyPrefix;
    }

    protected Manifest createAndUploadManifest(File file, String fileFormat, S3Object manifestS3Object, String keyPrefix, long volumeSize, long partSize, int expirationDays) throws IOException, JAXBException, NoSuchAlgorithmException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.add(5, expirationDays);
        Date signedUrlExpiration = cal.getTime();
        Manifest manifest = this.createNewManifest(file, fileFormat, manifestS3Object.getBucketName(), manifestS3Object.getKey(), keyPrefix, volumeSize, partSize, signedUrlExpiration);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.amazon.aes.webservices.client.vmconversionschema");
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream manifestOutputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)manifest, (OutputStream)manifestOutputStream);
        byte[] manifestContents = manifestOutputStream.toByteArray();
        System.out.println("Uploading the manifest file");
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength((long)manifestContents.length);
        metadata.setContentType("text/plain; charset=utf-8");
        this.s3Client.putObject(manifestS3Object.getBucketName(), manifestS3Object.getKey(), (InputStream)new ByteArrayInputStream(manifestContents), metadata);
        return manifest;
    }

    public Manifest createNewManifest(File file, String fileFormat, String bucketName, String key, String keyPrefix, long volumeSize, long partSize, Date signedUrlExpiration) throws IOException, AmazonClientException {
        Importer importer = new Importer();
        importer.setName("ec2-upload-disk-image");
        importer.setVersion("1.0.0");
        importer.setRelease("2010-11-15");
        Manifest manifest = new Manifest();
        manifest.setVersion("2010-11-15");
        manifest.setFileFormat(fileFormat);
        manifest.setImporter(importer);
        manifest.setSelfDestructUrl(this.s3Client.generatePresignedUrl(bucketName, key, signedUrlExpiration, HttpMethod.DELETE).toString());
        manifest.setImport(this.createImport(file, bucketName, keyPrefix, partSize, volumeSize, signedUrlExpiration));
        return manifest;
    }

    private Import createImport(File file, String bucketName, String keyPrefix, long partSize, long volumeSize, Date signedUrlExpiration) throws AmazonClientException {
        int partCount = (int)Math.ceil((double)file.length() / (double)partSize);
        Parts parts = new Parts();
        parts.setCount(partCount);
        for (int i = 0; i < partCount; ++i) {
            Part part = new Part();
            parts.getPart().add(part);
            part.setIndex(i);
            long start = (long)i * partSize;
            long end = (long)(i + 1) * partSize - 1L;
            if (end >= file.length()) {
                end = file.length() - 1L;
            }
            ByteRange byteRange = new ByteRange();
            byteRange.setStart(start);
            byteRange.setEnd(end);
            part.setByteRange(byteRange);
            String key = keyPrefix + "." + PART_SUFFIX + i;
            part.setKey(key);
            part.setHeadUrl(this.s3Client.generatePresignedUrl(bucketName, key, signedUrlExpiration, HttpMethod.HEAD).toString());
            part.setGetUrl(this.s3Client.generatePresignedUrl(bucketName, key, signedUrlExpiration, HttpMethod.GET).toString());
            part.setDeleteUrl(this.s3Client.generatePresignedUrl(bucketName, key, signedUrlExpiration, HttpMethod.DELETE).toString());
        }
        Import importt = new Import();
        importt.setSize(file.length());
        importt.setVolumeSize(volumeSize);
        importt.setParts(parts);
        return importt;
    }

    public Manifest loadExistingManifest(S3Object manifestS3Object) throws IOException, JAXBException, NoSuchAlgorithmException, Md5SumMismatchException {
        StringBuilder manifestContents = new StringBuilder();
        char[] buff = new char[65536];
        int bytesRead = -1;
        S3ObjectInputStream manifestStream = manifestS3Object.getObjectContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)manifestStream, "UTF-8"));
        while ((bytesRead = reader.read(buff, 0, buff.length)) != -1) {
            manifestContents.append(buff, 0, bytesRead);
        }
        manifestStream.close();
        MessageDigest digg2 = MessageDigest.getInstance("MD5");
        digg2.update(manifestContents.toString().getBytes("UTF-8"));
        byte[] myDigest = digg2.digest();
        String myMd5Sum = BinaryUtils.toBase64((byte[])myDigest);
        String s3ETag = manifestS3Object.getObjectMetadata().getETag();
        String objectMd5 = BinaryUtils.toBase64((byte[])BinaryUtils.fromHex((String)s3ETag));
        if (!myMd5Sum.equals(objectMd5)) {
            throw new Md5SumMismatchException("MD5 hash verfication failed for the downloaded manifest");
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.amazon.aes.webservices.client.vmconversionschema");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(this.getClass().getClassLoader().getResource("ImportManifest.xsd"));
            unmarshaller.setSchema(schema);
        }
        catch (SAXException e) {
            throw new JAXBException((Throwable)e);
        }
        return (Manifest)unmarshaller.unmarshal((Reader)new StringReader(manifestContents.toString()));
    }
}

