/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMFrame;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ThreadId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.util.Location;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ThreadReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeName(bb, os);
                    break;
                }
                case 2: {
                    this.executeSuspend(bb, os);
                    break;
                }
                case 3: {
                    this.executeResume(bb, os);
                    break;
                }
                case 4: {
                    this.executeStatus(bb, os);
                    break;
                }
                case 5: {
                    this.executeThreadGroup(bb, os);
                    break;
                }
                case 6: {
                    this.executeFrames(bb, os);
                    break;
                }
                case 7: {
                    this.executeFrameCount(bb, os);
                    break;
                }
                case 8: {
                    this.executeOwnedMonitors(bb, os);
                    break;
                }
                case 9: {
                    this.executeCurrentContendedMonitor(bb, os);
                    break;
                }
                case 10: {
                    this.executeStop(bb, os);
                    break;
                }
                case 11: {
                    this.executeInterrupt(bb, os);
                    break;
                }
                case 12: {
                    this.executeSuspendCount(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in Thread Reference Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private void executeName(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tid.getThread();
        JdwpString.writeString(os, thread.getName());
    }

    private void executeSuspend(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tid.getThread();
        VMVirtualMachine.suspendThread(thread);
    }

    private void executeResume(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tid.getThread();
        VMVirtualMachine.resumeThread(thread);
    }

    private void executeStatus(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tid.getThread();
        int threadStatus = VMVirtualMachine.getThreadStatus(thread);
        int suspendStatus = 1;
        os.writeInt(threadStatus);
        os.writeInt(suspendStatus);
    }

    private void executeThreadGroup(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tid.getThread();
        ThreadGroup group = thread.getThreadGroup();
        ObjectId groupId = this.idMan.getObjectId(group);
        groupId.write(os);
    }

    private void executeFrames(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tid.getThread();
        int startFrame = bb.getInt();
        int length = bb.getInt();
        ArrayList frames = VMVirtualMachine.getFrames(thread, startFrame, length);
        os.writeInt(frames.size());
        int i = 0;
        while (i < frames.size()) {
            VMFrame frame = (VMFrame)frames.get(i);
            os.writeLong(frame.getId());
            Location loc = frame.getLocation();
            loc.write(os);
            ++i;
        }
    }

    private void executeFrameCount(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tid.getThread();
        int frameCount = VMVirtualMachine.getFrameCount(thread);
        os.writeInt(frameCount);
    }

    private void executeOwnedMonitors(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        String msg = "getting owned monitors is not supported";
        throw new NotImplementedException(msg);
    }

    private void executeCurrentContendedMonitor(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        String msg = "getting current contended monitor is not supported";
        throw new NotImplementedException(msg);
    }

    private void executeStop(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tid.getThread();
        ObjectId exception = this.idMan.readObjectId(bb);
        Throwable throwable = (Throwable)exception.getObject();
        thread.stop(throwable);
    }

    private void executeInterrupt(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tid.getThread();
        thread.interrupt();
    }

    private void executeSuspendCount(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tid.getThread();
        int suspendCount = VMVirtualMachine.getSuspendCount(thread);
        os.writeInt(suspendCount);
    }
}

