#!/bin/sh
export PATH='/usr/obj/ports/hs-dbus-0.10.13/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: dbus
version: 0.10.13
id: dbus-0.10.13-IUelLsOGWpyBGcXH63C8d4
key: dbus-0.10.13-IUelLsOGWpyBGcXH63C8d4
license: GPL-3
maintainer: Andrey Sverdlichenko <blaze@ruddy.ru>, John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://github.com/rblaze/haskell-dbus#readme
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
indefinite: False
exposed-modules:
    DBus DBus.Client DBus.Internal.Address DBus.Internal.Message
    DBus.Internal.Types DBus.Internal.Wire DBus.Introspection
    DBus.Socket DBus.Transport
abi: 4fd3aaef7268817e42932fbae92558e8
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.13
library-dirs: /usr/local/lib/ghc/dbus-0.10.13
              /usr/local/lib/i386-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-dbus-0.10.13
hs-libraries: HSdbus-0.10.13-IUelLsOGWpyBGcXH63C8d4
depends:
    base-4.10.1.0 bytestring-0.10.8.2
    cereal-0.4.1.0-J7JNgMSSYgsLRU6KWtlHY0 containers-0.5.10.2
    libxml-sax-0.7.5-CWwwLs2Cpr07R9NPn064CX
    network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV
    parsec-3.1.9-444fzLM2idQ5vByZuGIOJ
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ transformers-0.5.2.0
    unix-2.7.2.2 vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
    xml-types-0.3.6-KBWVauU3pnf3clHxqFFRXL
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             bytestring-0.10.8.2=2a4bbfd60b4f148922e8caf44d9009f9
             cereal-0.4.1.0-J7JNgMSSYgsLRU6KWtlHY0=a538055727006ce5679183abfbf8a571
             containers-0.5.10.2=2ff387bb382d9f510ffcf8f3ed2013c5
             libxml-sax-0.7.5-CWwwLs2Cpr07R9NPn064CX=81552ef3e4eeae4da9090f9818ad79c0
             network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV=8851adc1c0835b2434fe123b5bcd5394
             parsec-3.1.9-444fzLM2idQ5vByZuGIOJ=597887a48283a4fccf50985e5cc89cb8
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=079775dbbb7035e99fa63cf766329cec
             text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ=77e10b579708f506156fd8ed84f18afc
             transformers-0.5.2.0=650a984849062cc36a998e6c890bf69a
             unix-2.7.2.2=fdb14956a5b19c6bc5b505e3d2c05085
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=e7e504497bf3603a09d1b2efc5f2260c
             xml-types-0.3.6-KBWVauU3pnf3clHxqFFRXL=b1dbabf0889a0336fa5c5b2e21d4a9cd
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.13/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.13/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

