/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.jnlp.config.Defaults;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.config.ValueValidator;

public class ConfiguratonValidator {
    private List<Setting<String>> incorrectEntries;
    private List<Setting<String>> unrecognizedEntries;
    private Map<String, Setting<String>> toValidate = null;
    private boolean validated = false;

    public ConfiguratonValidator(Map<String, Setting<String>> toValidate) {
        this.toValidate = toValidate;
    }

    public void validate() {
        this.incorrectEntries = new ArrayList<Setting<String>>();
        this.unrecognizedEntries = new ArrayList<Setting<String>>();
        Map<String, Setting<String>> knownGood = Defaults.getDefaults();
        for (String key : this.toValidate.keySet()) {
            if (knownGood.containsKey(key)) {
                Setting<String> good = knownGood.get(key);
                Setting<String> unknown = this.toValidate.get(key);
                ValueValidator checker = good.getValidator();
                if (checker == null) continue;
                try {
                    checker.validate(unknown.getValue());
                }
                catch (IllegalArgumentException e) {
                    Setting<String> strange = new Setting<String>(unknown);
                    strange.setValue(unknown.getValue());
                    this.incorrectEntries.add(strange);
                }
                continue;
            }
            Setting<String> strange = new Setting<String>(this.toValidate.get(key));
            this.unrecognizedEntries.add(strange);
        }
        this.validated = true;
    }

    public List<Setting<String>> getIncorrectSetting() {
        if (!this.validated) {
            throw new IllegalStateException();
        }
        return new ArrayList<Setting<String>>(this.incorrectEntries);
    }

    public List<Setting<String>> getUnrecognizedSetting() {
        if (!this.validated) {
            throw new IllegalStateException();
        }
        return new ArrayList<Setting<String>>(this.unrecognizedEntries);
    }
}

