/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.files;

import com.android.dex.Dex;
import jadx.core.utils.AsmUtils;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.DexFile;
import jadx.core.utils.files.FileUtils;
import jadx.core.utils.files.JavaToDex;
import jadx.core.utils.files.ZipSecurity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFile {
    private static final Logger LOG = LoggerFactory.getLogger(InputFile.class);
    private final File file;
    private final List<DexFile> dexFiles = new ArrayList<DexFile>();

    public static void addFilesFrom(File file, List<InputFile> list, boolean ... skipSources) throws IOException, DecodeException {
        InputFile inputFile = new InputFile(file);
        inputFile.searchDexFiles(skipSources[0]);
        list.add(inputFile);
    }

    private InputFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File not found: " + file.getAbsolutePath());
        }
        this.file = file;
    }

    private void searchDexFiles(boolean skipSources) throws IOException, DecodeException {
        String fileName = this.file.getName();
        if (fileName.endsWith(".dex")) {
            this.addDexFile(new Dex(this.file));
            return;
        }
        if (fileName.endsWith(".class")) {
            this.addDexFile(InputFile.loadFromClassFile(this.file));
            return;
        }
        if (FileUtils.isApkFile(this.file) || FileUtils.isZipDexFile(this.file)) {
            this.loadFromZip(".dex");
            return;
        }
        if (fileName.endsWith(".jar")) {
            if (this.loadFromZip(".dex")) {
                return;
            }
            if (fileName.endsWith(".jar")) {
                this.addDexFile(InputFile.loadFromJar(this.file));
                return;
            }
            if (fileName.endsWith(".aar")) {
                this.loadFromZip(".jar");
                return;
            }
            return;
        }
        if (skipSources) {
            return;
        }
        throw new DecodeException("Unsupported input file format: " + this.file);
    }

    private void addDexFile(Dex dexBuf) {
        this.addDexFile("", dexBuf);
    }

    private void addDexFile(String fileName, Dex dexBuf) {
        this.dexFiles.add(new DexFile(this, fileName, dexBuf));
    }

    private boolean loadFromZip(String ext) throws IOException, DecodeException {
        int index = 0;
        try (ZipFile zf = new ZipFile(this.file);){
            String instantRunDexSuffix = "classes" + ext;
            Enumeration<? extends ZipEntry> e = zf.entries();
            block44: while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!ZipSecurity.isValidZipEntry(entry)) continue;
                String entryName = entry.getName();
                InputStream inputStream = zf.getInputStream(entry);
                Throwable throwable = null;
                try {
                    Object dexBuf;
                    block57: {
                        if ((!entryName.startsWith("classes") || !entryName.endsWith(ext)) && !entryName.endsWith(instantRunDexSuffix)) break block57;
                        switch (ext) {
                            case ".dex": {
                                dexBuf = this.makeDexBuf(entryName, inputStream);
                                if (dexBuf == null) continue block44;
                                this.addDexFile(entryName, (Dex)dexBuf);
                                ++index;
                                break;
                            }
                            case ".jar": {
                                ++index;
                                File jarFile = FileUtils.createTempFile(entryName);
                                try (FileOutputStream fos = new FileOutputStream(jarFile);){
                                    IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
                                }
                                this.addDexFile(entryName, InputFile.loadFromJar(jarFile));
                                break;
                            }
                            default: {
                                throw new JadxRuntimeException("Unexpected extension in zip: " + ext);
                            }
                        }
                        continue;
                    }
                    if (!entryName.equals("instant-run.zip") || !ext.equals(".dex")) continue;
                    File jarFile = FileUtils.createTempFile("instant-run.zip");
                    FileOutputStream fos = new FileOutputStream(jarFile);
                    dexBuf = null;
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
                    }
                    catch (Throwable throwable2) {
                        dexBuf = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fos != null) {
                            if (dexBuf != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)dexBuf).addSuppressed(throwable3);
                                }
                            } else {
                                fos.close();
                            }
                        }
                    }
                    InputFile tempFile = new InputFile(jarFile);
                    tempFile.loadFromZip(ext);
                    List<DexFile> dexFiles = tempFile.getDexFiles();
                    if (dexFiles.isEmpty()) continue;
                    index += dexFiles.size();
                    this.dexFiles.addAll(dexFiles);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        return index > 0;
    }

    @Nullable
    private Dex makeDexBuf(String entryName, InputStream inputStream) {
        try {
            return new Dex(inputStream);
        }
        catch (Exception e) {
            LOG.error("Failed to load file: {}, error: {}", new Object[]{entryName, e.getMessage(), e});
            return null;
        }
    }

    private static Dex loadFromJar(File jarFile) throws DecodeException {
        JavaToDex j2d = new JavaToDex();
        try {
            LOG.info("converting to dex: {} ...", (Object)jarFile.getName());
            byte[] ba = j2d.convert(jarFile.getAbsolutePath());
            if (ba.length == 0) {
                throw new JadxException("Empty dx output");
            }
            Dex dex = new Dex(ba);
            return dex;
        }
        catch (Exception e) {
            throw new DecodeException("java class to dex conversion error:\n " + e.getMessage(), e);
        }
        finally {
            if (j2d.isError()) {
                LOG.warn("dx message: {}", (Object)j2d.getDxErrors());
            }
        }
    }

    private static Dex loadFromClassFile(File file) throws IOException, DecodeException {
        File outFile = FileUtils.createTempFile("cls.jar");
        try (JarOutputStream jo = new JarOutputStream(new FileOutputStream(outFile));){
            String clsName = AsmUtils.getNameFromClassFile(file);
            if (clsName == null || !ZipSecurity.isValidZipEntryName(clsName)) {
                throw new IOException("Can't read class name from file: " + file);
            }
            FileUtils.addFileToJar(jo, file, clsName + ".class");
        }
        return InputFile.loadFromJar(outFile);
    }

    public File getFile() {
        return this.file;
    }

    public List<DexFile> getDexFiles() {
        return this.dexFiles;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }
}

