/*
 * Decompiled with CFR 0.152.
 */
package com.projity.association;

import com.projity.association.Association;
import com.projity.association.AssociationList;
import com.projity.configuration.Settings;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Iterator;

public class AssociationListFormat
extends Format {
    Format associationFormat;

    public static AssociationListFormat getInstance(Format format) {
        return new AssociationListFormat(format);
    }

    private AssociationListFormat(Format format) {
        this.associationFormat = format;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        AssociationList associationList = new AssociationList();
        string = string.trim();
        string = string.replace(",", Settings.LIST_SEPARATOR);
        if ((string = string.replace(";", Settings.LIST_SEPARATOR)).length() != 0) {
            String[] stringArray = string.split(Settings.LIST_SEPARATOR);
            for (int i = 0; i < stringArray.length; ++i) {
                Association association = (Association)this.associationFormat.parseObject(stringArray[i], new ParsePosition(0));
                if (association == null) {
                    return null;
                }
                associationList.add(association);
            }
        }
        return associationList;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        AssociationList associationList = (AssociationList)object;
        Iterator iterator = associationList.iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            if (association.isDefault()) continue;
            this.associationFormat.format(association, stringBuffer, fieldPosition);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(Settings.LIST_SEPARATOR);
        }
        return stringBuffer;
    }
}

