/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog.util;

import com.projity.datatype.Hyperlink;
import com.projity.util.BrowserControl;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class LinkLabel
extends JLabel
implements MouseListener {
    Hyperlink hyperlink;
    Cursor oldCursor = null;
    String url = null;

    public LinkLabel(Hyperlink hyperlink) {
        this.addMouseListener(this);
        this.setHyperlink(hyperlink);
    }

    public LinkLabel(ImageIcon imageIcon, String string) {
        super(imageIcon);
        this.url = string;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            BrowserControl.displayURL(this.url == null ? this.hyperlink.getAddress() : this.url);
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.oldCursor = this.getParent().getCursor();
        this.getParent().setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.getParent().setCursor(this.oldCursor);
    }

    public final void setHyperlink(Hyperlink hyperlink) {
        this.hyperlink = hyperlink;
        String string = hyperlink == null ? "" : hyperlink.toString();
        super.setText(string);
    }
}

