/*
 * Decompiled with CFR 0.152.
 */
package com.projity.offline_graphics;

import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.offline_graphics.SVGRenderer;
import com.projity.pm.graphic.gantt.GanttRenderer;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projity.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParamsImpl;
import com.projity.pm.graphic.spreadsheet.SpreadSheetRenderer;
import com.projity.pm.graphic.spreadsheet.renderer.FontManager;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.graphic.timescale.TimeScaleComponent;
import com.projity.pm.task.Project;
import com.projity.print.FooterRenderer;
import com.projity.print.PrintSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import java.util.TreeSet;

public class GanttSVGRenderer
implements SVGRenderer,
Cloneable {
    protected SpreadSheetParamsImpl params;
    protected CoordinatesConverter coord;
    protected GanttRenderer ganttRenderer;
    protected SpreadSheetRenderer spreadSheetRenderer;
    protected FooterRenderer footerRenderer;
    protected Project project;

    @Override
    public void init(Project project, ReferenceNodeModelCache referenceNodeModelCache) {
        SpreadSheetFieldArray spreadSheetFieldArray = null;
        PrintSettings printSettings = project.getPrintSettings(1);
        if (printSettings != null) {
            spreadSheetFieldArray = printSettings.getFieldArray();
        }
        this.init(project, NodeModelCacheFactory.getInstance().createFilteredCache(referenceNodeModelCache, "OfflineGantt", null), spreadSheetFieldArray, null, -1, true);
    }

    public void init(Project project, NodeModelCache nodeModelCache, SpreadSheetFieldArray spreadSheetFieldArray, List<Integer> list, int n, boolean bl) {
        this.project = project;
        this.coord = new CoordinatesConverter(project);
        if (n != -1) {
            this.coord.getTimescaleManager().setCurrentScaleIndex(n);
        }
        this.params = new SpreadSheetParamsImpl(spreadSheetFieldArray, list, bl);
        int n2 = project.getRowHeight(new TreeSet());
        this.params.setRowHeight(n2);
        this.params.setCache(nodeModelCache);
        this.params.setCoord(this.coord);
        this.ganttRenderer = new GanttRenderer(this.params);
        this.spreadSheetRenderer = new SpreadSheetRenderer(this.params);
        this.footerRenderer = new FooterRenderer(this.params);
        nodeModelCache.update();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public SVGRenderer createSafePrintCopy() {
        GanttSVGRenderer ganttSVGRenderer = (GanttSVGRenderer)this.clone();
        ganttSVGRenderer.params = (SpreadSheetParamsImpl)ganttSVGRenderer.params.createSafePrintCopy();
        ganttSVGRenderer.ganttRenderer = new GanttRenderer(ganttSVGRenderer.params);
        ganttSVGRenderer.spreadSheetRenderer = new SpreadSheetRenderer(ganttSVGRenderer.params);
        ganttSVGRenderer.footerRenderer = new FooterRenderer(ganttSVGRenderer.params);
        return ganttSVGRenderer;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.paint(graphics2D, -1, -1);
    }

    @Override
    public void paint(Graphics2D graphics2D, int n, int n2) {
        Rectangle rectangle = this.params.getDrawingBounds();
        int n3 = this.params.getSpreadSheetBounds().width;
        int n4 = 0;
        Rectangle rectangle2 = null;
        Rectangle rectangle3 = null;
        boolean bl = true;
        boolean bl2 = true;
        int n5 = this.params.getConfiguration().getColumnHeaderHeight();
        if (n != -1) {
            rectangle2 = this.params.getSpreadsheetPrintBounds(n, n2, false);
            if (rectangle2 == null || !this.params.isLeftPartVisible()) {
                bl = false;
            }
            if ((rectangle3 = this.params.getGanttPrintBounds(n, n2)) == null) {
                bl2 = false;
            } else {
                n3 = this.params.getGanttDeltaX(n, n2);
                n4 = -rectangle3.y;
            }
        }
        if (bl) {
            this.spreadSheetRenderer.paint(graphics2D, n, n2);
        }
        if (bl2) {
            graphics2D.translate(n3, 0);
            if (rectangle3 != null) {
                graphics2D.setClip(new Rectangle(rectangle3.x, 0, rectangle3.width, n5));
            }
            TimeScaleComponent.paintTimeScale(graphics2D, this.params, FontManager.getOfflineDefaultFont());
            if (rectangle3 != null) {
                graphics2D.setClip(null);
            }
            graphics2D.translate(0, n4 + this.params.getConfiguration().getColumnHeaderHeight());
            if (rectangle3 == null) {
                this.ganttRenderer.paint(graphics2D, null);
            } else {
                this.ganttRenderer.paint(graphics2D, new Rectangle(rectangle3.x, rectangle3.y + 1, rectangle3.width, rectangle3.height - 1));
            }
            graphics2D.translate(-n3, -n4 - this.params.getConfiguration().getColumnHeaderHeight());
        }
        graphics2D.setColor(Color.BLACK);
        if (n == -1) {
            graphics2D.drawRect(0, 0, rectangle.width, rectangle.height);
            graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        } else {
            int n6 = this.params.getConfiguration().getPrintFooterHeight();
            Rectangle rectangle4 = this.params.getPrintBounds();
            int n7 = this.params.getPrintBounds().height - n6;
            int n8 = this.params.getPrintCols();
            if (bl && !bl2) {
                graphics2D.drawRect(0, 0, rectangle2.width, rectangle4.height);
                graphics2D.drawLine(0, n5, rectangle2.width, n5);
                graphics2D.drawLine(0, rectangle2.height + n5, rectangle2.width, rectangle2.height + n5);
                graphics2D.drawLine(0, n7, rectangle2.width, n7);
                this.footerRenderer.paint(graphics2D, n * n8 + n2, new Rectangle(0, n7, rectangle2.width, n6), this.project.getName());
            } else if (!bl && bl2) {
                graphics2D.drawRect(0, 0, rectangle3.width, rectangle4.height);
                graphics2D.drawLine(0, n5, rectangle3.width, n5);
                graphics2D.drawLine(0, rectangle3.height + n5, rectangle3.width, rectangle3.height + n5);
                graphics2D.drawLine(0, n7, rectangle3.width, n7);
                this.footerRenderer.paint(graphics2D, n * n8 + n2, new Rectangle(0, n7, rectangle3.width, n6), this.project.getName());
            } else if (bl && bl2) {
                graphics2D.drawRect(0, 0, rectangle2.width + rectangle3.width, rectangle4.height);
                graphics2D.drawLine(0, n5, rectangle2.width + rectangle3.width, n5);
                graphics2D.drawLine(0, rectangle2.height + n5, rectangle2.width + rectangle3.width, rectangle2.height + n5);
                graphics2D.drawLine(0, n7, rectangle2.width + rectangle3.width, n7);
                this.footerRenderer.paint(graphics2D, n * n8 + n2, new Rectangle(0, n7, rectangle2.width + rectangle3.width, n6), this.project.getName());
            }
        }
    }

    @Override
    public Dimension getCanvasSize() {
        return this.params.getDrawingBounds().getSize();
    }

    @Override
    public GraphParams getParams() {
        return this.params;
    }

    @Override
    public Project getProject() {
        return this.project;
    }
}

