/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.contour;

import com.projity.configuration.Configuration;
import com.projity.pm.assignment.contour.AbstractContour;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import com.projity.pm.assignment.contour.ContourTypes;
import com.projity.pm.assignment.contour.StandardContourBucket;
import com.projity.pm.time.MutableInterval;

public class StandardContour
extends AbstractContour
implements ContourTypes {
    private double meanUnits = 0.0;
    private int type;
    public static final StandardContour FLAT_CONTOUR = StandardContour.getInstance(0, new StandardContourBucket[]{new StandardContourBucket(1.0, 1.0)});
    public static final StandardContour BACK_LOADED_CONTOUR = StandardContour.getInstance(1, new StandardContourBucket[]{new StandardContourBucket(0.1, 0.1), new StandardContourBucket(0.15, 0.1), new StandardContourBucket(0.25, 0.1), new StandardContourBucket(0.5, 0.2), new StandardContourBucket(0.75, 0.2), new StandardContourBucket(1.0, 0.3)});
    public static final StandardContour FRONT_LOADED_CONTOUR = StandardContour.getInstance(2, new StandardContourBucket[]{new StandardContourBucket(1.0, 0.3), new StandardContourBucket(0.75, 0.2), new StandardContourBucket(0.5, 0.2), new StandardContourBucket(0.25, 0.1), new StandardContourBucket(0.15, 0.1), new StandardContourBucket(0.1, 0.1)});
    public static final StandardContour DOUBLE_PEAK_CONTOUR = StandardContour.getInstance(3, new StandardContourBucket[]{new StandardContourBucket(0.25, 0.1), new StandardContourBucket(0.5, 0.1), new StandardContourBucket(1.0, 0.1), new StandardContourBucket(0.5, 0.1), new StandardContourBucket(0.25, 0.2), new StandardContourBucket(0.5, 0.1), new StandardContourBucket(1.0, 0.1), new StandardContourBucket(0.5, 0.1), new StandardContourBucket(0.25, 0.1)});
    public static final StandardContour EARLY_PEAK_CONTOUR = StandardContour.getInstance(4, new StandardContourBucket[]{new StandardContourBucket(0.25, 0.1), new StandardContourBucket(0.5, 0.1), new StandardContourBucket(1.0, 0.2), new StandardContourBucket(0.75, 0.1), new StandardContourBucket(0.5, 0.2), new StandardContourBucket(0.25, 0.1), new StandardContourBucket(0.15, 0.1), new StandardContourBucket(0.1, 0.1)});
    public static final StandardContour LATE_PEAK_CONTOUR = StandardContour.getInstance(5, new StandardContourBucket[]{new StandardContourBucket(0.1, 0.1), new StandardContourBucket(0.15, 0.1), new StandardContourBucket(0.25, 0.1), new StandardContourBucket(0.5, 0.2), new StandardContourBucket(0.75, 0.1), new StandardContourBucket(1.0, 0.2), new StandardContourBucket(0.5, 0.1), new StandardContourBucket(0.25, 0.1)});
    public static final StandardContour BELL_CONTOUR = StandardContour.getInstance(6, new StandardContourBucket[]{new StandardContourBucket(0.1, 0.1), new StandardContourBucket(0.2, 0.1), new StandardContourBucket(0.4, 0.1), new StandardContourBucket(0.8, 0.1), new StandardContourBucket(1.0, 0.2), new StandardContourBucket(0.8, 0.1), new StandardContourBucket(0.4, 0.1), new StandardContourBucket(0.2, 0.1), new StandardContourBucket(0.1, 0.1)});
    public static final StandardContour PLATEAU_CONTOUR = StandardContour.getInstance(7, new StandardContourBucket[]{new StandardContourBucket(0.25, 0.1), new StandardContourBucket(0.5, 0.1), new StandardContourBucket(0.75, 0.1), new StandardContourBucket(1.0, 0.4), new StandardContourBucket(0.75, 0.1), new StandardContourBucket(0.5, 0.1), new StandardContourBucket(0.25, 0.1)});

    public static StandardContour getInstance(int n, AbstractContourBucket[] abstractContourBucketArray) {
        return new StandardContour(n, abstractContourBucketArray);
    }

    @Override
    public boolean isPersonal() {
        return false;
    }

    public double getMeanUnits() {
        return this.meanUnits;
    }

    @Override
    public String getName() {
        return Configuration.getInstance().getFieldDictionary().getFieldFromId("Field.workContour").convertIdToString(new Integer(this.type));
    }

    @Override
    public long calcTotalWork(long l) {
        return (long)(this.meanUnits * (double)l);
    }

    private StandardContour(int n, AbstractContourBucket[] abstractContourBucketArray) {
        super(abstractContourBucketArray);
        this.type = n;
        this.meanUnits = this.calcWeightedSum();
    }

    private double calcWeightedSum() {
        double d = 0.0;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            d += this.contourBuckets[i].weightedSum();
        }
        return d;
    }

    public static StandardContour getStandardContour(int n) {
        switch (n) {
            case 0: {
                return FLAT_CONTOUR;
            }
            case 1: {
                return BACK_LOADED_CONTOUR;
            }
            case 2: {
                return FRONT_LOADED_CONTOUR;
            }
            case 3: {
                return DOUBLE_PEAK_CONTOUR;
            }
            case 4: {
                return EARLY_PEAK_CONTOUR;
            }
            case 5: {
                return LATE_PEAK_CONTOUR;
            }
            case 6: {
                return BELL_CONTOUR;
            }
            case 7: {
                return PLATEAU_CONTOUR;
            }
        }
        return null;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public AbstractContour extend(long l, long l2) {
        return this;
    }

    @Override
    public AbstractContour extendBefore(long l, long l2) {
        return this;
    }

    @Override
    public MutableInterval getRangeThatIntervalCanBeMoved(long l, long l2) {
        return new MutableInterval(l, Long.MAX_VALUE);
    }
}

