/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.functor;

import com.projity.algorithm.CalculationVisitor;
import com.projity.pm.assignment.functor.AssignmentFieldClosureCollection;
import com.projity.pm.assignment.functor.AssignmentFieldFunctor;
import com.projity.pm.time.HasStartAndEnd;

public class DateAtValueFunctor
implements CalculationVisitor {
    AssignmentFieldClosureCollection childList;
    double subtotal;
    double value;
    long date;

    public static DateAtValueFunctor getInstance(double d, AssignmentFieldClosureCollection assignmentFieldClosureCollection) {
        return new DateAtValueFunctor(d, assignmentFieldClosureCollection);
    }

    private DateAtValueFunctor(double d, AssignmentFieldClosureCollection assignmentFieldClosureCollection) {
        this.reset();
        this.value = d;
        this.childList = assignmentFieldClosureCollection;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void reset() {
        this.subtotal = 0.0;
        this.value = 0.0;
        this.date = 0L;
    }

    @Override
    public void execute(Object object) {
        HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)object;
        double d = this.childList.getValue();
        this.subtotal += d;
        if (this.date == 0L && this.subtotal >= this.value) {
            if (this.value == 0.0) {
                this.date = hasStartAndEnd.getStart();
                return;
            }
            if (hasStartAndEnd.getStart() == hasStartAndEnd.getEnd()) {
                this.date = hasStartAndEnd.getStart();
                return;
            }
            double d2 = this.childList.getFixedValue();
            if (this.subtotal + d2 - d >= this.value) {
                this.date = hasStartAndEnd.getStart();
                return;
            }
            double d3 = ((d -= d2) - (this.subtotal - this.value)) / d;
            AssignmentFieldFunctor assignmentFieldFunctor = this.childList.getANonZeroFunctor();
            long l = assignmentFieldFunctor.getWorkCalendar().compare(hasStartAndEnd.getEnd(), hasStartAndEnd.getStart(), false);
            this.date = assignmentFieldFunctor.getWorkCalendar().add(hasStartAndEnd.getStart(), (long)((double)l * d3), true);
        }
    }

    public long getDate() {
        return this.date;
    }

    @Override
    public boolean isCumulative() {
        return false;
    }
}

