/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.common;

import com.projity.field.Field;
import com.projity.field.FieldContext;
import com.projity.graphic.configuration.ActionList;
import com.projity.graphic.configuration.CellFormat;
import com.projity.graphic.configuration.CellStyle;
import com.projity.grouping.core.Node;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.graphic.model.cache.CacheInterval;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.event.CacheEvent;
import com.projity.pm.graphic.model.event.CacheListener;
import com.projity.pm.graphic.model.event.CompositeCacheEvent;
import com.projity.pm.graphic.spreadsheet.SpreadSheetColumnModel;
import com.projity.pm.graphic.spreadsheet.SpreadSheetUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections.Closure;

public class CommonSpreadSheetModel
extends AbstractTableModel
implements CacheListener {
    protected NodeModelCache cache = null;
    protected FieldContext fieldContext = null;
    protected CellStyle cellStyle;
    protected ActionList actionList;
    protected SpreadSheetColumnModel colModel;
    protected CacheListener cacheListener = null;
    private String[] actions = null;

    public CommonSpreadSheetModel(NodeModelCache nodeModelCache, SpreadSheetColumnModel spreadSheetColumnModel, CellStyle cellStyle, ActionList actionList) {
        this.colModel = spreadSheetColumnModel;
        this.cellStyle = cellStyle;
        this.actionList = actionList;
        this.setCache(nodeModelCache);
    }

    public void setCache(NodeModelCache nodeModelCache) {
        if (nodeModelCache == this.cache) {
            return;
        }
        if (this.cache != null) {
            this.cache.removeNodeModelListener(this);
        }
        this.cache = nodeModelCache;
        nodeModelCache.addNodeModelListener(this);
        this.fireTableDataChanged();
    }

    @Override
    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        for (final CacheEvent cacheEvent : compositeCacheEvent.getNodeEvents()) {
            cacheEvent.forIntervals(new Closure(){

                @Override
                public void execute(Object object) {
                    CacheInterval cacheInterval = (CacheInterval)object;
                    if (cacheEvent.getType() == 0) {
                        CommonSpreadSheetModel.this.fireTableRowsUpdated(cacheInterval.getStart(), cacheInterval.getEnd());
                    } else if (cacheEvent.getType() == 1) {
                        CommonSpreadSheetModel.this.fireTableRowsInserted(cacheInterval.getStart(), cacheInterval.getEnd());
                    } else if (cacheEvent.getType() == 2) {
                        CommonSpreadSheetModel.this.fireTableRowsDeleted(cacheInterval.getStart(), cacheInterval.getEnd());
                    }
                }
            });
        }
    }

    public ArrayList getFieldArray() {
        return this.colModel.getFieldArray();
    }

    public void setFieldArray(ArrayList arrayList) {
        this.colModel.setFieldArray(arrayList);
    }

    public NodeModelCache getCache() {
        return this.cache;
    }

    public Field getFieldInColumn(int n) {
        return null;
    }

    @Override
    public String getColumnName(int n) {
        return "" + n;
    }

    public int getRowMultiple() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.getCache().getSize() * this.getRowMultiple();
    }

    public GraphicNode getNode(int n) {
        return this.getNodeFromCacheRow(n);
    }

    public void changeCollapsedState(int n) {
        this.getCache().changeCollapsedState((GraphicNode)this.getCache().getElementAt(n));
    }

    public CellFormat getCellProperties(GraphicNode graphicNode) {
        return this.cellStyle.getCellFormat(graphicNode);
    }

    public String[] getActionList() {
        if (this.actions == null) {
            this.actions = CommonSpreadSheetModel.convertActions(this.actionList.getList(this.getCache().getModel()));
        }
        return this.actions;
    }

    public void clearActions() {
        this.actions = null;
    }

    public static String[] convertActions(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;:|");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    protected Node getNodeInRow(int n) {
        return SpreadSheetUtils.getNodeInRow(n, this.getRowMultiple(), this.cache);
    }

    public LinkedList getPreviousVisibleNodesFromRow(int n) {
        LinkedList<Node> linkedList = null;
        for (int i = n - 1; i >= 0; --i) {
            Node node = this.getNodeInRow(i);
            if (node.getImpl() instanceof Assignment) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<Node>();
            }
            linkedList.addFirst(node);
            if (node.isVoid()) continue;
            return linkedList;
        }
        return null;
    }

    protected Node getNextNonVoidSiblingFromRow(int n) {
        int n2 = this.getRowCount();
        Node node = this.getNodeInRow(n);
        TreeNode treeNode = node.getParent();
        for (int i = n + 1; i < n2; ++i) {
            Node node2 = this.getNodeInRow(i);
            if (node2.getImpl() instanceof Assignment) continue;
            if (node2.getParent() != treeNode) break;
            if (node2.isVoid()) continue;
            return node2;
        }
        return null;
    }

    private GraphicNode getNodeFromCacheRow(int n) {
        return SpreadSheetUtils.getNodeFromCacheRow(n, this.getRowMultiple(), this.cache);
    }

    protected int findNodeRow(Node node, int n) {
        for (int i = 0; i < n; ++i) {
            if (this.getNodeInRow(i) != node) continue;
            return i;
        }
        return -1;
    }

    public int findGraphicNodeRow(Object object) {
        int n = this.getCache().getRowAt(object);
        if (n == -1) {
            return -1;
        }
        return n * this.getRowMultiple();
    }

    public Object getObjectInRow(int n) {
        if (n == -1) {
            return null;
        }
        GraphicNode graphicNode = this.getNodeFromCacheRow(n);
        if (graphicNode == null) {
            return null;
        }
        return graphicNode.getNode().getImpl();
    }

    int findObjectRow(Object object) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getObjectInRow(i) != object) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        return -1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return null;
    }

    public Class getColumnClass(int n) {
        return this.getFieldInColumn(n).getDisplayType();
    }

    public void fireUpdateAll() {
        this.fireTableDataChanged();
    }

    private Node objectToNode(Object object) {
        return this.getCache().getWalkersModel().search(object);
    }

    public void setFieldContext(FieldContext fieldContext) {
        this.fieldContext = fieldContext;
    }

    public FieldContext getFieldContext() {
        return this.fieldContext;
    }

    public boolean isRowEditable(int n) {
        return true;
    }
}

