/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.timescale;

import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.scheduling.ScheduleEvent;
import com.projity.pm.scheduling.ScheduleEventListener;
import com.projity.pm.scheduling.ScheduleInterval;
import com.projity.pm.task.Project;
import com.projity.timescale.TimeInterval;
import com.projity.timescale.TimeIterator;
import com.projity.timescale.TimeScaleEvent;
import com.projity.timescale.TimeScaleListener;
import com.projity.timescale.TimeScaleManager;
import com.projity.util.DateTime;
import com.projity.workspace.SavableToWorkspace;
import com.projity.workspace.WorkspaceSetting;
import java.io.Serializable;
import java.util.Calendar;
import java.util.EventListener;
import java.util.GregorianCalendar;
import javax.swing.event.EventListenerList;

public class CoordinatesConverter
implements ScheduleEventListener,
Serializable,
SavableToWorkspace {
    private static final long serialVersionUID = 3657308109433257760L;
    protected TimeScaleManager timescaleManager;
    protected long origin;
    protected long end;
    protected Project project;
    protected EventListenerList listenerList = new EventListenerList();

    public CoordinatesConverter(Project project) {
        this(project, TimeScaleManager.createInstance());
    }

    public CoordinatesConverter(Project project, TimeScaleManager timeScaleManager) {
        this.project = project;
        this.timescaleManager = timeScaleManager;
        this.updateLargeInterval(false);
        project.addScheduleListener(this);
    }

    public long getOrigin() {
        return this.origin;
    }

    public long getEnd() {
        return this.end;
    }

    protected void adaptOrigin(Calendar calendar, boolean bl) {
        this.getTimescaleManager().getScale().floor1(calendar, -1L);
        long l = calendar.getTimeInMillis();
        if (this.origin != l) {
            this.origin = l;
            if (bl) {
                this.fireTimeScaleChanged(this, 1);
            }
        }
    }

    protected void adaptEnd(Calendar calendar, boolean bl) {
        this.getTimescaleManager().getScale().ceil1(calendar, -1L);
        long l = calendar.getTimeInMillis();
        if (this.end != l) {
            this.end = l;
            if (bl) {
                this.fireTimeScaleChanged(this, 2);
            }
        }
    }

    protected void adaptInterval(Calendar calendar, Calendar calendar2, boolean bl) {
        int n = 0;
        long l = this.end;
        this.adaptEnd(calendar2, false);
        if (this.end != l) {
            n = 2;
        }
        l = this.origin;
        this.adaptOrigin(calendar, false);
        if (this.origin != l) {
            n = 1;
        }
        if (n > 0 && bl) {
            this.fireTimeScaleChanged(this, n);
        }
    }

    private long getProjectStart() {
        long l = this.project.getEarliestStartingTaskOrStart();
        return l == 0L ? System.currentTimeMillis() : l;
    }

    private long getProjectEnd() {
        return this.project.getLatestFinishingTask();
    }

    private Calendar getLargeStart() {
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(this.getProjectStart());
        ((Calendar)gregorianCalendar).add(5, -3);
        return gregorianCalendar;
    }

    private Calendar getLargeEnd() {
        long l = this.getProjectEnd();
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(this.getProjectEnd());
        ((Calendar)gregorianCalendar).add(5, 30);
        return gregorianCalendar;
    }

    protected void updateLargeInterval(boolean bl) {
        this.adaptInterval(this.getLargeStart(), this.getLargeEnd(), bl);
    }

    public void toggleMinWidth(boolean bl) {
        if (this.timescaleManager.toggleMinWidth(bl)) {
            this.fireTimeScaleChanged(this, 4);
        }
    }

    public boolean canZoomIn() {
        return this.timescaleManager.canZoomIn();
    }

    public boolean canZoomOut() {
        return this.timescaleManager.canZoomOut();
    }

    public void zoomIn() {
        if (this.timescaleManager.zoomIn()) {
            this.updateLargeInterval(false);
            this.fireTimeScaleChanged(this, 4);
        }
    }

    public void zoomOut() {
        if (this.timescaleManager.zoomOut()) {
            this.updateLargeInterval(false);
            this.fireTimeScaleChanged(this, 4);
        }
    }

    public void zoomReset() {
        if (this.timescaleManager.zoomReset()) {
            this.updateLargeInterval(false);
            this.fireTimeScaleChanged(this, 4);
        }
    }

    public long getIntervalDuration() {
        return this.getTimescaleManager().getScale().getIntervalDuration();
    }

    public TimeScaleManager getTimescaleManager() {
        return this.timescaleManager;
    }

    public void setTimescaleManager(TimeScaleManager timeScaleManager) {
        this.timescaleManager = timeScaleManager;
    }

    public double toTime(double d) {
        return (double)this.getOrigin() + this.timescaleManager.getScale().toTime(d);
    }

    public double toDuration(double d) {
        return this.timescaleManager.getScale().toTime(d);
    }

    public double toX(double d) {
        return this.timescaleManager.getScale().toX(d - (double)this.getOrigin());
    }

    public double toW(double d) {
        return this.timescaleManager.getScale().toX(d);
    }

    public double getWidth() {
        return this.toW(this.getEnd() - this.getOrigin());
    }

    public TimeIterator getTimeIterator(double d, double d2) {
        return new TimeIterator(this.toTime(d), this.toTime(d2), this.timescaleManager.getScale(), this.getOrigin());
    }

    public TimeIterator getTimeIterator(double d, double d2, boolean bl) {
        return new TimeIterator(this.toTime(d), this.toTime(d2), this.timescaleManager.getScale(), this.getOrigin(), bl);
    }

    public TimeIterator getProjectTimeIterator() {
        return new TimeIterator(this.getOrigin(), this.getEnd(), this.timescaleManager.getScale(), this.getOrigin());
    }

    public int countProjectIntervals() {
        int n = 0;
        TimeIterator timeIterator = this.getProjectTimeIterator();
        while (timeIterator.hasNext()) {
            TimeInterval timeInterval = timeIterator.next();
            ++n;
        }
        return n;
    }

    @Override
    public void scheduleChanged(ScheduleEvent scheduleEvent) {
        this.updateLargeInterval(true);
    }

    public void addTimeScaleListener(TimeScaleListener timeScaleListener) {
        this.listenerList.add(TimeScaleListener.class, timeScaleListener);
    }

    public void removeTimeScaleListener(TimeScaleListener timeScaleListener) {
        this.listenerList.remove(TimeScaleListener.class, timeScaleListener);
    }

    public TimeScaleListener[] getTimeScaleListeners() {
        return (TimeScaleListener[])this.listenerList.getListeners(TimeScaleListener.class);
    }

    protected void fireTimeScaleChanged(Object object, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        TimeScaleEvent timeScaleEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TimeScaleListener.class) continue;
            if (timeScaleEvent == null) {
                timeScaleEvent = new TimeScaleEvent(object, n);
            }
            ((TimeScaleListener)objectArray[i + 1]).timeScaleChanged(timeScaleEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.timescaleManager.setCurrentScaleIndex(workspace.currentScaleIndex);
        this.origin = workspace.origin;
        this.end = workspace.end;
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.currentScaleIndex = this.timescaleManager.getCurrentScaleIndex();
        workspace.origin = this.origin;
        workspace.end = this.end;
        return workspace;
    }

    public Project getProject() {
        return this.project;
    }

    public static double adaptSmallBarEndX(double d, double d2, GraphicNode graphicNode, GraphicConfiguration graphicConfiguration) {
        if (graphicConfiguration == null) {
            graphicConfiguration = GraphicConfiguration.getInstance();
        }
        if (graphicConfiguration.getGanttBarMinWidth() == 0 || graphicNode == null || graphicNode.getIntervalCount() > 1) {
            return d2;
        }
        if (d < d2 && d2 - d < (double)graphicConfiguration.getGanttBarMinWidth() && graphicConfiguration.getGanttBarMinWidth() > 0) {
            return d + (double)graphicConfiguration.getGanttBarMinWidth();
        }
        return d2;
    }

    public ScheduleInterval adaptSmallBarTimeInterval(ScheduleInterval scheduleInterval, GraphicNode graphicNode, GraphicConfiguration graphicConfiguration) {
        if (graphicConfiguration == null) {
            graphicConfiguration = GraphicConfiguration.getInstance();
        }
        if (graphicConfiguration.getGanttBarMinWidth() == 0 || graphicNode == null || graphicNode.getIntervalCount() > 1) {
            return scheduleInterval;
        }
        if (graphicConfiguration.getGanttBarMinWidth() > 0) {
            double d = this.timescaleManager.getScale().toTime(graphicConfiguration.getGanttBarMinWidth());
            if (scheduleInterval.getStart() != scheduleInterval.getEnd() && (double)(scheduleInterval.getEnd() - scheduleInterval.getStart()) < d) {
                return new ScheduleInterval(scheduleInterval.getStart(), scheduleInterval.getStart() + (long)d);
            }
        }
        return scheduleInterval;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -6767009284584575457L;
        int currentScaleIndex;
        long origin;
        long end;

        public final int getCurrentScaleIndex() {
            return this.currentScaleIndex;
        }

        public final void setCurrentScaleIndex(int n) {
            this.currentScaleIndex = n;
        }

        public final long getEnd() {
            return this.end;
        }

        public final void setEnd(long l) {
            this.end = l;
        }

        public final long getOrigin() {
            return this.origin;
        }

        public final void setOrigin(long l) {
            this.origin = l;
        }
    }
}

