/*
 * Decompiled with CFR 0.152.
 */
package org.projectlibre.export;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.projity.job.Job;
import com.projity.job.JobQueue;
import com.projity.job.JobRunnable;
import com.projity.print.ExtendedPageFormat;
import com.projity.print.GraphPageable;
import com.projity.print.ViewPrintable;
import com.projity.session.SessionFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ImageExport {
    private static JFileChooser chooser = null;
    private static FileFilter pdfFilter = null;
    private static FileFilter pngFilter = null;

    public static void export(final GraphPageable graphPageable, Component component) throws IOException {
        final File file = ImageExport.chooseFile(graphPageable.getRenderer().getProject().getName(), component);
        JobQueue jobQueue = SessionFactory.getInstance().getJobQueue();
        Job job = new Job(jobQueue, "Image Export", "Exporting Image...", true, component);
        job.addRunnable(new JobRunnable("Image Export", 1.0f){

            @Override
            public Object run() throws Exception {
                boolean bl = true;
                if (file.getName().endsWith(".png")) {
                    bl = false;
                }
                Document document = null;
                PdfWriter pdfWriter = null;
                if (bl) {
                    document = new Document();
                    pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file));
                }
                graphPageable.update();
                int n = graphPageable.getNumberOfPages();
                if (n > 0) {
                    ViewPrintable viewPrintable = graphPageable.getSafePrintable();
                    ExtendedPageFormat extendedPageFormat = graphPageable.getSafePageFormat();
                    double d = extendedPageFormat.getWidth();
                    double d2 = extendedPageFormat.getHeight();
                    float f = 0.1f;
                    float f2 = 0.0f;
                    float f3 = (1.0f - f - f2) / (float)n;
                    for (int i = 0; i < n; ++i) {
                        Object object;
                        this.setProgress(f + (float)i * f3);
                        if (bl) {
                            document.setPageSize(new Rectangle((float)d, (float)d2));
                            if (i == 0) {
                                document.open();
                            } else {
                                document.newPage();
                            }
                        } else {
                            object = new BufferedImage((int)d, (int)d2, 2);
                            Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
                            graphics2D.setBackground(Color.WHITE);
                            viewPrintable.print(graphics2D, i);
                            graphics2D.dispose();
                            ImageIO.write((RenderedImage)object, "png", new FileOutputStream(file));
                            break;
                        }
                        object = pdfWriter.getDirectContent().createGraphics((float)d, (float)d2);
                        viewPrintable.print((Graphics)object, i);
                        ((Graphics)object).dispose();
                    }
                    if (bl) {
                        document.close();
                    }
                }
                this.setProgress(1.0f);
                return null;
            }
        });
        jobQueue.schedule(job);
    }

    private static File chooseFile(String string, Component component) {
        if (chooser == null) {
            pdfFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
                }

                @Override
                public String getDescription() {
                    return "PDF (*.pdf)";
                }
            };
            pngFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return "PNG (*.png)";
                }
            };
            chooser = new JFileChooser();
            chooser.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
            chooser.setDialogType(1);
            chooser.addChoosableFileFilter(pdfFilter);
        }
        if (string.length() == 0) {
            string = "project";
        }
        chooser.setSelectedFile(new File(string + ".pdf"));
        chooser.setFileFilter(pdfFilter);
        if (chooser.showDialog(component, null) == 0) {
            File file = chooser.getSelectedFile();
            if (!file.getName().endsWith(".pdf")) {
                file = new File(file.getName() + ".pdf");
            }
            return file;
        }
        return null;
    }
}

