/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class MapInputDataDiffBuilder<Key, Value>
extends InputDataDiffBuilder<Key, Value> {
    private static final boolean ourDiffUpdateEnabled = SystemProperties.getBooleanProperty("idea.disable.diff.index.update", true);
    private final Map<Key, Value> myMap;
    private static final AtomicInteger requests = new AtomicInteger();
    private static final AtomicInteger totalRemovals = new AtomicInteger();
    private static final AtomicInteger totalAdditions = new AtomicInteger();
    private static final AtomicInteger incrementalRemovals = new AtomicInteger();
    private static final AtomicInteger incrementalAdditions = new AtomicInteger();
    private static final AtomicInteger noopModifications = new AtomicInteger();

    public MapInputDataDiffBuilder(int inputId, @Nullable Map<Key, Value> map) {
        super(inputId);
        this.myMap = map == null ? Collections.emptyMap() : map;
    }

    @Override
    public boolean differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<Key, Value> addProcessor, @NotNull KeyValueUpdateProcessor<Key, Value> updateProcessor, @NotNull RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        if (newData == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(0);
        }
        if (addProcessor == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(1);
        }
        if (updateProcessor == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(2);
        }
        if (removeProcessor == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(3);
        }
        if (ourDiffUpdateEnabled) {
            if (this.myMap.isEmpty()) {
                EmptyInputDataDiffBuilder.processKeys(newData, addProcessor, this.myInputId);
            } else if (newData.isEmpty()) {
                this.processAllKeysAsDeleted(removeProcessor);
            } else {
                Key key;
                int added = 0;
                int removed = 0;
                for (Map.Entry<Key, Value> e : this.myMap.entrySet()) {
                    key = e.getKey();
                    Value newValue = newData.get(key);
                    if (Comparing.equal(e.getValue(), newValue) && (newValue != null || newData.containsKey(key))) continue;
                    if (!newData.containsKey(key)) {
                        removeProcessor.process(key, this.myInputId);
                        ++removed;
                        continue;
                    }
                    updateProcessor.process(key, newValue, this.myInputId);
                    ++added;
                    ++removed;
                }
                for (Map.Entry<Key, Value> e : newData.entrySet()) {
                    key = e.getKey();
                    if (this.myMap.containsKey(key)) continue;
                    addProcessor.process(key, e.getValue(), this.myInputId);
                    ++added;
                }
                incrementalAdditions.addAndGet(added);
                incrementalRemovals.addAndGet(removed);
                int totalRequests = requests.incrementAndGet();
                totalRemovals.addAndGet(this.myMap.size());
                totalAdditions.addAndGet(newData.size());
                if ((totalRequests & 0xFFFF) == 0 && DebugAssertions.DEBUG) {
                    Logger.getInstance(this.getClass()).info("Incremental index diff update:" + requests + ", removals:" + totalRemovals + "->" + incrementalRemovals + ", additions:" + totalAdditions + "->" + incrementalAdditions + ", no op changes:" + noopModifications);
                }
                if (added == 0 && removed == 0) {
                    noopModifications.incrementAndGet();
                    return false;
                }
            }
        } else {
            CollectionInputDataDiffBuilder.differentiateWithKeySeq(this.myMap.keySet(), newData, this.myInputId, addProcessor, removeProcessor);
        }
        return true;
    }

    private void processAllKeysAsDeleted(final RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        if (this.myMap instanceof THashMap) {
            final StorageException[] exception = new StorageException[]{null};
            ((THashMap)this.myMap).forEachEntry(new TObjectObjectProcedure<Key, Value>(){

                public boolean execute(Key k, Value v) {
                    try {
                        removeProcessor.process(k, MapInputDataDiffBuilder.this.myInputId);
                    }
                    catch (StorageException e) {
                        exception[0] = e;
                        return false;
                    }
                    return true;
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        } else {
            for (Key key : this.myMap.keySet()) {
                removeProcessor.process(key, this.myInputId);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "newData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "addProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "updateProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "removeProcessor";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/indexing/impl/MapInputDataDiffBuilder";
        objectArray[2] = "differentiate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

