/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.LifeStages;
import com.intellij.cvsSupport2.connections.ssh.SshLogger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.Consumer;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.io.IStreamLogger;

public class SshSessionConnection
implements IConnection {
    private volatile long myTs;
    private final String myRepository;
    private final Consumer<SshSessionConnection> myCloseListener;
    private final ThrowableComputable<Session, AuthenticationException> mySessionProvider;
    private volatile LifeStages myState;
    private Session mySession;
    private InputStream myInputStream;
    private OutputStream myOutputStream;
    private final Runnable myActivityMonitor;
    private StreamGobbler myErrorStreamGobbler;

    public SshSessionConnection(String repository, Consumer<SshSessionConnection> closeListener, ThrowableComputable<Session, AuthenticationException> sessionProvider) {
        this.myRepository = repository;
        this.myCloseListener = closeListener;
        this.mySessionProvider = sessionProvider;
        this.myTs = System.currentTimeMillis();
        this.myActivityMonitor = () -> {
            this.myTs = System.currentTimeMillis();
        };
        this.myState = LifeStages.NOT_EXIST;
    }

    public InputStream getInputStream() {
        return this.myInputStream;
    }

    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    public String getRepository() {
        return this.myRepository;
    }

    public void verify(IStreamLogger streamLogger) {
    }

    public void open(IStreamLogger streamLogger) throws AuthenticationException {
        SshLogger.debug("opening session");
        this.mySession = (Session)this.mySessionProvider.compute();
        this.myInputStream = new MyInputStreamWrapper(this.myActivityMonitor, this.mySession.getStdout());
        this.myOutputStream = new MyOutputStreamWrapper(this.myActivityMonitor, this.mySession.getStdin());
        this.myErrorStreamGobbler = new StreamGobbler(this.mySession.getStderr());
        this.myState = LifeStages.CREATED;
    }

    public void close() {
        block11: {
            this.myState = LifeStages.CLOSING;
            SshLogger.debug("session set to closing; closing streams...");
            try {
                if (this.myInputStream != null) {
                    try {
                        this.myInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.myOutputStream != null) {
                    try {
                        this.myOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.myErrorStreamGobbler == null) break block11;
                try {
                    this.myErrorStreamGobbler.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                SshLogger.debug("session itself to be closed");
                this.mySession.close();
                this.mySession.waitForCondition(2, 0L);
            }
            finally {
                SshLogger.debug("session closed, notifying connection");
                this.myCloseListener.consume((Object)this);
                this.myState = LifeStages.CLOSED;
            }
        }
    }

    public long getTs() {
        return this.myTs;
    }

    public LifeStages getState() {
        return this.myState;
    }

    private static class MyOutputStreamWrapper
    extends OutputStream {
        private final Runnable myListener;
        private final OutputStream myDelegate;

        private MyOutputStreamWrapper(Runnable listener, OutputStream delegate) {
            this.myListener = listener;
            this.myDelegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.myListener.run();
            this.myDelegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.myListener.run();
            this.myDelegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.myListener.run();
            this.myDelegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.myDelegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.myDelegate.close();
        }
    }

    private static class MyInputStreamWrapper
    extends InputStream {
        private final Runnable myListener;
        private final InputStream myDelegate;

        private MyInputStreamWrapper(Runnable listener, InputStream delegate) {
            this.myListener = listener;
            this.myDelegate = delegate;
        }

        @Override
        public int read() throws IOException {
            this.myListener.run();
            return this.myDelegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.myListener.run();
            return this.myDelegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.myListener.run();
            return this.myDelegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.myDelegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.myDelegate.available();
        }

        @Override
        public void close() throws IOException {
            this.myDelegate.close();
        }

        @Override
        public void mark(int readlimit) {
            this.myDelegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.myDelegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.myDelegate.markSupported();
        }
    }
}

