/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.swing;

import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.IdentityHashMap;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.swing.SwingContainerWrapper;

public class SwingComponentWrapper
implements ComponentWrapper {
    private static boolean maxSet = false;
    private static boolean vp = true;
    private static final Color DB_COMP_OUTLINE = new Color(0, 0, 200);
    private static final String VISUAL_PADDING_PROPERTY = PlatformDefaults.VISUAL_PADDING_PROPERTY;
    private final Component c;
    private int compType = -1;
    private Boolean bl = null;
    private boolean prefCalled = false;
    private static final IdentityHashMap<FontMetrics, Point2D.Float> FM_MAP = new IdentityHashMap(4);
    private static final Font SUBST_FONT = new Font("sansserif", 0, 11);
    private static boolean isJava9orLater;

    public SwingComponentWrapper(Component component) {
        this.c = component;
    }

    public final int getBaseline(int n, int n2) {
        int[] nArray;
        int n3 = this.c.getBaseline(n < 0 ? this.c.getWidth() : n, n2 < 0 ? this.c.getHeight() : n2);
        if (n3 != -1 && (nArray = this.getVisualPadding()) != null) {
            n3 += (nArray[2] - nArray[0] + 1) / 2;
        }
        return n3;
    }

    public final Object getComponent() {
        return this.c;
    }

    public final float getPixelUnitFactor(boolean bl) {
        switch (PlatformDefaults.getLogicalPixelBase()) {
            case 100: {
                Font font = this.c.getFont();
                FontMetrics fontMetrics = this.c.getFontMetrics(font != null ? font : SUBST_FONT);
                Point2D.Float float_ = FM_MAP.get(fontMetrics);
                if (float_ == null) {
                    Rectangle2D rectangle2D = fontMetrics.getStringBounds("X", this.c.getGraphics());
                    float_ = new Point2D.Float((float)rectangle2D.getWidth() / 6.0f, (float)rectangle2D.getHeight() / 13.277344f);
                    FM_MAP.put(fontMetrics, float_);
                }
                return bl ? float_.x : float_.y;
            }
            case 101: {
                float f;
                Float f2 = bl ? PlatformDefaults.getHorizontalScaleFactor() : PlatformDefaults.getVerticalScaleFactor();
                float f3 = f = f2 != null ? f2.floatValue() : 1.0f;
                float f4 = isJava9orLater ? 1.0f : (float)(bl ? this.getHorizontalScreenDPI() : this.getVerticalScreenDPI()) / (float)PlatformDefaults.getDefaultDPI();
                return f * f4;
            }
        }
        return 1.0f;
    }

    public final int getX() {
        return this.c.getX();
    }

    public final int getY() {
        return this.c.getY();
    }

    public final int getHeight() {
        return this.c.getHeight();
    }

    public final int getWidth() {
        return this.c.getWidth();
    }

    public final int getScreenLocationX() {
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, this.c);
        return point.x;
    }

    public final int getScreenLocationY() {
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, this.c);
        return point.y;
    }

    public final int getMinimumHeight(int n) {
        if (!this.prefCalled) {
            this.c.getPreferredSize();
            this.prefCalled = true;
        }
        return this.c.getMinimumSize().height;
    }

    public final int getMinimumWidth(int n) {
        if (!this.prefCalled) {
            this.c.getPreferredSize();
            this.prefCalled = true;
        }
        return this.c.getMinimumSize().width;
    }

    public final int getPreferredHeight(int n) {
        if (this.c.getWidth() == 0 && this.c.getHeight() == 0 && n != -1) {
            this.c.setBounds(this.c.getX(), this.c.getY(), n, 1);
        }
        return this.c.getPreferredSize().height;
    }

    public final int getPreferredWidth(int n) {
        if (this.c.getWidth() == 0 && this.c.getHeight() == 0 && n != -1) {
            this.c.setBounds(this.c.getX(), this.c.getY(), 1, n);
        }
        return this.c.getPreferredSize().width;
    }

    public final int getMaximumHeight(int n) {
        if (!this.isMaxSet(this.c)) {
            return Integer.MAX_VALUE;
        }
        return this.c.getMaximumSize().height;
    }

    public final int getMaximumWidth(int n) {
        if (!this.isMaxSet(this.c)) {
            return Integer.MAX_VALUE;
        }
        return this.c.getMaximumSize().width;
    }

    private boolean isMaxSet(Component component) {
        return component.isMaximumSizeSet();
    }

    public final ContainerWrapper getParent() {
        Container container = this.c.getParent();
        return container != null ? new SwingContainerWrapper(container) : null;
    }

    public final int getHorizontalScreenDPI() {
        try {
            return this.c.getToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            return PlatformDefaults.getDefaultDPI();
        }
    }

    public final int getVerticalScreenDPI() {
        try {
            return this.c.getToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            return PlatformDefaults.getDefaultDPI();
        }
    }

    public final int getScreenWidth() {
        try {
            return this.c.getToolkit().getScreenSize().width;
        }
        catch (HeadlessException headlessException) {
            return 1024;
        }
    }

    public final int getScreenHeight() {
        try {
            return this.c.getToolkit().getScreenSize().height;
        }
        catch (HeadlessException headlessException) {
            return 768;
        }
    }

    public final boolean hasBaseline() {
        if (this.bl == null) {
            try {
                Dimension dimension = this.c.getMinimumSize();
                this.bl = this.getBaseline(dimension.width, dimension.height) > -1;
            }
            catch (Throwable throwable) {
                this.bl = Boolean.FALSE;
            }
        }
        return this.bl;
    }

    public final String getLinkId() {
        return this.c.getName();
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        this.c.setBounds(n, n2, n3, n4);
    }

    public boolean isVisible() {
        return this.c.isVisible();
    }

    public final int[] getVisualPadding() {
        int[] nArray = null;
        if (SwingComponentWrapper.isVisualPaddingEnabled() && this.c instanceof JComponent) {
            Object object;
            JComponent jComponent = (JComponent)this.c;
            Object object2 = jComponent.getClientProperty(VISUAL_PADDING_PROPERTY);
            if (object2 instanceof int[]) {
                nArray = (int[])object2;
            } else if (object2 instanceof Insets) {
                object = (Insets)object2;
                nArray = new int[]{((Insets)object).top, ((Insets)object).left, ((Insets)object).bottom, ((Insets)object).right};
            }
            if (nArray == null) {
                Object object3;
                switch (this.getComponentType(false)) {
                    case 5: {
                        object3 = jComponent.getBorder();
                        if (object3 != null && object3.getClass().getName().startsWith("com.apple.laf.AquaButtonBorder")) {
                            if (PlatformDefaults.getPlatform() == 1) {
                                Object object4 = jComponent.getClientProperty("JButton.buttonType");
                                object = object4 == null ? (jComponent.getHeight() < 33 ? "Button" : "Button.bevel") : "Button." + object4;
                                if (((AbstractButton)jComponent).getIcon() == null) break;
                                object = (String)object + ".icon";
                                break;
                            }
                            object = "Button";
                            break;
                        }
                        object = "";
                        break;
                    }
                    case 16: {
                        object3 = jComponent.getBorder();
                        if (object3 != null && object3.getClass().getName().startsWith("com.apple.laf.AquaButtonBorder")) {
                            Object object5 = jComponent.getClientProperty("JComponent.sizeVariant");
                            object5 = object5 != null && !object5.toString().equals("regular") ? "." + object5 : "";
                            if (jComponent instanceof JRadioButton) {
                                object = "RadioButton" + object5;
                                break;
                            }
                            if (jComponent instanceof JCheckBox) {
                                object = "CheckBox" + object5;
                                break;
                            }
                            object = "ToggleButton" + object5;
                            break;
                        }
                        object = "";
                        break;
                    }
                    case 11: {
                        if (PlatformDefaults.getPlatform() == 1) {
                            if (((JComboBox)jComponent).isEditable()) {
                                Object object6 = jComponent.getClientProperty("JComboBox.isSquare");
                                if (object6 != null && object6.toString().equals("true")) {
                                    object = "ComboBox.editable.isSquare";
                                    break;
                                }
                                object = "ComboBox.editable";
                                break;
                            }
                            Object object7 = jComponent.getClientProperty("JComboBox.isSquare");
                            Object object8 = jComponent.getClientProperty("JComboBox.isPopDown");
                            if (object7 != null && object7.toString().equals("true")) {
                                object = "ComboBox.isSquare";
                                break;
                            }
                            if (object8 != null && object8.toString().equals("true")) {
                                object = "ComboBox.isPopDown";
                                break;
                            }
                            object = "ComboBox";
                            break;
                        }
                        object = "ComboBox";
                        break;
                    }
                    case 1: {
                        object = "Container";
                        break;
                    }
                    case 9: {
                        object = "Image";
                        break;
                    }
                    case 2: {
                        object = "Label";
                        break;
                    }
                    case 6: {
                        object = "List";
                        break;
                    }
                    case 10: {
                        object = "Panel";
                        break;
                    }
                    case 14: {
                        object = "ProgressBar";
                        break;
                    }
                    case 17: {
                        object = "ScrollBar";
                        break;
                    }
                    case 8: {
                        object = "ScrollPane";
                        break;
                    }
                    case 18: {
                        object = "Separator";
                        break;
                    }
                    case 12: {
                        object = "Slider";
                        break;
                    }
                    case 13: {
                        object = "Spinner";
                        break;
                    }
                    case 7: {
                        object = "Table";
                        break;
                    }
                    case 19: {
                        object = "TabbedPane";
                        break;
                    }
                    case 4: {
                        object = "TextArea";
                        break;
                    }
                    case 3: {
                        object3 = jComponent.getBorder();
                        if (!jComponent.isOpaque() && object3 != null && object3.getClass().getSimpleName().equals("AquaTextFieldBorder")) {
                            object = "TextField";
                            break;
                        }
                        object = "";
                        break;
                    }
                    case 15: {
                        object = "Tree";
                        break;
                    }
                    case 0: {
                        object = "Other";
                        break;
                    }
                    default: {
                        object = "";
                    }
                }
                object2 = PlatformDefaults.getDefaultVisualPadding((String)((String)object + "." + VISUAL_PADDING_PROPERTY));
                if (object2 instanceof int[]) {
                    nArray = (int[])object2;
                } else if (object2 instanceof Insets) {
                    object3 = (Insets)object2;
                    nArray = new int[]{((Insets)object3).top, ((Insets)object3).left, ((Insets)object3).bottom, ((Insets)object3).right};
                }
            }
        }
        return nArray;
    }

    public static boolean isMaxSizeSetOn1_4() {
        return maxSet;
    }

    public static void setMaxSizeSetOn1_4(boolean bl) {
        maxSet = bl;
    }

    public static boolean isVisualPaddingEnabled() {
        return vp;
    }

    public static void setVisualPaddingEnabled(boolean bl) {
        vp = bl;
    }

    public final void paintDebugOutline(boolean bl) {
        int[] nArray;
        if (!this.c.isShowing()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.c.getGraphics();
        if (graphics2D == null) {
            return;
        }
        graphics2D.setPaint(DB_COMP_OUTLINE);
        graphics2D.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 4.0f}, 0.0f));
        graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (bl && SwingComponentWrapper.isVisualPaddingEnabled() && (nArray = this.getVisualPadding()) != null) {
            graphics2D.setColor(Color.GREEN);
            graphics2D.drawRect(nArray[1], nArray[0], this.getWidth() - 1 - (nArray[1] + nArray[3]), this.getHeight() - 1 - (nArray[0] + nArray[2]));
        }
    }

    public int getComponentType(boolean bl) {
        if (this.compType == -1) {
            this.compType = this.checkType(bl);
        }
        return this.compType;
    }

    public int getLayoutHashCode() {
        String string;
        Dimension dimension = this.c.getMaximumSize();
        int n = dimension.width + (dimension.height << 5);
        dimension = this.c.getPreferredSize();
        n += (dimension.width << 10) + (dimension.height << 15);
        dimension = this.c.getMinimumSize();
        n += (dimension.width << 20) + (dimension.height << 25);
        if (this.c.isVisible()) {
            n += 1324511;
        }
        if ((string = this.getLinkId()) != null) {
            n += string.hashCode();
        }
        return n;
    }

    private int checkType(boolean bl) {
        Component component = this.c;
        if (bl) {
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            } else if (component instanceof ScrollPane) {
                component = ((ScrollPane)component).getComponent(0);
            }
        }
        if (component instanceof JTextField || component instanceof TextField) {
            return 3;
        }
        if (component instanceof JLabel || component instanceof Label) {
            return 2;
        }
        if (component instanceof JCheckBox || component instanceof JRadioButton || component instanceof Checkbox) {
            return 16;
        }
        if (component instanceof AbstractButton || component instanceof Button) {
            return 5;
        }
        if (component instanceof JComboBox || component instanceof Choice) {
            return 11;
        }
        if (component instanceof JTextComponent || component instanceof TextComponent) {
            return 4;
        }
        if (component instanceof JPanel || component instanceof Canvas) {
            return 10;
        }
        if (component instanceof JList || component instanceof List) {
            return 6;
        }
        if (component instanceof JTable) {
            return 7;
        }
        if (component instanceof JSeparator) {
            return 18;
        }
        if (component instanceof JSpinner) {
            return 13;
        }
        if (component instanceof JTabbedPane) {
            return 19;
        }
        if (component instanceof JProgressBar) {
            return 14;
        }
        if (component instanceof JSlider) {
            return 12;
        }
        if (component instanceof JScrollPane) {
            return 8;
        }
        if (component instanceof JScrollBar || component instanceof Scrollbar) {
            return 17;
        }
        if (component instanceof Container) {
            return 1;
        }
        return 0;
    }

    public final int hashCode() {
        return this.getComponent().hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ComponentWrapper)) {
            return false;
        }
        return this.c.equals(((ComponentWrapper)object).getComponent());
    }

    public int getContentBias() {
        return this.c instanceof JTextArea || this.c instanceof JEditorPane || this.c instanceof JComponent && Boolean.TRUE.equals(((JComponent)this.c).getClientProperty("migLayout.dynamicAspectRatio")) ? 0 : -1;
    }

    static {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.version"), "._-+");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            isJava9orLater = n >= 9;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

