/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.push.GitPushParams;
import git4idea.push.GitPushParamsImpl;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class GitDeleteRemoteTagOperation
extends GitBranchOperation {
    @NotNull
    private final Map<GitRepository, String> myRepositories;
    private final String myTagName;

    public GitDeleteRemoteTagOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler handler, @NotNull Map<GitRepository, String> repositories, @NotNull String name) {
        if (project == null) {
            GitDeleteRemoteTagOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitDeleteRemoteTagOperation.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            GitDeleteRemoteTagOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitDeleteRemoteTagOperation.$$$reportNull$$$0(3);
        }
        if (name == null) {
            GitDeleteRemoteTagOperation.$$$reportNull$$$0(4);
        }
        super(project, git, handler, repositories.keySet());
        this.myRepositories = repositories;
        this.myTagName = name;
    }

    @Override
    protected void execute() {
        String message;
        String onRemotes;
        String tagFullName = "refs/tags/" + this.myTagName;
        int successRemotes = 0;
        int failureRemotes = 0;
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getRepositories();
        for (GitRepository repository : repositories) {
            String expectedCommit = this.myRepositories.get(repository);
            List<GitPushParams.ForceWithLease> forceWithLease = expectedCommit != null ? Collections.singletonList(new GitPushParamsImpl.ForceWithLeaseReference(tagFullName, expectedCommit)) : Collections.emptyList();
            for (GitRemote remote : repository.getRemotes()) {
                GitCommandResult lsRemoteResult = this.myGit.lsRemoteRefs(this.myProject, repository.getRoot(), remote, Collections.singletonList(tagFullName), "--tags");
                if (!lsRemoteResult.success()) {
                    result2.append(repository, lsRemoteResult);
                    continue;
                }
                if (!GitDeleteRemoteTagOperation.hasTagOnRemote(tagFullName, lsRemoteResult.getOutput())) continue;
                GitCommandResult pushResult = this.myGit.push(repository, new GitPushParamsImpl(remote, ":" + tagFullName, false, false, false, null, forceWithLease), new GitLineHandlerListener[0]);
                result2.append(repository, pushResult);
                if (pushResult.success()) {
                    ++successRemotes;
                    continue;
                }
                ++failureRemotes;
            }
            repository.update();
        }
        boolean hasMultipleRemotes = ContainerUtil.exists(repositories, it -> it.getRemotes().size() > 1);
        String string = onRemotes = hasMultipleRemotes ? " on Remotes" : " on Remote";
        if (successRemotes > 0) {
            message = "<b>Deleted Tag" + onRemotes + ":</b> " + this.myTagName;
            this.notifySuccess("", message);
        } else if (successRemotes == 0 && failureRemotes == 0) {
            message = "<b>Tag Doesn't Exist" + onRemotes + ":</b> " + this.myTagName;
            this.notifySuccess("", message);
        }
        if (!result2.totalSuccess()) {
            String title = "Failed to delete tag " + this.myTagName + StringUtil.toLowerCase((String)onRemotes);
            VcsNotifier.getInstance((Project)this.myProject).notifyError(title, result2.getErrorOutputWithReposIndication());
        }
    }

    private static boolean hasTagOnRemote(@NotNull String tagFullName, @NotNull List<String> lsRemoteOutput) {
        if (tagFullName == null) {
            GitDeleteRemoteTagOperation.$$$reportNull$$$0(5);
        }
        if (lsRemoteOutput == null) {
            GitDeleteRemoteTagOperation.$$$reportNull$$$0(6);
        }
        return ContainerUtil.exists(lsRemoteOutput, line -> {
            if (tagFullName == null) {
                GitDeleteRemoteTagOperation.$$$reportNull$$$0(9);
            }
            if (StringUtil.isEmptyOrSpaces((String)line)) {
                return false;
            }
            List split = StringUtil.split((String)line, (String)"\t");
            if (split.size() != 2) {
                return false;
            }
            return tagFullName.equals(split.get(1));
        });
    }

    private void notifySuccess(@NotNull String title, @NotNull String message) {
        if (title == null) {
            GitDeleteRemoteTagOperation.$$$reportNull$$$0(7);
        }
        if (message == null) {
            GitDeleteRemoteTagOperation.$$$reportNull$$$0(8);
        }
        Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification(title, message, NotificationType.INFORMATION, null);
        VcsNotifier.getInstance((Project)this.myProject).notify(notification);
    }

    @Override
    protected void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getOperationName() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagFullName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lsRemoteOutput";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "git4idea/branch/GitDeleteRemoteTagOperation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTagOnRemote";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "notifySuccess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$hasTagOnRemote$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

