/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorMain;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.util.ScriptGenerator;
import org.jetbrains.ide.BuiltInServerManager;

public class GitRebaseEditorService {
    private String myEditorCommand;
    private final Object myScriptLock = new Object();
    private final Map<UUID, GitRebaseEditorHandler> myHandlers = ContainerUtil.newHashMap();
    private final Object myHandlersLock = new Object();
    @NonNls
    private static final String GIT_REBASE_EDITOR_PREFIX = "git-rebase-editor-";

    @NotNull
    public static GitRebaseEditorService getInstance() {
        GitRebaseEditorService service = (GitRebaseEditorService)ServiceManager.getService(GitRebaseEditorService.class);
        if (service == null) {
            throw new IllegalStateException("The service " + GitRebaseEditorService.class.getName() + " cannot be located");
        }
        GitRebaseEditorService gitRebaseEditorService = service;
        if (gitRebaseEditorService == null) {
            GitRebaseEditorService.$$$reportNull$$$0(0);
        }
        return gitRebaseEditorService;
    }

    private void addInternalHandler() {
        XmlRpcServer xmlRpcServer = XmlRpcServer.SERVICE.getInstance();
        if (!xmlRpcServer.hasHandler("Git4ideaRebaseEditorHandler")) {
            xmlRpcServer.addHandler("Git4ideaRebaseEditorHandler", (Object)new InternalHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public synchronized String getEditorCommand() {
        Object object = this.myScriptLock;
        // MONITORENTER : object
        if (this.myEditorCommand == null) {
            ScriptGenerator generator = new ScriptGenerator(GIT_REBASE_EDITOR_PREFIX, GitRebaseEditorMain.class);
            generator.addInternal(Integer.toString(BuiltInServerManager.getInstance().getPort()));
            generator.addClasses(XmlRpcClientLite.class, DecoderException.class);
            this.myEditorCommand = generator.commandLine();
        }
        String string = this.myEditorCommand;
        // MONITOREXIT : object
        if (string != null) return string;
        GitRebaseEditorService.$$$reportNull$$$0(1);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public UUID registerHandler(@NotNull GitRebaseEditorHandler handler, @NotNull Disposable parentDisposable) {
        if (handler == null) {
            GitRebaseEditorService.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            GitRebaseEditorService.$$$reportNull$$$0(3);
        }
        this.addInternalHandler();
        Object object = this.myHandlersLock;
        // MONITORENTER : object
        final UUID key = UUID.randomUUID();
        this.myHandlers.put(key, handler);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                GitRebaseEditorService.this.myHandlers.remove(key);
            }
        });
        UUID uUID = key;
        // MONITOREXIT : object
        if (uUID != null) return uUID;
        GitRebaseEditorService.$$$reportNull$$$0(4);
        return uUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(@NotNull UUID handlerNo) {
        if (handlerNo == null) {
            GitRebaseEditorService.$$$reportNull$$$0(5);
        }
        Object object = this.myHandlersLock;
        synchronized (object) {
            if (this.myHandlers.remove(handlerNo) == null) {
                throw new IllegalStateException("The handler " + handlerNo + " has been already removed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    GitRebaseEditorHandler getHandler(@NotNull UUID handlerNo) {
        if (handlerNo == null) {
            GitRebaseEditorService.$$$reportNull$$$0(6);
        }
        Object object = this.myHandlersLock;
        // MONITORENTER : object
        GitRebaseEditorHandler h = this.myHandlers.get(handlerNo);
        if (h == null) {
            throw new IllegalStateException("The handler " + handlerNo + " is not registered");
        }
        GitRebaseEditorHandler gitRebaseEditorHandler = h;
        // MONITOREXIT : object
        if (gitRebaseEditorHandler != null) return gitRebaseEditorHandler;
        GitRebaseEditorService.$$$reportNull$$$0(7);
        return gitRebaseEditorHandler;
    }

    public void configureHandler(GitLineHandler h, @NotNull UUID editorNo) {
        if (editorNo == null) {
            GitRebaseEditorService.$$$reportNull$$$0(8);
        }
        h.addCustomEnvironmentVariable("GIT_EDITOR", this.getEditorCommand());
        h.addCustomEnvironmentVariable("IDEA_REBASE_HANDER_NO", editorNo.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseEditorService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerNo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorNo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorCommand";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseEditorService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "registerHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterHandler";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class InternalHandler {
        public int editCommits(@NotNull String handlerNo, String path) {
            if (handlerNo == null) {
                InternalHandler.$$$reportNull$$$0(0);
            }
            GitRebaseEditorHandler editor = GitRebaseEditorService.this.getHandler(UUID.fromString(handlerNo));
            return editor.editCommits(path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerNo", "git4idea/rebase/GitRebaseEditorService$InternalHandler", "editCommits"));
        }
    }
}

