/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.dedication.QBlock;

public class QBlocks {
    private final List<QBlock> all = new ArrayList<QBlock>();

    private QBlocks() {
    }

    public static QBlocks readFrom(InputStream source, int size) throws IOException {
        QBlocks result = new QBlocks();
        QBlock block2;
        while ((block2 = QBlock.read(source, size)) != null) {
            result.all.add(block2);
        }
        return result;
    }

    public QBlocks change(BigInteger E, BigInteger N) {
        QBlocks result = new QBlocks();
        for (QBlock rsa : this.all) {
            result.all.add(rsa.change(E, N));
        }
        return result;
    }

    public void writeTo(OutputStream os, int size) throws IOException {
        for (QBlock rsa : this.all) {
            rsa.write(os, size);
        }
    }

    public String encodeAscii() {
        StringBuilder sb = new StringBuilder();
        AsciiEncoder encoder = new AsciiEncoder();
        for (QBlock rsa : this.all) {
            sb.append(encoder.encode(rsa.getData()));
            sb.append("!");
        }
        return sb.toString();
    }

    public static QBlocks descodeAscii(String s) {
        QBlocks result = new QBlocks();
        AsciiEncoder encoder = new AsciiEncoder();
        for (String bl : s.split("!")) {
            BigInteger bigInteger = new BigInteger(encoder.decode(bl));
            result.all.add(new QBlock(bigInteger));
        }
        return result;
    }
}

