/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.fun;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;

public class IconLoader {
    private static final int NUMBER_OF_ICONS = 21;
    private static final Map<String, BufferedImage> all = new ConcurrentHashMap<String, BufferedImage>();

    public static BufferedImage getRandom() {
        return IconLoader.addTransparent(IconLoader.getIcon(IconLoader.getSomeQuote()));
    }

    private static String getSomeQuote() {
        int v = (int)(System.currentTimeMillis() / 1000L);
        int n = v % 21;
        return "sprite" + String.format("%03d", n) + ".png";
    }

    private static BufferedImage getIcon(String name) {
        BufferedImage result = all.get(name);
        if (result == null && (result = IconLoader.getIconSlow(name)) != null) {
            all.put(name, result);
        }
        return result;
    }

    private static BufferedImage getIconSlow(String name) {
        try {
            InputStream is = IconLoader.class.getResourceAsStream(name);
            if (is == null) {
                return null;
            }
            BufferedImage image = ImageIO.read(is);
            is.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BufferedImage addTransparent(BufferedImage ico) {
        if (ico == null) {
            return null;
        }
        BufferedImage transparentIcon = new BufferedImage(ico.getWidth(), ico.getHeight(), 3);
        for (int i = 0; i < ico.getWidth(); ++i) {
            for (int j = 0; j < ico.getHeight(); ++j) {
                int col = ico.getRGB(i, j);
                if (col == ico.getRGB(0, 0)) continue;
                transparentIcon.setRGB(i, j, col);
            }
        }
        return transparentIcon;
    }
}

