/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.geom.AbstractPolyline;
import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.Polyline;
import net.sourceforge.plantuml.geom.XMoveable;

public class PolylineBreakeable
extends AbstractPolyline
implements Polyline {
    private final List<Breakure> breakures = new ArrayList<Breakure>();

    public PolylineBreakeable copy(Pointable newStart, Pointable newEnd) {
        PolylineBreakeable result = new PolylineBreakeable(newStart, newEnd);
        result.breakures.addAll(this.breakures);
        return result;
    }

    public PolylineBreakeable(Pointable start, Pointable end) {
        super(start, end);
    }

    @Override
    public List<LineSegmentInt> segments() {
        if (this.breakures.size() == 0) {
            return Collections.singletonList(new LineSegmentInt(this.getStart().getPosition(), this.getEnd().getPosition()));
        }
        ArrayList<LineSegmentInt> result = new ArrayList<LineSegmentInt>();
        Point2DInt cur = this.getStart().getPosition();
        for (Breakure breakure : this.breakures) {
            Point2DInt next = this.getBreakurePoint(breakure);
            result.add(new LineSegmentInt(cur, next));
            cur = next;
        }
        result.add(new LineSegmentInt(cur, this.getEnd().getPosition()));
        assert (this.nbSegments() == result.size());
        return Collections.unmodifiableList(result);
    }

    private Point2DInt getBreakurePoint(Breakure breakure) {
        LineSegmentInt seg = new LineSegmentInt(this.getStart().getPosition(), this.getEnd().getPosition());
        return seg.ortho(seg.startTranslatedAsVector(breakure.u), breakure.d);
    }

    @Override
    public int nbSegments() {
        return this.breakures.size() + 1;
    }

    public List<XMoveable> getFreedoms() {
        ArrayList<XMoveable> allFreedom = new ArrayList<XMoveable>();
        for (final Breakure breakure : this.breakures) {
            allFreedom.add(new XMoveable(){

                public String toString() {
                    return super.toString() + " " + PolylineBreakeable.this.toString() + "(d)";
                }

                @Override
                public void moveX(int delta) {
                    breakure.d = breakure.d + delta;
                }
            });
            allFreedom.add(new XMoveable(){

                public String toString() {
                    return super.toString() + " " + PolylineBreakeable.this.toString() + "(u)";
                }

                @Override
                public void moveX(int delta) {
                    breakure.u = breakure.u + delta;
                }
            });
            allFreedom.add(new XMoveable(){

                public String toString() {
                    return super.toString() + " " + PolylineBreakeable.this.toString() + "(ud)";
                }

                @Override
                public void moveX(int delta) {
                    breakure.u = breakure.u + delta;
                    breakure.d = breakure.d + delta;
                }
            });
            allFreedom.add(new XMoveable(){

                public String toString() {
                    return super.toString() + " " + PolylineBreakeable.this.toString() + "(dud)";
                }

                @Override
                public void moveX(int delta) {
                    breakure.u = breakure.u + delta;
                    breakure.d = breakure.d - delta;
                }
            });
        }
        return Collections.unmodifiableList(allFreedom);
    }

    public void insertBetweenPoint(int u, int d) {
        this.breakures.add(new Breakure(u, d));
    }

    private void breakMore() {
        if (this.breakures.size() == 1) {
            Breakure b = this.breakures.get(0);
            this.insertBetweenPoint(b.u / 2, 0);
        }
    }

    static class Breakure {
        private int d;
        private int u;

        public Breakure(int u, int d) {
            this.u = u;
            this.d = d;
        }
    }
}

