/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockVertical2
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final List<TextBlock> blocks = new ArrayList<TextBlock>();
    private final HorizontalAlignment horizontalAlignment;

    TextBlockVertical2(TextBlock b1, TextBlock b2, HorizontalAlignment horizontalAlignment) {
        this.blocks.add(b1);
        this.blocks.add(b2);
        this.horizontalAlignment = horizontalAlignment;
    }

    public TextBlockVertical2(List<TextBlock> all, HorizontalAlignment horizontalAlignment) {
        if (all.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.blocks.addAll(all);
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.blocks.get(0).calculateDimension(stringBounder);
        for (int i = 1; i < this.blocks.size(); ++i) {
            dim = Dimension2DDouble.mergeTB(dim, this.blocks.get(i).calculateDimension(stringBounder));
        }
        return dim;
    }

    @Override
    public void drawU(UGraphic ug) {
        double y = 0.0;
        Dimension2D dimtotal = this.calculateDimension(ug.getStringBounder());
        for (TextBlock block2 : this.blocks) {
            HtmlColor back;
            Dimension2D dimb = block2.calculateDimension(ug.getStringBounder());
            if (block2 instanceof TextBlockBackcolored && (back = ((TextBlockBackcolored)block2).getBackcolor()) != null) {
                ug.apply(new UTranslate(0.0, y)).apply(new UChangeColor(back)).apply(new UChangeBackColor(back)).draw(new URectangle(dimtotal.getWidth(), dimb.getHeight()));
            }
            if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
                block2.drawU(ug.apply(new UTranslate(0.0, y)));
            } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
                double dx = (dimtotal.getWidth() - dimb.getWidth()) / 2.0;
                block2.drawU(ug.apply(new UTranslate(dx, y)));
            } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
                double dx = dimtotal.getWidth() - dimb.getWidth();
                block2.drawU(ug.apply(new UTranslate(dx, y)));
            } else {
                throw new UnsupportedOperationException();
            }
            y += dimb.getHeight();
        }
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        double y = 0.0;
        Ports result = new Ports();
        for (TextBlock block2 : this.blocks) {
            Dimension2D dimb = block2.calculateDimension(stringBounder);
            Ports tmp = ((WithPorts)((Object)block2)).getPorts(stringBounder).translateY(y);
            result.addThis(tmp);
            y += dimb.getHeight();
        }
        return result;
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        double y = 0.0;
        for (TextBlock block2 : this.blocks) {
            Dimension2D dimb = block2.calculateDimension(stringBounder);
            Rectangle2D result = block2.getInnerPosition(member, stringBounder, strategy);
            if (result != null) {
                return new UTranslate(0.0, y).apply(result);
            }
            y += dimb.getHeight();
        }
        return null;
    }
}

