/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.EnumSet;

public enum Month {
    JAN(31),
    FEB(28),
    MAR(31),
    APR(30),
    MAY(31),
    JUN(30),
    JUL(31),
    AUG(31),
    SEP(30),
    OCT(31),
    NOV(30),
    DEC(31);

    private final int nbDays;

    private Month(int nbDays) {
        this.nbDays = nbDays;
    }

    public final int getNbDays(int year) {
        if (this == FEB && year % 4 == 0) {
            return 29;
        }
        return this.nbDays;
    }

    public final int getNum() {
        return this.ordinal() + 1;
    }

    public final int getNumNormal() {
        return this.ordinal();
    }

    public Month next() {
        if (this == DEC) {
            return null;
        }
        ArrayList<Month> all = new ArrayList<Month>(EnumSet.allOf(Month.class));
        return (Month)((Object)all.get(this.getNum()));
    }

    public Month prev() {
        if (this == JAN) {
            return null;
        }
        ArrayList<Month> all = new ArrayList<Month>(EnumSet.allOf(Month.class));
        return (Month)((Object)all.get(this.getNum() - 2));
    }

    public static Month fromNum(int num) {
        if (num < 1 || num > 12) {
            throw new IllegalArgumentException();
        }
        ArrayList<Month> all = new ArrayList<Month>(EnumSet.allOf(Month.class));
        return (Month)((Object)all.get(num - 1));
    }
}

