/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSetInitializer;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.sequencediagram.graphic.PageSplitter;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramArea;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class SequenceDiagramFileMakerPuma2
implements FileMaker {
    private final SequenceDiagram diagram;
    private final DrawableSet drawableSet;
    private final Dimension2D fullDimension;
    private final List<Page> pages;
    private final FileFormatOption fileFormatOption;
    private final StringBounder stringBounder;
    private double scale;

    public SequenceDiagramFileMakerPuma2(SequenceDiagram sequenceDiagram, Skin skin, FileFormatOption fileFormatOption) {
        this.diagram = sequenceDiagram;
        this.stringBounder = fileFormatOption.getDefaultStringBounder();
        this.fileFormatOption = fileFormatOption;
        DrawableSetInitializer initializer = new DrawableSetInitializer(skin, sequenceDiagram.getSkinParam(), sequenceDiagram.isShowFootbox(), sequenceDiagram.getAutonewpage());
        for (Participant participant : sequenceDiagram.participants().values()) {
            initializer.addParticipant(participant, sequenceDiagram.getEnglober(participant));
        }
        for (Event event : sequenceDiagram.events()) {
            initializer.addEvent(event);
        }
        this.drawableSet = initializer.createDrawableSet(this.stringBounder);
        ArrayList<Newpage> newpages = new ArrayList<Newpage>();
        for (Event ev : this.drawableSet.getAllEvents()) {
            if (!(ev instanceof Newpage)) continue;
            newpages.add((Newpage)ev);
        }
        this.fullDimension = this.drawableSet.getDimension();
        LinkedHashMap<Newpage, Double> linkedHashMap = new LinkedHashMap<Newpage, Double>();
        for (Newpage n : newpages) {
            linkedHashMap.put(n, initializer.getYposition(this.stringBounder, n));
        }
        this.pages = this.create(this.drawableSet, linkedHashMap, sequenceDiagram.isShowFootbox(), sequenceDiagram.getTitle().getDisplay()).getPages();
    }

    @Override
    public int getNbPages() {
        return this.pages.size();
    }

    private PageSplitter create(DrawableSet drawableSet, Map<Newpage, Double> positions, boolean showFootbox, Display title) {
        double headerHeight = drawableSet.getHeadHeight(this.stringBounder);
        double tailHeight = drawableSet.getTailHeight(this.stringBounder, showFootbox);
        double signatureHeight = 0.0;
        double newpageHeight = drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, null, drawableSet.getSkinParam(), Display.create("")).getPreferredHeight(this.stringBounder);
        return new PageSplitter(this.fullDimension.getHeight(), headerHeight, positions, tailHeight, 0.0, newpageHeight, title);
    }

    @Override
    public ImageData createOne(OutputStream os, final int index, boolean isWithMetadata) throws IOException {
        TextBlock compTitle;
        final Page page = this.pages.get(index);
        final SequenceDiagramArea area = new SequenceDiagramArea(this.fullDimension.getWidth(), page.getHeight());
        final TextBlock caption = new AnnotatedWorker(this.diagram, this.diagram.getSkinParam()).getCaption();
        area.setCaptionArea(caption.calculateDimension(this.stringBounder));
        if (Display.isNull(page.getTitle())) {
            compTitle = null;
        } else {
            compTitle = TextBlockUtils.withMargin(TextBlockUtils.title(new FontConfiguration(this.drawableSet.getSkinParam(), FontParam.SEQUENCE_TITLE, null), page.getTitle(), this.drawableSet.getSkinParam()), 7.0, 7.0);
            Dimension2D dimTitle = compTitle.calculateDimension(this.stringBounder);
            area.setTitleArea(dimTitle.getWidth(), dimTitle.getHeight());
        }
        area.initFooter(this.getPngTitler(FontParam.FOOTER), this.stringBounder);
        area.initHeader(this.getPngTitler(FontParam.HEADER), this.stringBounder);
        final DisplayPositionned legend = this.diagram.getLegend();
        final TextBlock legendBlock = DisplayPositionned.isNull(legend) ? TextBlockUtils.empty(0.0, 0.0) : EntityImageLegend.create(legend.getDisplay(), this.diagram.getSkinParam());
        final Dimension2D dimLegend = legendBlock.calculateDimension(this.stringBounder);
        this.scale = this.getScale(area.getWidth(), area.getHeight());
        double dpiFactor = this.diagram.getDpiFactor(this.fileFormatOption);
        String metadata = this.fileFormatOption.isWithMetadata() ? this.diagram.getMetadata() : null;
        ImageBuilder imageBuilder = new ImageBuilder(this.diagram.getSkinParam(), this.oneOf(this.scale, dpiFactor), metadata, null, 3.0, 10.0, this.diagram.getAnimation());
        imageBuilder.setUDrawable(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                double delta = 0.0;
                if (index > 0) {
                    delta = page.getNewpage1() - page.getHeaderHeight();
                }
                if (delta < 0.0) {
                    delta = 0.0;
                }
                double legendYdelta = 0.0;
                if (compTitle != null) {
                    StringBounder stringBounder = ug.getStringBounder();
                    double h = compTitle.calculateDimension(stringBounder).getHeight();
                    legendYdelta += h;
                    compTitle.drawU(ug.apply(new UTranslate(area.getTitleX(), area.getTitleY())));
                }
                caption.drawU(ug.apply(new UTranslate(area.getCaptionX(), area.getCaptionY())));
                double delta1 = Math.max(0.0, dimLegend.getWidth() - area.getWidth());
                boolean legendTop = !DisplayPositionned.isNull(legend) && legend.getVerticalAlignment() == VerticalAlignment.TOP;
                double sequenceAreaY = area.getSequenceAreaY();
                if (legendTop) {
                    sequenceAreaY += legendBlock.calculateDimension(ug.getStringBounder()).getHeight();
                }
                SequenceDiagramFileMakerPuma2.this.drawableSet.drawU22(ug.apply(new UTranslate(area.getSequenceAreaX() + delta1 / 2.0, sequenceAreaY)), delta, SequenceDiagramFileMakerPuma2.this.fullDimension.getWidth(), page, SequenceDiagramFileMakerPuma2.this.diagram.isShowFootbox());
                SequenceDiagramFileMakerPuma2.this.drawHeader(area, ug);
                SequenceDiagramFileMakerPuma2.this.drawFooter(area, ug);
                if (!DisplayPositionned.isNull(legend)) {
                    double delta2 = legend.getHorizontalAlignment() == HorizontalAlignment.LEFT ? 0.0 : (legend.getHorizontalAlignment() == HorizontalAlignment.RIGHT ? Math.max(0.0, area.getWidth() - dimLegend.getWidth()) : Math.max(0.0, area.getWidth() - dimLegend.getWidth()) / 2.0);
                    legendBlock.drawU(ug.apply(new UTranslate(delta2, legendTop ? legendYdelta : legendYdelta + area.getHeight())));
                }
            }
        });
        return imageBuilder.writeImageTOBEMOVED(this.fileFormatOption, this.diagram.seed(), os);
    }

    private void drawFooter(SequenceDiagramArea area, UGraphic ug) {
        PngTitler pngTitler = this.getPngTitler(FontParam.FOOTER);
        TextBlock text = pngTitler.getTextBlock();
        if (text == null) {
            return;
        }
        text.drawU(ug.apply(new UTranslate(area.getFooterX(this.diagram.getFooter().getHorizontalAlignment()), area.getFooterY())));
    }

    private void drawHeader(SequenceDiagramArea area, UGraphic ug) {
        PngTitler pngTitler = this.getPngTitler(FontParam.HEADER);
        TextBlock text = pngTitler.getTextBlock();
        if (text == null) {
            return;
        }
        text.drawU(ug.apply(new UTranslate(area.getHeaderX(this.diagram.getHeader().getHorizontalAlignment()), area.getHeaderY())));
    }

    private double oneOf(double a, double b) {
        if (a == 1.0) {
            return b;
        }
        return a;
    }

    private double getImageWidth(SequenceDiagramArea area, double dpiFactor, double legendWidth) {
        int minsize = this.diagram.getMinwidth();
        double w = Math.max(area.getWidth() * this.getScale(area.getWidth(), area.getHeight()) * dpiFactor, legendWidth);
        if (minsize == Integer.MAX_VALUE) {
            return w;
        }
        if (w >= (double)minsize) {
            return w;
        }
        return minsize;
    }

    private double getScale(double width, double height) {
        if (this.diagram.getScale() == null) {
            return 1.0;
        }
        return this.diagram.getScale().getScale(width, height);
    }

    private PngTitler getPngTitler(FontParam fontParam) {
        HtmlColor hyperlinkColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor titleColor = this.diagram.getSkinParam().getFontHtmlColor(null, fontParam);
        String fontFamily = this.diagram.getSkinParam().getFont(null, false, fontParam).getFamily(null);
        int fontSize = this.diagram.getSkinParam().getFont(null, false, fontParam).getSize();
        return new PngTitler(titleColor, this.diagram.getFooterOrHeaderTeoz(fontParam).getDisplay(), fontSize, fontFamily, this.diagram.getFooterOrHeaderTeoz(fontParam).getHorizontalAlignment(), hyperlinkColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
    }
}

