/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CircleInterface
implements UDrawable {
    private final float thickness;
    private final double headDiam;
    private final HtmlColor backgroundColor;
    private final HtmlColor foregroundColor;

    public CircleInterface(HtmlColor backgroundColor, HtmlColor foregroundColor) {
        this(backgroundColor, foregroundColor, 16.0, 2.0f);
    }

    public CircleInterface(HtmlColor backgroundColor, HtmlColor foregroundColor, double headDiam, float thickness) {
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        this.headDiam = headDiam;
        this.thickness = thickness;
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse head = new UEllipse(this.headDiam, this.headDiam);
        ug.apply(new UStroke(this.thickness)).apply(new UChangeBackColor(this.backgroundColor)).apply(new UChangeColor(this.foregroundColor)).apply(new UTranslate(this.thickness, this.thickness)).draw(head);
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.headDiam + (double)(2.0f * this.thickness);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.headDiam + (double)(2.0f * this.thickness);
    }
}

