/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class EntityImageCircleStart
extends AbstractEntityImage {
    private static final int SIZE = 20;
    private final ColorParam colorParam;

    public EntityImageCircleStart(ILeaf entity, ISkinParam skinParam, ColorParam colorParam) {
        super(entity, skinParam);
        this.colorParam = colorParam;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(20.0, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(20.0, 20.0);
        if (this.getSkinParam().shadowing()) {
            circle.setDeltaShadow(3.0);
        }
        ug.apply(new UChangeBackColor(SkinParamUtils.getColor(this.getSkinParam(), this.colorParam, this.getStereo()))).apply(new UChangeColor(null)).draw(circle);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

