/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverEllipseSvg
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverEllipseSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        HtmlColor back;
        UEllipse shape = (UEllipse)ushape;
        double width = shape.getWidth();
        double height = shape.getHeight();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            if (!clip.isInside(x, y)) {
                return;
            }
            if (!clip.isInside(x + width, y + height)) {
                return;
            }
        }
        if ((back = param.getBackcolor()) instanceof HtmlColorGradient) {
            HtmlColorGradient gr = (HtmlColorGradient)back;
            String id = svg.createSvgGradient(StringUtils.getAsHtml(mapper.getMappedColor(gr.getColor1())), StringUtils.getAsHtml(mapper.getMappedColor(gr.getColor2())), gr.getPolicy());
            svg.setFillColor("url(#" + id + ")");
        } else if (back == null || back instanceof HtmlColorTransparent) {
            svg.setFillColor("none");
        } else {
            String backcolor = StringUtils.getAsSvg(mapper, back);
            svg.setFillColor(backcolor);
        }
        String color = StringUtils.getAsSvg(mapper, param.getColor());
        svg.setStrokeColor(color);
        svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        double start = shape.getStart();
        double extend = shape.getExtend();
        double cx = x + width / 2.0;
        double cy = y + height / 2.0;
        if (start == 0.0 && extend == 0.0) {
            svg.svgEllipse(cx, cy, width / 2.0, height / 2.0, shape.getDeltaShadow());
        } else {
            double x1 = cx + Math.sin((start += 90.0) * Math.PI / 180.0) * width / 2.0;
            double y1 = cy + Math.cos(start * Math.PI / 180.0) * height / 2.0;
            double x2 = cx + Math.sin((start + extend) * Math.PI / 180.0) * width / 2.0;
            double y2 = cy + Math.cos((start + extend) * Math.PI / 180.0) * height / 2.0;
            svg.svgArcEllipse(width / 2.0, height / 2.0, x1, y1, x2, y2);
        }
    }
}

