/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.IntStack;
import com.intellij.util.graph.Graph;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance((String)ControlFlowUtil.class.getName());

    private ControlFlowUtil() {
    }

    @NotNull
    public static Graph<Instruction> createGraph(final @NotNull Instruction[] flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(0);
        }
        Graph<Instruction> graph = new Graph<Instruction>(){
            @NotNull
            private final List<Instruction> myList;
            {
                this.myList = Arrays.asList(flow);
            }

            public Collection<Instruction> getNodes() {
                return this.myList;
            }

            public Iterator<Instruction> getIn(Instruction n) {
                return n.allPred().iterator();
            }

            public Iterator<Instruction> getOut(Instruction n) {
                return n.allSucc().iterator();
            }
        };
        if (graph == null) {
            ControlFlowUtil.$$$reportNull$$$0(1);
        }
        return graph;
    }

    public static int findInstructionNumberByElement(Instruction[] flow, PsiElement element) {
        for (int i = 0; i < flow.length; ++i) {
            ProgressManager.checkCanceled();
            if (element != flow[i].getElement()) continue;
            return i;
        }
        return -1;
    }

    public static boolean process(Instruction[] flow, int start, Processor<Instruction> processor2) {
        int length = flow.length;
        boolean[] visited = new boolean[length];
        Arrays.fill(visited, false);
        IntStack stack = new IntStack(length);
        stack.push(start);
        while (!stack.empty()) {
            ProgressManager.checkCanceled();
            int num = stack.pop();
            Instruction instruction = flow[num];
            if (!processor2.process((Object)instruction)) {
                return false;
            }
            for (Instruction succ : instruction.allSucc()) {
                int succNum = succ.num();
                if (visited[succNum]) continue;
                visited[succNum] = true;
                stack.push(succNum);
            }
        }
        return true;
    }

    public static void iteratePrev(int startInstruction, @NotNull Instruction[] instructions, @NotNull Function<Instruction, Operation> closure) {
        if (instructions == null) {
            ControlFlowUtil.$$$reportNull$$$0(2);
        }
        if (closure == null) {
            ControlFlowUtil.$$$reportNull$$$0(3);
        }
        IntStack stack = new IntStack(instructions.length);
        boolean[] visited = new boolean[instructions.length];
        stack.push(startInstruction);
        while (!stack.empty()) {
            ProgressManager.checkCanceled();
            int num = stack.pop();
            Instruction instr = instructions[num];
            Operation nextOperation = (Operation)((Object)closure.fun((Object)instr));
            if (nextOperation == Operation.CONTINUE) continue;
            if (nextOperation == Operation.BREAK) break;
            assert (nextOperation == Operation.NEXT);
            for (Instruction pred : instr.allPred()) {
                int predNum = pred.num();
                if (visited[predNum]) continue;
                visited[predNum] = true;
                stack.push(predNum);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/controlflow/ControlFlowUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/controlflow/ControlFlowUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGraph";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "iteratePrev";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Operation {
        CONTINUE,
        BREAK,
        NEXT;

    }
}

