/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettingsImpl;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.IntentionsUIImpl;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.PassExecutorService;
import com.intellij.codeInsight.daemon.impl.StatusBarUpdater;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.impl.FileLevelIntentionComponent;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DaemonCodeAnalyzer", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DaemonCodeAnalyzerImpl
extends DaemonCodeAnalyzerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
    private static final Key<List<HighlightInfo>> FILE_LEVEL_HIGHLIGHTS = Key.create((String)"FILE_LEVEL_HIGHLIGHTS");
    private final Project myProject;
    private final DaemonCodeAnalyzerSettings mySettings;
    @NotNull
    private final EditorTracker myEditorTracker;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    private DaemonProgressIndicator myUpdateProgress;
    private final UpdateRunnable myUpdateRunnable;
    private final ScheduledExecutorService myAlarm;
    @NotNull
    private volatile Future<?> myUpdateRunnableFuture;
    private boolean myUpdateByTimerEnabled;
    private final Collection<VirtualFile> myDisabledHintsFiles;
    private final Collection<VirtualFile> myDisabledHighlightingFiles;
    private final FileStatusMap myFileStatusMap;
    private DaemonCodeAnalyzerSettings myLastSettings;
    private volatile boolean myDisposed;
    private volatile boolean myInitialized;
    @NonNls
    private static final String DISABLE_HINTS_TAG = "disable_hints";
    @NonNls
    private static final String FILE_TAG = "file";
    @NonNls
    private static final String URL_ATT = "url";
    private final PassExecutorService myPassExecutorService;
    private volatile boolean mustWaitForSmartMode;
    private final AtomicInteger myDisableCount;

    public DaemonCodeAnalyzerImpl(@NotNull Project project, @NotNull DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings, @NotNull EditorTracker editorTracker, @NotNull PsiDocumentManager psiDocumentManager, @NotNull NamedScopeManager namedScopeManager, @NotNull DependencyValidationManager dependencyValidationManager) {
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(0);
        }
        if (daemonCodeAnalyzerSettings == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(1);
        }
        if (editorTracker == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(2);
        }
        if (psiDocumentManager == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(3);
        }
        if (namedScopeManager == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(4);
        }
        if (dependencyValidationManager == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(5);
        }
        this.myUpdateProgress = new DaemonProgressIndicator();
        this.myAlarm = EdtExecutorService.getScheduledExecutorInstance();
        this.myUpdateRunnableFuture = CompletableFuture.completedFuture(null);
        this.myUpdateByTimerEnabled = true;
        this.myDisabledHintsFiles = new THashSet();
        this.myDisabledHighlightingFiles = new THashSet();
        this.mustWaitForSmartMode = true;
        this.myDisableCount = new AtomicInteger();
        this.myProject = project;
        this.mySettings = daemonCodeAnalyzerSettings;
        this.myEditorTracker = editorTracker;
        this.myPsiDocumentManager = psiDocumentManager;
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)daemonCodeAnalyzerSettings).clone();
        this.myFileStatusMap = new FileStatusMap(project);
        this.myPassExecutorService = new PassExecutorService(project);
        Disposer.register((Disposable)this, (Disposable)this.myPassExecutorService);
        Disposer.register((Disposable)this, (Disposable)this.myFileStatusMap);
        DaemonProgressIndicator.setDebug(LOG.isDebugEnabled());
        assert (!this.myInitialized) : "Double Initializing";
        Disposer.register((Disposable)this, (Disposable)new StatusBarUpdater(project));
        this.myInitialized = true;
        this.myDisposed = false;
        this.myFileStatusMap.markAllFilesDirty("DCAI init");
        this.myUpdateRunnable = new UpdateRunnable(this.myProject);
        Disposer.register((Disposable)this, () -> {
            assert (this.myInitialized) : "Disposing not initialized component";
            assert (!this.myDisposed) : "Double dispose";
            this.myUpdateRunnable.clearFieldsOnDispose();
            this.stopProcess(false, "Dispose");
            this.myDisposed = true;
            this.myLastSettings = null;
        });
    }

    public synchronized void dispose() {
        this.clearReferences();
    }

    private synchronized void clearReferences() {
        this.myUpdateProgress = new DaemonProgressIndicator();
        this.myUpdateRunnableFuture.cancel(true);
    }

    @NotNull
    public static List<HighlightInfo> getHighlights(@NotNull Document document, HighlightSeverity minSeverity, @NotNull Project project) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(6);
        }
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(7);
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerImpl.processHighlights(document, project, minSeverity, 0, document.getTextLength(), (Processor<HighlightInfo>)Processors.cancelableCollectProcessor(infos));
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<HighlightInfo> getFileLevelHighlights(@NotNull Project project, @NotNull PsiFile file2) {
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(10);
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        List<HighlightInfo> list2 = Arrays.stream(manager.getEditors(vFile)).map(fileEditor -> (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        if (list2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Override
    public void cleanFileLevelHighlights(@NotNull Project project, int group, PsiFile psiFile) {
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(12);
        }
        if (psiFile == null) {
            return;
        }
        FileViewProvider provider = psiFile.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            List infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (infos == null) continue;
            ArrayList<HighlightInfo> infosToRemove = new ArrayList<HighlightInfo>();
            for (HighlightInfo info : infos) {
                if (info.getGroup() != group) continue;
                manager.removeTopComponent(fileEditor, info.fileLevelComponent);
                infosToRemove.add(info);
            }
            infos.removeAll(infosToRemove);
        }
    }

    @Override
    public void addFileLevelHighlight(@NotNull Project project, int group, @NotNull HighlightInfo info, @NotNull PsiFile psiFile) {
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(13);
        }
        if (info == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(14);
        }
        if (psiFile == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(15);
        }
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            FileLevelIntentionComponent component = new FileLevelIntentionComponent(info.getDescription(), info.getSeverity(), info.getGutterIconRenderer(), info.quickFixActionRanges, project, psiFile, ((TextEditor)fileEditor).getEditor(), info.getToolTip());
            manager.addTopComponent(fileEditor, (JComponent)((Object)component));
            ArrayList<HighlightInfo> fileLevelInfos = (ArrayList<HighlightInfo>)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (fileLevelInfos == null) {
                fileLevelInfos = new ArrayList<HighlightInfo>();
                fileEditor.putUserData(FILE_LEVEL_HIGHLIGHTS, fileLevelInfos);
            }
            info.fileLevelComponent = component;
            info.setGroup(group);
            fileLevelInfos.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<HighlightInfo> runMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull ProgressIndicator progress) {
        ArrayList<HighlightInfo> result2;
        block13: {
            if (psiFile == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(16);
            }
            if (document == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(17);
            }
            if (progress == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(18);
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new IllegalStateException("Must not run highlighting from under EDT");
            }
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                throw new IllegalStateException("Must run highlighting from under read action");
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (!(indicator instanceof DaemonProgressIndicator)) {
                throw new IllegalStateException("Must run highlighting under progress with DaemonProgressIndicator");
            }
            this.myFileStatusMap.markAllFilesDirty("prepare to run main passes");
            this.stopProcess(false, "disable background daemon");
            this.myPassExecutorService.cancelAll(true);
            try {
                result2 = new ArrayList<HighlightInfo>();
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile == null || virtualFile.getFileType().isBinary()) break block13;
                List<TextEditorHighlightingPass> passes = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject).instantiateMainPasses(psiFile, document, HighlightInfoProcessor.getEmpty());
                Collections.sort(passes, (o1, o2) -> {
                    if (o1 instanceof GeneralHighlightingPass) {
                        return -1;
                    }
                    if (o2 instanceof GeneralHighlightingPass) {
                        return 1;
                    }
                    return 0;
                });
                try {
                    for (TextEditorHighlightingPass pass : passes) {
                        pass.doCollectInformation(progress);
                        result2.addAll(pass.getInfos());
                    }
                }
                catch (ProcessCanceledException e) {
                    LOG.debug("Canceled: " + progress);
                    throw e;
                }
            }
            finally {
                this.stopProcess(true, "re-enable background daemon after main passes run");
            }
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    public void mustWaitForSmartMode(boolean mustWait, @NotNull Disposable parent) {
        if (parent == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(20);
        }
        boolean old = this.mustWaitForSmartMode;
        this.mustWaitForSmartMode = mustWait;
        Disposer.register((Disposable)parent, () -> {
            this.mustWaitForSmartMode = old;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<HighlightInfo> runPasses(@NotNull PsiFile file2, @NotNull Document document, @NotNull List<TextEditor> textEditors, @NotNull int[] toIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) throws ProcessCanceledException {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(21);
        }
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(22);
        }
        if (textEditors == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(23);
        }
        if (toIgnore == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(24);
        }
        assert (this.myInitialized);
        assert (!this.myDisposed);
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.assertIsDispatchThread();
        if (application.isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Must not start highlighting from within write action, or deadlock is imminent");
        }
        DaemonProgressIndicator.setDebug(!ApplicationInfoImpl.isInStressTest());
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        UIUtil.dispatchAllInvocationEvents();
        while (RefreshQueueImpl.isRefreshInProgress() || HeavyProcessLatch.INSTANCE.isRunning()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        long dstart = System.currentTimeMillis();
        while (this.mustWaitForSmartMode && DumbService.getInstance((Project)this.myProject).isDumb()) {
            if (System.currentTimeMillis() > dstart + 100000L) {
                throw new IllegalStateException("Timeout waiting for smart mode. If you absolutely want to be dumb, please use DaemonCodeAnalyzerImpl.mustWaitForSmartMode(false).");
            }
            UIUtil.dispatchAllInvocationEvents();
        }
        UIUtil.dispatchAllInvocationEvents();
        Project project = file2.getProject();
        FileStatusMap fileStatusMap = this.getFileStatusMap();
        HashMap<FileEditor, HighlightingPass[]> map2 = new HashMap<FileEditor, HighlightingPass[]>();
        for (TextEditor textEditor : textEditors) {
            TextEditorBackgroundHighlighter highlighter;
            if (textEditor instanceof TextEditorImpl) {
                try {
                    ((TextEditorImpl)textEditor).waitForLoaded(10L, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(textEditor + " has not completed loading in 10 seconds");
                }
            }
            if ((highlighter = (TextEditorBackgroundHighlighter)textEditor.getBackgroundHighlighter()) == null) {
                Editor editor = textEditor.getEditor();
                throw new RuntimeException("Null highlighter from " + textEditor + "; loaded: " + AsyncEditorLoader.isEditorLoaded(editor));
            }
            List<TextEditorHighlightingPass> passes = highlighter.getPasses(toIgnore);
            HighlightingPass[] array = passes.toArray(HighlightingPass.EMPTY_ARRAY);
            assert (array.length != 0) : "Highlighting is disabled for the file " + file2;
            map2.put((FileEditor)textEditor, array);
        }
        for (Object ignoreId : (Object)toIgnore) {
            fileStatusMap.markFileUpToDate(document, (int)ignoreId);
        }
        this.myUpdateRunnableFuture.cancel(false);
        DaemonProgressIndicator progress = this.createUpdateProgress(map2.keySet());
        this.myPassExecutorService.submitPasses(map2, progress);
        fileStatusMap.allowDirt(canChangeDocument);
        long start = System.currentTimeMillis();
        while (progress.isRunning() && System.currentTimeMillis() < start + 600000L) {
            DaemonCodeAnalyzerImpl.wrap(() -> {
                progress.checkCanceled();
                if (callbackWhileWaiting != null) {
                    callbackWhileWaiting.run();
                }
                this.waitInOtherThread(50, canChangeDocument);
                UIUtil.dispatchAllInvocationEvents();
                Throwable savedException = PassExecutorService.getSavedException(progress);
                if (savedException != null) {
                    throw savedException;
                }
            });
        }
        if (progress.isRunning() && !progress.isCanceled()) {
            throw new RuntimeException("Highlighting still running after " + (System.currentTimeMillis() - start) / 1000L + " seconds. Still submitted passes: " + this.myPassExecutorService.getAllSubmittedPasses() + " ForkJoinPool.commonPool(): " + ForkJoinPool.commonPool() + "\n, ForkJoinPool.commonPool() active thread count: " + ForkJoinPool.commonPool().getActiveThreadCount() + ", ForkJoinPool.commonPool() has queued submissions: " + ForkJoinPool.commonPool().hasQueuedSubmissions() + "\n" + ThreadDumper.dumpThreadsToString());
        }
        HighlightingSessionImpl session2 = (HighlightingSessionImpl)HighlightingSessionImpl.getOrCreateHighlightingSession(file2, progress, null);
        DaemonCodeAnalyzerImpl.wrap(() -> {
            if (!this.waitInOtherThread(60000, canChangeDocument)) {
                throw new TimeoutException("Unable to complete in 60s");
            }
            session2.waitForHighlightInfosApplied();
        });
        UIUtil.dispatchAllInvocationEvents();
        UIUtil.dispatchAllInvocationEvents();
        assert (progress.isCanceled() && progress.isDisposed());
        List<HighlightInfo> list2 = DaemonCodeAnalyzerImpl.getHighlights(document, null, project);
        List<HighlightInfo> list3 = list2;
        if (list3 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(25);
        }
        return list3;
        finally {
            DaemonProgressIndicator.setDebug(false);
            fileStatusMap.allowDirt(true);
            this.waitForTermination();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitInOtherThread(int millis, boolean canChangeDocument) throws Throwable {
        Disposable disposable = Disposer.newDisposable();
        this.myProject.getMessageBus().connect(disposable).subscribe(PsiModificationTracker.TOPIC, () -> {
            throw new IllegalStateException("You must not perform PSI modifications from inside highlighting");
        });
        if (!canChangeDocument) {
            this.myProject.getMessageBus().connect(disposable).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

                public void daemonCancelEventOccurred(@NotNull String reason) {
                    if (reason == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    throw new IllegalStateException("You must not cancel daemon inside highlighting test: " + reason);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$1", "daemonCancelEventOccurred"));
                }
            });
        }
        try {
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    return this.myPassExecutorService.waitFor(millis);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
            boolean bl = (Boolean)future2.get();
            return bl;
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    public void prepareForTest() {
        this.setUpdateByTimerEnabled(false);
        this.waitForTermination();
        this.clearReferences();
    }

    public void cleanupAfterTest() {
        if (this.myProject.isOpen()) {
            this.prepareForTest();
        }
    }

    public void waitForTermination() {
        this.myPassExecutorService.cancelAll(true);
    }

    public void settingsChanged() {
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        if (settings.isCodeHighlightingChanged(this.myLastSettings)) {
            this.restart();
        }
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)settings).clone();
    }

    public void updateVisibleHighlighters(@NotNull Editor editor) {
        if (editor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    public synchronized void setUpdateByTimerEnabled(boolean value) {
        this.myUpdateByTimerEnabled = value;
        this.stopProcess(value, "Update by timer change");
    }

    public void disableUpdateByTimer(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(27);
        }
        this.setUpdateByTimerEnabled(false);
        this.myDisableCount.incrementAndGet();
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.register((Disposable)parentDisposable, () -> {
            if (this.myDisableCount.decrementAndGet() == 0) {
                this.setUpdateByTimerEnabled(true);
            }
        });
    }

    synchronized boolean isUpdateByTimerEnabled() {
        return this.myUpdateByTimerEnabled;
    }

    public void setImportHintsEnabled(@NotNull PsiFile file2, boolean value) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(28);
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (value) {
            this.myDisabledHintsFiles.remove(vFile);
            this.stopProcess(true, "Import hints change");
        } else {
            this.myDisabledHintsFiles.add(vFile);
            HintManager.getInstance().hideAllHints();
        }
    }

    public void resetImportHintsEnabledForProject() {
        this.myDisabledHintsFiles.clear();
    }

    public void setHighlightingEnabled(@NotNull PsiFile file2, boolean value) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(29);
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
        if (value) {
            this.myDisabledHighlightingFiles.remove(virtualFile);
        } else {
            this.myDisabledHighlightingFiles.add(virtualFile);
        }
    }

    public boolean isHighlightingAvailable(@Nullable PsiFile file2) {
        if (file2 == null || !file2.isPhysical()) {
            return false;
        }
        if (this.myDisabledHighlightingFiles.contains(PsiUtilCore.getVirtualFile((PsiElement)file2))) {
            return false;
        }
        if (file2 instanceof PsiCompiledElement) {
            return false;
        }
        FileType fileType = file2.getFileType();
        return !fileType.isBinary();
    }

    public boolean isImportHintsEnabled(@NotNull PsiFile file2) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(30);
        }
        return this.isAutohintsAvailable(file2) && !this.myDisabledHintsFiles.contains(file2.getVirtualFile());
    }

    public boolean isAutohintsAvailable(PsiFile file2) {
        return this.isHighlightingAvailable(file2) && !(file2 instanceof PsiCompiledElement);
    }

    public void restart() {
        this.doRestart();
    }

    boolean doRestart() {
        this.myFileStatusMap.markAllFilesDirty("Global restart");
        return this.stopProcess(true, "Global restart");
    }

    public void restart(@NotNull PsiFile file2) {
        Document document;
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(31);
        }
        if ((document = this.myPsiDocumentManager.getCachedDocument(file2)) == null) {
            return;
        }
        String reason = "Psi file restart: " + file2.getName();
        this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, document.getTextLength()), file2.getTextLength(), reason);
        this.stopProcess(true, reason);
    }

    @NotNull
    public List<TextEditorHighlightingPass> getPassesToShowProgressFor(Document document) {
        List<TextEditorHighlightingPass> allPasses = this.myPassExecutorService.getAllSubmittedPasses();
        ArrayList<TextEditorHighlightingPass> result2 = new ArrayList<TextEditorHighlightingPass>(allPasses.size());
        for (TextEditorHighlightingPass pass : allPasses) {
            if (pass.getDocument() != document && pass.getDocument() != null) continue;
            result2.add(pass);
        }
        ArrayList<TextEditorHighlightingPass> arrayList = result2;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    boolean isAllAnalysisFinished(@NotNull PsiFile file2) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(33);
        }
        if (this.myDisposed) {
            return false;
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(file2);
        return document != null && document.getModificationStamp() == file2.getViewProvider().getModificationStamp() && this.myFileStatusMap.allDirtyScopesAreNull(document);
    }

    @Override
    public boolean isErrorAnalyzingFinished(@NotNull PsiFile file2) {
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(34);
        }
        if (this.myDisposed) {
            return false;
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(file2);
        return document != null && document.getModificationStamp() == file2.getViewProvider().getModificationStamp() && this.myFileStatusMap.getFileDirtyScope(document, 4) == null;
    }

    @Override
    @NotNull
    public FileStatusMap getFileStatusMap() {
        FileStatusMap fileStatusMap = this.myFileStatusMap;
        if (fileStatusMap == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(35);
        }
        return fileStatusMap;
    }

    public synchronized boolean isRunning() {
        return !this.myUpdateProgress.isCanceled();
    }

    public boolean isRunningOrPending() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.isRunning() || !this.myUpdateRunnableFuture.isDone();
    }

    synchronized boolean stopProcess(boolean toRestartAlarm, @NotNull @NonNls String reason) {
        boolean restart;
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(36);
        }
        boolean canceled = this.cancelUpdateProgress(toRestartAlarm, reason);
        boolean bl = restart = toRestartAlarm && !this.myDisposed && this.myInitialized;
        if (restart && this.myUpdateRunnableFuture.isDone()) {
            this.myUpdateRunnableFuture = this.myAlarm.schedule(this.myUpdateRunnable, (long)this.mySettings.AUTOREPARSE_DELAY, TimeUnit.MILLISECONDS);
        }
        return canceled;
    }

    private synchronized boolean cancelUpdateProgress(boolean toRestartAlarm, @NotNull @NonNls String reason) {
        if (reason == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(37);
        }
        DaemonProgressIndicator updateProgress = this.myUpdateProgress;
        if (this.myDisposed) {
            return false;
        }
        boolean wasCanceled = updateProgress.isCanceled();
        this.myPassExecutorService.cancelAll(false);
        if (!wasCanceled) {
            PassExecutorService.log(updateProgress, null, "Cancel", reason, toRestartAlarm);
            updateProgress.cancel();
            return true;
        }
        return false;
    }

    static boolean processHighlightsNearOffset(@NotNull Document document, @NotNull Project project, @NotNull HighlightSeverity minSeverity, int offset, boolean includeFixRange, @NotNull Processor<HighlightInfo> processor2) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(38);
        }
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(39);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(40);
        }
        if (processor2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(41);
        }
        return DaemonCodeAnalyzerImpl.processHighlights(document, project, null, 0, document.getTextLength(), (Processor<HighlightInfo>)((Processor)info -> {
            if (minSeverity == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(59);
            }
            if (processor2 == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(60);
            }
            if (!DaemonCodeAnalyzerImpl.isOffsetInsideHighlightInfo(offset, info, includeFixRange)) {
                return true;
            }
            int compare = info.getSeverity().compareTo(minSeverity);
            return compare < 0 || processor2.process(info);
        }));
    }

    @Nullable
    public HighlightInfo findHighlightByOffset(@NotNull Document document, int offset, boolean includeFixRange) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(42);
        }
        return this.findHighlightByOffset(document, offset, includeFixRange, HighlightSeverity.INFORMATION);
    }

    @Nullable
    HighlightInfo findHighlightByOffset(@NotNull Document document, int offset, boolean includeFixRange, @NotNull HighlightSeverity minSeverity) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(43);
        }
        if (minSeverity == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(44);
        }
        SmartList foundInfoList = new SmartList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(document, this.myProject, minSeverity, offset, includeFixRange, (Processor<HighlightInfo>)((Processor)arg_0 -> DaemonCodeAnalyzerImpl.lambda$findHighlightByOffset$10((List)foundInfoList, arg_0)));
        if (foundInfoList.isEmpty()) {
            return null;
        }
        if (foundInfoList.size() == 1) {
            return (HighlightInfo)foundInfoList.get(0);
        }
        return HighlightInfoComposite.create((List<HighlightInfo>)foundInfoList);
    }

    private static boolean isOffsetInsideHighlightInfo(int offset, @NotNull HighlightInfo info, boolean includeFixRange) {
        RangeHighlighterEx highlighter;
        if (info == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(45);
        }
        if ((highlighter = info.getHighlighter()) == null || !highlighter.isValid()) {
            return false;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        if (startOffset <= offset && offset <= endOffset) {
            return true;
        }
        if (!includeFixRange) {
            return false;
        }
        RangeMarker fixMarker = info.fixMarker;
        if (fixMarker != null) {
            if (!fixMarker.isValid()) {
                return false;
            }
            startOffset = fixMarker.getStartOffset();
            endOffset = fixMarker.getEndOffset();
            return startOffset <= offset && offset <= endOffset;
        }
        return false;
    }

    @NotNull
    public static List<LineMarkerInfo> getLineMarkers(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(46);
        }
        if (project == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(47);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<LineMarkerInfo> result2 = new ArrayList<LineMarkerInfo>();
        LineMarkersUtil.processLineMarkers(project, document, (Segment)new TextRange(0, document.getTextLength()), -1, (Processor<LineMarkerInfo>)new CommonProcessors.CollectProcessor(result2));
        ArrayList<LineMarkerInfo> arrayList = result2;
        if (arrayList == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    @Nullable
    public IntentionHintComponent getLastIntentionHint() {
        return ((IntentionsUIImpl)IntentionsUI.getInstance(this.myProject)).getLastIntentionHint();
    }

    @Nullable
    public Element getState() {
        Element state2 = new Element("state");
        if (this.myDisabledHintsFiles.isEmpty()) {
            return state2;
        }
        SmartList array = new SmartList();
        for (VirtualFile file2 : this.myDisabledHintsFiles) {
            if (!file2.isValid()) continue;
            array.add(file2.getUrl());
        }
        if (!array.isEmpty()) {
            Collections.sort(array);
            Element disableHintsElement = new Element(DISABLE_HINTS_TAG);
            state2.addContent(disableHintsElement);
            for (String url : array) {
                disableHintsElement.addContent(new Element(FILE_TAG).setAttribute(URL_ATT, url));
            }
        }
        return state2;
    }

    public void loadState(@NotNull Element state2) {
        if (state2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(49);
        }
        this.myDisabledHintsFiles.clear();
        Element element = state2.getChild(DISABLE_HINTS_TAG);
        if (element != null) {
            for (Element e : element.getChildren(FILE_TAG)) {
                VirtualFile file2;
                String url = e.getAttributeValue(URL_ATT);
                if (url == null || (file2 = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
                this.myDisabledHintsFiles.add(file2);
            }
        }
    }

    @NotNull
    private synchronized DaemonProgressIndicator createUpdateProgress(@NotNull Collection<FileEditor> fileEditors) {
        DaemonProgressIndicator old;
        if (fileEditors == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(50);
        }
        if (!(old = this.myUpdateProgress).isCanceled()) {
            old.cancel();
        }
        MyDaemonProgressIndicator progress = new MyDaemonProgressIndicator(this.myProject, fileEditors);
        progress.setModalityProgress(null);
        progress.start();
        ((DaemonCodeAnalyzer.DaemonListener)this.myProject.getMessageBus().syncPublisher(DAEMON_EVENT_TOPIC)).daemonStarting(fileEditors);
        this.myUpdateProgress = progress;
        MyDaemonProgressIndicator myDaemonProgressIndicator = progress;
        if (myDaemonProgressIndicator == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(51);
        }
        return myDaemonProgressIndicator;
    }

    public void autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(52);
        }
        if (file2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(53);
        }
        for (ReferenceImporter importer : (ReferenceImporter[])Extensions.getExtensions(ReferenceImporter.EP_NAME)) {
            if (importer.autoImportReferenceAtCursor(editor, file2)) break;
        }
    }

    @NotNull
    public synchronized DaemonProgressIndicator getUpdateProgress() {
        DaemonProgressIndicator daemonProgressIndicator = this.myUpdateProgress;
        if (daemonProgressIndicator == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(54);
        }
        return daemonProgressIndicator;
    }

    @NotNull
    private Collection<FileEditor> getSelectedEditors() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<Editor> editors = this.getActiveEditors();
        THashSet activeTextEditors = new THashSet(editors.size());
        for (Editor editor : editors) {
            if (editor.isDisposed()) continue;
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
            activeTextEditors.add(textEditor);
        }
        if (ApplicationManager.getApplication().getCurrentModalityState() != ModalityState.NON_MODAL) {
            THashSet tHashSet = activeTextEditors;
            if (tHashSet == null) {
                DaemonCodeAnalyzerImpl.$$$reportNull$$$0(55);
            }
            return tHashSet;
        }
        THashSet result2 = new THashSet();
        THashSet files2 = new THashSet(activeTextEditors.size());
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            FileEditor[] tabEditors;
            for (FileEditor tabEditor : tabEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
                if (!tabEditor.isValid()) continue;
                VirtualFile file2 = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile(tabEditor);
                if (file2 != null) {
                    files2.add(file2);
                }
                result2.add(tabEditor);
            }
        }
        for (FileEditor fileEditor : activeTextEditors) {
            VirtualFile file3 = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile(fileEditor);
            if (file3 != null && files2.contains(file3)) continue;
            result2.add(fileEditor);
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(56);
        }
        return tHashSet;
    }

    @NotNull
    private List<Editor> getActiveEditors() {
        List<Editor> list2 = this.myEditorTracker.getActiveEditors();
        if (list2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(57);
        }
        return list2;
    }

    private static void wrap(@NotNull ThrowableRunnable runnable2) {
        if (runnable2 == null) {
            DaemonCodeAnalyzerImpl.$$$reportNull$$$0(58);
        }
        try {
            runnable2.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$findHighlightByOffset$10(List foundInfoList, HighlightInfo info) {
        if (info.getSeverity() == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY) {
            return true;
        }
        if (!foundInfoList.isEmpty()) {
            HighlightInfo foundInfo = (HighlightInfo)foundInfoList.get(0);
            int compare = foundInfo.getSeverity().compareTo(info.getSeverity());
            if (compare < 0) {
                foundInfoList.clear();
            } else if (compare > 0) {
                return true;
            }
        }
        foundInfoList.add(info);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 25: 
            case 32: 
            case 35: 
            case 48: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 25: 
            case 32: 
            case 35: 
            case 48: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "daemonCodeAnalyzerSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDocumentManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedScopeManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyValidationManager";
                break;
            }
            case 6: 
            case 17: 
            case 22: 
            case 38: 
            case 42: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 25: 
            case 32: 
            case 35: 
            case 48: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl";
                break;
            }
            case 10: 
            case 21: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_TAG;
                break;
            }
            case 14: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditors";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 26: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 40: 
            case 44: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSeverity";
                break;
            }
            case 41: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditors";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlights";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileLevelHighlights";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "runMainPasses";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "runPasses";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassesToShowProgressFor";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatusMap";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMarkers";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateProgress";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateProgress";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHighlights";
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 25: 
            case 32: 
            case 35: 
            case 48: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileLevelHighlights";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cleanFileLevelHighlights";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addFileLevelHighlight";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runMainPasses";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mustWaitForSmartMode";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runPasses";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateVisibleHighlighters";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "disableUpdateByTimer";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setImportHintsEnabled";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightingEnabled";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isImportHintsEnabled";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "restart";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isAllAnalysisFinished";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isErrorAnalyzingFinished";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "stopProcess";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "cancelUpdateProgress";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processHighlightsNearOffset";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findHighlightByOffset";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetInsideHighlightInfo";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkers";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateProgress";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "autoImportReferenceAtCursor";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processHighlightsNearOffset$9";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 25: 
            case 32: 
            case 35: 
            case 48: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDaemonProgressIndicator
    extends DaemonProgressIndicator {
        private final Project myProject;
        private Collection<FileEditor> myFileEditors;

        public MyDaemonProgressIndicator(Project project, Collection<FileEditor> fileEditors) {
            this.myFileEditors = fileEditors;
            this.myProject = project;
        }

        @Override
        public void stopIfRunning() {
            super.stopIfRunning();
            ((DaemonCodeAnalyzer.DaemonListener)this.myProject.getMessageBus().syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC)).daemonFinished(this.myFileEditors);
            this.myFileEditors = null;
            HighlightingSessionImpl.clearProgressIndicator(this);
        }
    }

    private static class UpdateRunnable
    implements Runnable {
        private Project myProject;

        private UpdateRunnable(@NotNull Project project) {
            if (project == null) {
                UpdateRunnable.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void run() {
            DaemonCodeAnalyzerImpl dca;
            ApplicationManager.getApplication().assertIsDispatchThread();
            Project project = this.myProject;
            if (project == null || !project.isInitialized() || project.isDisposed() || PowerSaveMode.isEnabled() || (dca = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project)).myDisposed) {
                return;
            }
            Collection activeEditors = dca.getSelectedEditors();
            boolean updateByTimerEnabled = dca.isUpdateByTimerEnabled();
            PassExecutorService.log(dca.getUpdateProgress(), null, "Update Runnable. myUpdateByTimerEnabled:", updateByTimerEnabled, " something disposed:", PowerSaveMode.isEnabled() || !this.myProject.isInitialized(), " activeEditors:", activeEditors);
            if (!updateByTimerEnabled) {
                return;
            }
            if (activeEditors.isEmpty()) {
                return;
            }
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                return;
            }
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)dca.myPsiDocumentManager;
            if (documentManager.hasUncommitedDocuments()) {
                AutoPopupController.runTransactionWithEverythingCommitted(this.myProject, this);
                return;
            }
            if (RefResolveService.ENABLED && !RefResolveService.getInstance((Project)this.myProject).isUpToDate() && RefResolveService.getInstance((Project)this.myProject).getQueueSize() == 1) {
                return;
            }
            THashMap passes = new THashMap(activeEditors.size());
            for (Object fileEditor : activeEditors) {
                BackgroundEditorHighlighter backgroundEditorHighlighter = fileEditor.getBackgroundHighlighter();
                if (backgroundEditorHighlighter == null) continue;
                HighlightingPass[] highlightingPasses = backgroundEditorHighlighter.createPassesForEditor();
                passes.put(fileEditor, highlightingPasses);
            }
            boolean hasPasses = false;
            if (HeavyProcessLatch.INSTANCE.isRunning()) {
                for (Map.Entry entry : passes.entrySet()) {
                    HighlightingPass[] filtered = (HighlightingPass[])Arrays.stream((Object[])entry.getValue()).filter(DumbService::isDumbAware).toArray(HighlightingPass[]::new);
                    entry.setValue(filtered);
                    hasPasses |= filtered.length != 0;
                }
                if (!hasPasses) {
                    HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> dca.stopProcess(true, "re-scheduled to execute after heavy processing finished"));
                    return;
                }
            }
            dca.cancelUpdateProgress(true, "Cancel by alarm");
            dca.myUpdateRunnableFuture.cancel(false);
            DaemonProgressIndicator progress = dca.createUpdateProgress(passes.keySet());
            dca.myPassExecutorService.submitPasses((Map<FileEditor, HighlightingPass[]>)passes, progress);
        }

        private void clearFieldsOnDispose() {
            this.myProject = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$UpdateRunnable", "<init>"));
        }
    }
}

