/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.CustomHighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.PsiTodoSearchHelperImpl;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.NotNullProducer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralHighlightingPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass");
    private static final String PRESENTABLE_NAME = DaemonBundle.message((String)"pass.syntax", (Object[])new Object[0]);
    private static final Key<Boolean> HAS_ERROR_ELEMENT = Key.create((String)"HAS_ERROR_ELEMENT");
    static final Condition<PsiFile> SHOULD_HIGHLIGHT_FILTER = file2 -> HighlightingLevelManager.getInstance(file2.getProject()).shouldHighlight((PsiElement)file2);
    private static final Random RESTART_DAEMON_RANDOM = new Random();
    final boolean myUpdateAll;
    final ProperTextRange myPriorityRange;
    final List<HighlightInfo> myHighlights;
    protected volatile boolean myHasErrorElement;
    private volatile boolean myErrorFound;
    final EditorColorsScheme myGlobalScheme;
    private volatile NotNullProducer<HighlightVisitor[]> myHighlightVisitorProducer;
    private static final Key<AtomicInteger> HIGHLIGHT_VISITOR_INSTANCE_COUNT = new Key("HIGHLIGHT_VISITOR_INSTANCE_COUNT");
    private static final int POST_UPDATE_ALL = 5;

    public GeneralHighlightingPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(1);
        }
        if (document == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(2);
        }
        if (priorityRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(3);
        }
        if (highlightInfoProcessor == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(4);
        }
        super(project, document, PRESENTABLE_NAME, file2, editor, TextRange.create((int)startOffset, (int)endOffset), true, highlightInfoProcessor);
        this.myHighlights = new ArrayList<HighlightInfo>();
        this.myHighlightVisitorProducer = this::cloneHighlightVisitors;
        this.myUpdateAll = updateAll;
        this.myPriorityRange = priorityRange;
        PsiUtilCore.ensureValid((PsiElement)file2);
        boolean wholeFileHighlighting = this.isWholeFileHighlighting();
        this.myHasErrorElement = !wholeFileHighlighting && Boolean.TRUE.equals(this.getFile().getUserData(HAS_ERROR_ELEMENT));
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        this.myErrorFound = !wholeFileHighlighting && fileStatusMap.wasErrorFound(this.getDocument());
        this.setProgressLimit(document.getTextLength() / 2);
        this.myGlobalScheme = editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = super.getDocument();
        if (document == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(6);
        }
        return document;
    }

    @NotNull
    private HighlightVisitor[] cloneHighlightVisitors() {
        int oldCount = this.incVisitorUsageCount(1);
        HighlightVisitor[] highlightVisitors = (HighlightVisitor[])Extensions.getExtensions(HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)this.myProject);
        if (oldCount != 0) {
            HighlightVisitor[] clones = new HighlightVisitor[highlightVisitors.length];
            for (int i = 0; i < highlightVisitors.length; ++i) {
                HighlightVisitor highlightVisitor = highlightVisitors[i];
                HighlightVisitor cloned = highlightVisitor.clone();
                assert (cloned.getClass() == highlightVisitor.getClass()) : highlightVisitor.getClass() + ".clone() must return a copy of " + highlightVisitor.getClass() + "; but got: " + cloned + " of " + cloned.getClass();
                clones[i] = cloned;
            }
            highlightVisitors = clones;
        }
        if (highlightVisitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(7);
        }
        return highlightVisitors;
    }

    @NotNull
    private HighlightVisitor[] filterVisitors(@NotNull HighlightVisitor[] highlightVisitors, @NotNull PsiFile psiFile) {
        if (highlightVisitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(8);
        }
        if (psiFile == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(9);
        }
        ArrayList<HighlightVisitor> visitors = new ArrayList<HighlightVisitor>(highlightVisitors.length);
        List<HighlightVisitor> list2 = Arrays.asList(highlightVisitors);
        for (HighlightVisitor visitor2 : DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(list2)) {
            if (visitor2 instanceof RainbowVisitor && !RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)this.getColorsScheme(), psiFile.getLanguage()) || !visitor2.suitableForFile(psiFile)) continue;
            visitors.add(visitor2);
        }
        if (visitors.isEmpty()) {
            LOG.error("No visitors registered. list=" + list2 + "; all visitors are:" + Arrays.asList(Extensions.getExtensions(HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)this.myProject)));
        }
        HighlightVisitor[] highlightVisitorArray = visitors.toArray(new HighlightVisitor[0]);
        if (highlightVisitorArray == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(10);
        }
        return highlightVisitorArray;
    }

    void setHighlightVisitorProducer(@NotNull NotNullProducer<HighlightVisitor[]> highlightVisitorProducer) {
        if (highlightVisitorProducer == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(11);
        }
        this.myHighlightVisitorProducer = highlightVisitorProducer;
    }

    @NotNull
    HighlightVisitor[] getHighlightVisitors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(12);
        }
        HighlightVisitor[] highlightVisitorArray = this.filterVisitors((HighlightVisitor[])this.myHighlightVisitorProducer.produce(), psiFile);
        if (highlightVisitorArray == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(13);
        }
        return highlightVisitorArray;
    }

    int incVisitorUsageCount(int delta) {
        AtomicInteger count = (AtomicInteger)this.myProject.getUserData(HIGHLIGHT_VISITOR_INSTANCE_COUNT);
        if (count == null) {
            count = (AtomicInteger)((UserDataHolderEx)this.myProject).putUserDataIfAbsent(HIGHLIGHT_VISITOR_INSTANCE_COUNT, (Object)new AtomicInteger(0));
        }
        int old = count.getAndAdd(delta);
        assert (old + delta >= 0) : old + ";" + delta;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(14);
        }
        ArrayList<HighlightInfo> outsideResult = new ArrayList<HighlightInfo>(100);
        ArrayList<HighlightInfo> insideResult = new ArrayList<HighlightInfo>(100);
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        HighlightVisitor[] filteredVisitors = this.getHighlightVisitors(this.getFile());
        try {
            boolean success2;
            ArrayList dividedElements = new ArrayList();
            Divider.divideInsideAndOutsideAllRoots(this.getFile(), this.myRestrictRange, (TextRange)this.myPriorityRange, SHOULD_HIGHLIGHT_FILTER, (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(dividedElements));
            List allInsideElements = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List<PsiElement> inside = dividedForRoot.inside;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? inside.subList(0, inside.size() - 1) : inside;
            }));
            List allInsideRanges = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List<ProperTextRange> insideRanges = dividedForRoot.insideRanges;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(dividedForRoot.inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? insideRanges.subList(0, insideRanges.size() - 1) : insideRanges;
            }));
            List allOutsideElements = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List outside = dividedForRoot.outside;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(dividedForRoot.inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? ContainerUtil.append(outside, (Object[])new PsiElement[]{lastInside}) : outside;
            }));
            List allOutsideRanges = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List outsideRanges = dividedForRoot.outsideRanges;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(dividedForRoot.inside);
                ProperTextRange lastInsideRange = (ProperTextRange)ContainerUtil.getLastItem(dividedForRoot.insideRanges);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? ContainerUtil.append(outsideRanges, (Object[])new ProperTextRange[]{lastInsideRange}) : outsideRanges;
            }));
            this.setProgressLimit(allInsideElements.size() + allOutsideElements.size());
            boolean forceHighlightParents = this.forceHighlightParents();
            if (!this.isDumbMode()) {
                GeneralHighlightingPass.highlightTodos(this.getFile(), this.getDocument().getCharsSequence(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), progress, this.myPriorityRange, insideResult, outsideResult);
            }
            if (success2 = this.collectHighlights(allInsideElements, allInsideRanges, allOutsideElements, allOutsideRanges, progress, filteredVisitors, insideResult, outsideResult, forceHighlightParents)) {
                this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), outsideResult, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
                if (this.myUpdateAll) {
                    daemonCodeAnalyzer.getFileStatusMap().setErrorFoundFlag(this.myProject, this.getDocument(), this.myErrorFound);
                }
            } else {
                GeneralHighlightingPass.cancelAndRestartDaemonLater(progress, this.myProject);
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
            this.myHighlights.addAll(insideResult);
            this.myHighlights.addAll(outsideResult);
        }
    }

    private boolean isWholeFileHighlighting() {
        return this.myUpdateAll && this.myRestrictRange.equalsToRange(0, this.getDocument().getTextLength());
    }

    @Override
    protected void applyInformationWithProgress() {
        this.getFile().putUserData(HAS_ERROR_ELEMENT, (Object)this.myHasErrorElement);
        if (this.myUpdateAll) {
            ((HighlightingSessionImpl)this.myHighlightingSession).applyInEDT(this::reportErrorsToWolf);
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        ArrayList<HighlightInfo> arrayList = new ArrayList<HighlightInfo>(this.myHighlights);
        if (arrayList == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private boolean collectHighlights(@NotNull List<PsiElement> elements1, @NotNull List<ProperTextRange> ranges1, @NotNull List<PsiElement> elements2, @NotNull List<ProperTextRange> ranges2, @NotNull ProgressIndicator progress, @NotNull HighlightVisitor[] visitors, @NotNull List<HighlightInfo> insideResult, @NotNull List<HighlightInfo> outsideResult, boolean forceHighlightParents) {
        if (elements1 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(16);
        }
        if (ranges1 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(17);
        }
        if (elements2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(18);
        }
        if (ranges2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(19);
        }
        if (progress == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(20);
        }
        if (visitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(21);
        }
        if (insideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(22);
        }
        if (outsideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(23);
        }
        THashSet skipParentsSet = new THashSet();
        HighlightInfoHolder holder = this.createInfoHolder(this.getFile());
        int chunkSize = Math.max(1, (elements1.size() + elements2.size()) / 100);
        boolean success2 = this.analyzeByVisitors(visitors, holder, 0, () -> this.lambda$collectHighlights$5(elements1, ranges1, chunkSize, progress, (Set)skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors, elements2, ranges2));
        ArrayList<HighlightInfo> postInfos = new ArrayList<HighlightInfo>(holder.size());
        for (int j = 0; j < holder.size(); ++j) {
            HighlightInfo info = holder.get(j);
            assert (info != null);
            postInfos.add(info);
        }
        this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), postInfos, this.getFile().getTextRange(), this.getFile().getTextRange(), 5);
        return success2;
    }

    private boolean analyzeByVisitors(@NotNull HighlightVisitor[] visitors, @NotNull HighlightInfoHolder holder, int i, @NotNull Runnable action) {
        if (visitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(24);
        }
        if (holder == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(25);
        }
        if (action == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(26);
        }
        boolean[] success2 = new boolean[]{true};
        if (i == visitors.length) {
            action.run();
        } else if (!visitors[i].analyze(this.getFile(), this.myUpdateAll, holder, () -> {
            if (visitors == null) {
                GeneralHighlightingPass.$$$reportNull$$$0(49);
            }
            if (holder == null) {
                GeneralHighlightingPass.$$$reportNull$$$0(50);
            }
            if (action == null) {
                GeneralHighlightingPass.$$$reportNull$$$0(51);
            }
            success2[0] = this.analyzeByVisitors(visitors, holder, i + 1, action);
        })) {
            success2[0] = false;
        }
        return success2[0];
    }

    private void runVisitors(@NotNull List<PsiElement> elements, @NotNull List<ProperTextRange> ranges, int chunkSize, @NotNull ProgressIndicator progress, @NotNull Set<? super PsiElement> skipParentsSet, @NotNull HighlightInfoHolder holder, @NotNull List<HighlightInfo> insideResult, @NotNull List<HighlightInfo> outsideResult, boolean forceHighlightParents, @NotNull HighlightVisitor[] visitors, @NotNull Stack<TextRange> nestedRange, @NotNull Stack<List<HighlightInfo>> nestedInfos) {
        if (elements == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(27);
        }
        if (ranges == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(28);
        }
        if (progress == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(29);
        }
        if (skipParentsSet == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(30);
        }
        if (holder == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(31);
        }
        if (insideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(32);
        }
        if (outsideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(33);
        }
        if (visitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(34);
        }
        if (nestedRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(35);
        }
        if (nestedInfos == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(36);
        }
        boolean failed = false;
        int nextLimit = chunkSize;
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            ProgressManager.checkCanceled();
            PsiElement parent = element.getParent();
            if (element != this.getFile() && !skipParentsSet.isEmpty() && element.getFirstChild() != null && skipParentsSet.contains(element)) {
                skipParentsSet.add((PsiElement)parent);
                continue;
            }
            boolean isErrorElement = element instanceof PsiErrorElement;
            if (isErrorElement) {
                this.myHasErrorElement = true;
            }
            for (HighlightVisitor visitor2 : visitors) {
                try {
                    visitor2.visit(element);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!failed) {
                        LOG.error("In file: " + this.myFile.getViewProvider().getVirtualFile(), (Throwable)e);
                    }
                    failed = true;
                }
            }
            if (i == nextLimit) {
                this.advanceProgress(chunkSize);
                nextLimit = i + chunkSize;
            }
            TextRange elementRange = (TextRange)ranges.get(i);
            List<HighlightInfo> infosForThisRange = holder.size() == 0 ? null : new ArrayList<HighlightInfo>(holder.size());
            for (int j = 0; j < holder.size(); ++j) {
                boolean isError;
                List<HighlightInfo> result2;
                HighlightInfo info = holder.get(j);
                if (!this.myRestrictRange.containsRange(info.getStartOffset(), info.getEndOffset())) continue;
                List<HighlightInfo> list2 = result2 = this.myPriorityRange.containsRange(info.getStartOffset(), info.getEndOffset()) && !(element instanceof PsiFile) ? insideResult : outsideResult;
                if (!result2.add(info)) continue;
                boolean bl = isError = info.getSeverity() == HighlightSeverity.ERROR;
                if (isError) {
                    if (!forceHighlightParents) {
                        skipParentsSet.add((PsiElement)parent);
                    }
                    this.myErrorFound = true;
                }
                info.setBijective(elementRange.equalsToRange(info.startOffset, info.endOffset) || isErrorElement);
                this.myHighlightInfoProcessor.infoIsAvailable(this.myHighlightingSession, info, (TextRange)this.myPriorityRange, this.myRestrictRange, 4);
                infosForThisRange.add(info);
            }
            holder.clear();
            while (!nestedRange.isEmpty() && elementRange.contains((TextRange)nestedRange.peek())) {
                TextRange oldRange = (TextRange)nestedRange.pop();
                List oldInfos = (List)nestedInfos.pop();
                if (!elementRange.equals((Object)oldRange)) continue;
                if (infosForThisRange == null) {
                    infosForThisRange = oldInfos;
                    continue;
                }
                if (oldInfos == null) continue;
                infosForThisRange.addAll(oldInfos);
            }
            nestedRange.push((Object)elementRange);
            nestedInfos.push(infosForThisRange);
            if (parent != null && Comparing.equal((Object)elementRange, (Object)parent.getTextRange())) continue;
            this.myHighlightInfoProcessor.allHighlightsForRangeAreProduced(this.myHighlightingSession, elementRange, infosForThisRange);
        }
        this.advanceProgress(elements.size() - (nextLimit - chunkSize));
    }

    private static void cancelAndRestartDaemonLater(@NotNull ProgressIndicator progress, @NotNull Project project) throws ProcessCanceledException {
        if (progress == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(37);
        }
        if (project == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(38);
        }
        progress.cancel();
        Application application = ApplicationManager.getApplication();
        int delay = application.isUnitTestMode() ? 0 : RESTART_DAEMON_RANDOM.nextInt(100);
        EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
            if (project == null) {
                GeneralHighlightingPass.$$$reportNull$$$0(48);
            }
            if (!project.isDisposed()) {
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }, (long)delay, TimeUnit.MILLISECONDS);
        throw new ProcessCanceledException();
    }

    private boolean forceHighlightParents() {
        boolean forceHighlightParents = false;
        for (HighlightRangeExtension extension : (HighlightRangeExtension[])Extensions.getExtensions(HighlightRangeExtension.EP_NAME)) {
            if (!extension.isForceHighlightParents(this.getFile())) continue;
            forceHighlightParents = true;
            break;
        }
        return forceHighlightParents;
    }

    protected HighlightInfoHolder createInfoHolder(@NotNull PsiFile file2) {
        if (file2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(39);
        }
        HighlightInfoFilter[] filters = (HighlightInfoFilter[])HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions();
        return new CustomHighlightInfoHolder(file2, this.getColorsScheme(), filters);
    }

    static void highlightTodos(@NotNull PsiFile file2, @NotNull CharSequence text2, int startOffset, int endOffset, @NotNull ProgressIndicator progress, @NotNull ProperTextRange priorityRange, @NotNull Collection<HighlightInfo> insideResult, @NotNull Collection<HighlightInfo> outsideResult) {
        PsiTodoSearchHelper helper;
        if (file2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(40);
        }
        if (text2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(41);
        }
        if (progress == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(42);
        }
        if (priorityRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(43);
        }
        if (insideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(44);
        }
        if (outsideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(45);
        }
        if ((helper = PsiTodoSearchHelper.SERVICE.getInstance((Project)file2.getProject())) == null || !GeneralHighlightingPass.shouldHighlightTodos(helper, file2)) {
            return;
        }
        TodoItem[] todoItems = helper.findTodoItems(file2, startOffset, endOffset);
        if (todoItems.length == 0) {
            return;
        }
        for (TodoItem todoItem : todoItems) {
            ProgressManager.checkCanceled();
            TextRange range2 = todoItem.getTextRange();
            TextAttributes attributes = todoItem.getPattern().getAttributes().getTextAttributes();
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.TODO).range(range2);
            builder2.textAttributes(attributes);
            String description = text2.subSequence(range2.getStartOffset(), range2.getEndOffset()).toString();
            builder2.description(description);
            builder2.unescapedToolTip(StringUtil.shortenPathWithEllipsis((String)description, (int)1024));
            HighlightInfo info = builder2.createUnconditionally();
            (priorityRange.containsRange(info.getStartOffset(), info.getEndOffset()) ? insideResult : outsideResult).add(info);
        }
    }

    private static boolean shouldHighlightTodos(PsiTodoSearchHelper helper, PsiFile file2) {
        if (helper instanceof PsiTodoSearchHelperImpl) {
            PsiTodoSearchHelperImpl helperImpl = (PsiTodoSearchHelperImpl)helper;
            return helperImpl.shouldHighlightInEditor(file2);
        }
        return false;
    }

    private void reportErrorsToWolf() {
        if (!this.getFile().getViewProvider().isPhysical()) {
            return;
        }
        Project project = this.getFile().getProject();
        if (!PsiManager.getInstance((Project)project).isInProject((PsiElement)this.getFile())) {
            return;
        }
        VirtualFile file2 = this.getFile().getVirtualFile();
        if (file2 == null) {
            return;
        }
        List<Problem> problems = GeneralHighlightingPass.convertToProblems(this.getInfos(), file2, this.myHasErrorElement);
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)project);
        boolean hasErrors = DaemonCodeAnalyzerEx.hasErrors(project, this.getDocument());
        if (!hasErrors || this.isWholeFileHighlighting()) {
            wolf.reportProblems(file2, problems);
        } else {
            wolf.weHaveGotProblems(file2, problems);
        }
    }

    @Override
    public double getProgress() {
        return this.myUpdateAll ? super.getProgress() : -1.0;
    }

    private static List<Problem> convertToProblems(@NotNull Collection<? extends HighlightInfo> infos, @NotNull VirtualFile file2, boolean hasErrorElement) {
        if (infos == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(46);
        }
        if (file2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(47);
        }
        SmartList problems = new SmartList();
        for (HighlightInfo highlightInfo : infos) {
            if (highlightInfo.getSeverity() != HighlightSeverity.ERROR) continue;
            ProblemImpl problem = new ProblemImpl(file2, highlightInfo, hasErrorElement);
            problems.add(problem);
        }
        return problems;
    }

    @Override
    public String toString() {
        return super.toString() + " updateAll=" + this.myUpdateAll + " range= " + this.myRestrictRange;
    }

    private /* synthetic */ void lambda$collectHighlights$5(@NotNull List elements1, @NotNull List ranges1, int chunkSize, @NotNull ProgressIndicator progress, Set skipParentsSet, HighlightInfoHolder holder, @NotNull List insideResult, @NotNull List outsideResult, boolean forceHighlightParents, @NotNull HighlightVisitor[] visitors, @NotNull List elements2, @NotNull List ranges2) {
        if (elements1 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(52);
        }
        if (ranges1 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(53);
        }
        if (progress == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(54);
        }
        if (insideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(55);
        }
        if (outsideResult == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(56);
        }
        if (visitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(57);
        }
        if (elements2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(58);
        }
        if (ranges2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(59);
        }
        Stack nestedRange = new Stack();
        Stack nestedInfos = new Stack();
        this.runVisitors(elements1, ranges1, chunkSize, progress, skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors, (Stack<TextRange>)nestedRange, (Stack<List<HighlightInfo>>)nestedInfos);
        ProperTextRange priorityIntersection = this.myPriorityRange.intersection(this.myRestrictRange);
        if (!(elements1.isEmpty() && insideResult.isEmpty() || priorityIntersection == null)) {
            this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), insideResult, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        }
        this.runVisitors(elements2, ranges2, chunkSize, progress, skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors, (Stack<TextRange>)nestedRange, (Stack<List<HighlightInfo>>)nestedInfos);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 39: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightVisitors";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightVisitorProducer";
                break;
            }
            case 14: 
            case 20: 
            case 29: 
            case 37: 
            case 42: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 16: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements1";
                break;
            }
            case 17: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges1";
                break;
            }
            case 18: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 19: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges2";
                break;
            }
            case 21: 
            case 24: 
            case 34: 
            case 49: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitors";
                break;
            }
            case 22: 
            case 32: 
            case 44: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insideResult";
                break;
            }
            case 23: 
            case 33: 
            case 45: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outsideResult";
                break;
            }
            case 25: 
            case 31: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 26: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipParentsSet";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedRange";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedInfos";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneHighlightVisitors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterVisitors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightVisitors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterVisitors";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightVisitorProducer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightVisitors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlights";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "analyzeByVisitors";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "runVisitors";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRestartDaemonLater";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createInfoHolder";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "highlightTodos";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblems";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$cancelAndRestartDaemonLater$7";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$analyzeByVisitors$6";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectHighlights$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

